/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem;

import com.sun.kvem.Lime;
import com.sun.kvem.lime.Profiler;
import com.sun.kvem.sublime.SublimeExecutorPool;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class Sublime
extends Lime {
    public static final Logger LOGGER = Logger.getLogger(Sublime.class);
    private AtomicInteger deviceIdHolder;
    private int productUniqueId;
    private boolean connected;
    private Thread processThread;
    private static Object initLock = new Object();
    private static Profiler globalProfiler;
    private static String tempFilesDirectory;

    public Sublime() {
        System.loadLibrary("sublime");
        globalProfiler = this.profiler;
    }

    public void setProductUniqueId(int n) {
        this.productUniqueId = n;
    }

    public void setDeviceIdHolder(AtomicInteger atomicInteger) {
        this.deviceIdHolder = atomicInteger;
    }

    public static boolean isWindows() {
        String string = System.getProperties().getProperty("os.name");
        if (string.length() < 7) {
            return false;
        }
        return string.substring(0, 7).equalsIgnoreCase("windows");
    }

    public static void processRequest(byte[] byArray) {
        try {
            SublimeExecutorPool.processRequest(byArray);
        }
        catch (InterruptedException interruptedException) {
            System.err.println("LIME call interrupted: " + interruptedException);
        }
    }

    public static native void returnResult(byte[] var0);

    public static native void process();

    public static native void stopProcess();

    public static native int getSublimeProcessId();

    public static native void setSublimeProcessId(int var0);

    public static native void setTempFilesDirectory(String var0);

    public static void profileMethodCallStart(Method method, Object[] objectArray) {
        globalProfiler.profileMethodCallStart(method, objectArray);
    }

    public static void profileMethodCallEnd(Method method, Object[] objectArray) {
        globalProfiler.profileMethodCallEnd(method, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Process runClient(String string, String[] stringArray, String[] stringArray2, File stringArray3) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        arrayList.addAll(Arrays.asList(stringArray));
        ProcessBuilder processBuilder = new ProcessBuilder(arrayList).directory((File)stringArray3);
        Map<String, String> map = processBuilder.environment();
        map.put("LIME_TRACE", debug ? "1" : "0");
        map.put("LIME_SYNCH", "1");
        if (!Sublime.isWindows()) {
            Object object = stringArray3;
            tempFilesDirectory = ((File)object).getAbsolutePath();
            ((File)object).delete();
            object = new File(tempFilesDirectory);
            ((File)object).mkdir();
            tempFilesDirectory = ((File)object).getAbsolutePath();
            Sublime.setTempFilesDirectory(tempFilesDirectory);
            map.put("LIME_TMP_DIR", ((File)object).getAbsolutePath());
        }
        if (stringArray2 != null) {
            for (String string2 : stringArray2) {
                int n = string2.indexOf("=");
                if (n == -1) continue;
                map.put(string2.substring(0, n - 1), string2.substring(n + 1));
            }
        }
        if (debug) {
            System.out.println("LIME: argv = " + arrayList);
            System.out.println("LIME: env = " + map);
            System.out.flush();
        }
        this.connected = true;
        int n = this.deviceIdHolder.get() << 17 | this.productUniqueId << 1;
        Sublime.setSublimeProcessId(n);
        Object object = initLock;
        synchronized (object) {
            this.processThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    Sublime.process();
                }
            }, "Sublime process thread");
            this.processThread.start();
            try {
                initLock.wait();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        processBuilder.environment().put("SUBLIME_PROC_ID", String.valueOf(Sublime.getSublimeProcessId()));
        object = processBuilder.start();
        return object;
    }

    public synchronized void disconnect() {
        if (this.connected) {
            if (debug) {
                System.out.println("LIME: disconnect");
            }
            Sublime.stopProcess();
            try {
                this.processThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(System.out);
            PrintWriter printWriter = new PrintWriter(outputStreamWriter);
            this.profiler.writeReport(printWriter);
            printWriter.flush();
            this.connected = false;
        }
    }

    public Object getLock() {
        return this.lock;
    }

    public void incrementEventCount() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseInitLock() {
        Object object = initLock;
        synchronized (object) {
            initLock.notify();
        }
    }
}

