/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.sublime;

import java.io.DataOutputStream;
import java.io.OutputStream;

public class BufferPool {
    private static byte[][] buffers = new byte[][]{null};
    private static boolean[] locks = new boolean[]{false};
    private static BufferDataOutputStream[] outputStreams = new BufferDataOutputStream[]{null};

    public static synchronized byte[] getBuffer(int n) {
        int n2 = BufferPool.selectBuffer(n);
        return buffers[n2];
    }

    private static synchronized int selectBuffer(int n) {
        int n2;
        for (n2 = 0; n2 < buffers.length && buffers[n2] != null; ++n2) {
            if (locks[n2] || buffers[n2].length < n) continue;
            BufferPool.locks[n2] = true;
            return n2;
        }
        if (n2 == buffers.length) {
            byte[][] byArrayArray = new byte[buffers.length * 2][];
            System.arraycopy(buffers, 0, byArrayArray, 0, buffers.length);
            buffers = byArrayArray;
            boolean[] blArray = new boolean[locks.length * 2];
            System.arraycopy(locks, 0, blArray, 0, locks.length);
            locks = blArray;
            BufferDataOutputStream[] bufferDataOutputStreamArray = new BufferDataOutputStream[outputStreams.length * 2];
            System.arraycopy(outputStreams, 0, bufferDataOutputStreamArray, 0, outputStreams.length);
            outputStreams = bufferDataOutputStreamArray;
        }
        BufferPool.buffers[n2] = new byte[n];
        BufferPool.locks[n2] = true;
        return n2;
    }

    public static synchronized void freeBuffer(byte[] byArray) {
        for (int i = 0; i < buffers.length; ++i) {
            if (buffers[i] != byArray) continue;
            BufferPool.locks[i] = false;
            return;
        }
    }

    public static synchronized BufferDataOutputStream getOutputStream(int n) {
        int n2 = BufferPool.selectBuffer(n);
        if (outputStreams[n2] == null) {
            BufferPool.outputStreams[n2] = new BufferDataOutputStream(n2);
        } else {
            BufferPool.outputStreams[n2].clear();
        }
        return outputStreams[n2];
    }

    static class BufferDataOutputStream
    extends DataOutputStream {
        BufferDataOutputStream(int n) {
            super(new BufferOutputStream(n));
        }

        private void clear() {
            ((BufferOutputStream)this.out).clear();
        }

        byte[] getBuffer() {
            return ((BufferOutputStream)this.out).buffer;
        }

        int getSize() {
            return ((BufferOutputStream)this.out).bufferOffset;
        }
    }

    private static class BufferOutputStream
    extends OutputStream {
        private final int index;
        private byte[] buffer;
        private int bufferOffset = 0;

        BufferOutputStream(int n) {
            this.index = n;
            this.buffer = buffers[n];
        }

        void clear() {
            this.bufferOffset = 0;
        }

        private void enlargeBuffer() {
            buffers[this.index] = new byte[Math.max(1, this.buffer.length) * 2];
            System.arraycopy(this.buffer, 0, buffers[this.index], 0, this.buffer.length);
            this.buffer = buffers[this.index];
        }

        @Override
        public synchronized void write(int n) {
            if (this.bufferOffset == this.buffer.length) {
                this.enlargeBuffer();
            }
            this.buffer[this.bufferOffset++] = (byte)n;
        }

        @Override
        public synchronized void write(byte[] byArray, int n, int n2) {
            while (this.buffer.length - this.bufferOffset < n2) {
                this.enlargeBuffer();
            }
            System.arraycopy(byArray, n, this.buffer, this.bufferOffset, n2);
            this.bufferOffset += n2;
        }

        @Override
        public synchronized void write(byte[] byArray) {
            this.write(byArray, 0, byArray.length);
        }
    }
}

