/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.sublime;

import com.sun.kvem.lime.DataHandler;
import com.sun.kvem.lime.DataManager;
import com.sun.kvem.sublime.BufferPool;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MethodLookup {
    private static final Logger LOGGER = Logger.getLogger(MethodLookup.class);
    private static List<Method> methodList = new ArrayList<Method>();
    private static Map<Method, DataHandler[]> parameterTypeMap = new HashMap<Method, DataHandler[]>();
    private static Map<Method, DataHandler> resultTypeMap = new HashMap<Method, DataHandler>();

    private static String readLine(DataInputStream dataInputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        char c;
        while ((c = (char)dataInputStream.read()) != '\n' && c != '\r') {
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    static byte[] process(byte[] byArray) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        int n = dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        dataInputStream.readInt();
        String string = MethodLookup.readLine(dataInputStream);
        String string2 = MethodLookup.readLine(dataInputStream);
        String string3 = MethodLookup.readLine(dataInputStream);
        BufferPool.freeBuffer(byArray);
        int n3 = MethodLookup.lookup(string, string2, string3);
        Method method = methodList.get(n3);
        Class<?>[] classArray = method.getParameterTypes();
        Class<?> clazz = method.getReturnType();
        int n4 = 12 + 4 * classArray.length;
        BufferPool.BufferDataOutputStream bufferDataOutputStream = BufferPool.getOutputStream(n4 + 8);
        bufferDataOutputStream.writeInt(n);
        bufferDataOutputStream.writeInt(n4);
        bufferDataOutputStream.writeInt(n3);
        bufferDataOutputStream.writeInt(classArray.length);
        DataHandler dataHandler = new DataHandler[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            DataHandler dataHandler2;
            dataHandler[i] = dataHandler2 = DataManager.getManager().getHandler(classArray[i]);
        }
        parameterTypeMap.put(method, (DataHandler[])dataHandler);
        for (DataHandler dataHandler3 : dataHandler) {
            bufferDataOutputStream.writeInt(dataHandler3.getTypeNumber());
        }
        DataHandler dataHandler4 = DataManager.getManager().getHandler(clazz);
        bufferDataOutputStream.writeInt(dataHandler4.getTypeNumber());
        resultTypeMap.put(method, dataHandler4);
        return bufferDataOutputStream.getBuffer();
    }

    private static int lookup(String string, String string2, String string3) {
        String string4 = string.length() == 0 ? string2 : string + "." + string2;
        try {
            Class<?> clazz = Class.forName(string4);
            Method method = null;
            for (Method method2 : clazz.getMethods()) {
                if (!method2.getName().equals(string3) || !Modifier.isStatic(method2.getModifiers())) continue;
                if (method != null) {
                    LOGGER.error((Object)("LIME methods cannot be overloaded: Multiple implementations of " + string4 + "." + string3));
                    return -1;
                }
                method = method2;
            }
            if (method == null) {
                LOGGER.error((Object)("LIME method '" + string3 + "' not found" + " in class '" + string4 + "'"));
                return -1;
            }
            int n = methodList.indexOf(method);
            if (n == -1) {
                n = methodList.size();
                methodList.add(method);
            }
            return n;
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOGGER.error((Object)("LIME class '" + string4 + "' not found."));
            return -1;
        }
    }

    static Method getMethod(int n) {
        return methodList.get(n);
    }

    static DataHandler[] getParameterHandlers(Method method) {
        return parameterTypeMap.get(method);
    }

    static DataHandler getResultHandler(Method method) {
        return resultTypeMap.get(method);
    }
}

