/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp;

import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class GraphicsBridge
extends com.sun.kvem.cdc.GraphicsBridge {
    private static final Logger logger = Logger.getLogger(GraphicsBridge.class);
    private static GrabFullScreenTask grabFullScreenTask;

    public static void grabFullScreen(boolean bl) {
        GraphicsBridge.grabFullScreenForDisplay(bl, 0);
    }

    public static void grabFullScreenForDisplay(boolean bl, int n) {
        GraphicsBridge.findGraphicsDescriptor((int)n).setFullScreenMode(bl);
    }

    public static void setSoftButtonLabel(int n, String string) {
        if (n < 0) {
            return;
        }
        if (string == null) {
            string = "";
        }
    }

    public static void drawRGB16Buffer(int n, int n2, int n3, short[] sArray, int n4, ByteBuffer byteBuffer, int n5, int n6, int n7, int n8) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("drawRGB16Buffer called: displayId=%d, color=%d, style=%d, clip.len=%d, dstdesc=%d, rgbDataBuffer.len=%d, x=%d, y=%d, width=%d, height=%d", n2, n3, sArray.length, n4, byteBuffer.remaining(), n, n5, n6, n7, n8));
        }
        GraphicsBridge.drawRGB16Data((ByteBuffer)byteBuffer, (int)n);
    }

    public static void drawRGB16(int n, int n2, short[] sArray, int n3, ByteBuffer byteBuffer, int n4, int n5, int n6, int n7) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("drawRGB16 called: color=%d, style=%d, clip.len=%d, dstdesc=%d, rgbDataBuffer.len=%d, x=%d, y=%d, width=%d, height=%d", n, n2, sArray.length, n3, byteBuffer.remaining(), n4, n5, n6, n7));
        }
        GraphicsBridge.drawRGB16Data((ByteBuffer)byteBuffer, (int)0);
    }

    public static void setInputMode(int n) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Setting input mode: {0}", n));
        }
    }

    public static void synGrabFullScreen(boolean bl) {
        if (grabFullScreenTask == null) {
            grabFullScreenTask = new GrabFullScreenTask();
        }
        grabFullScreenTask.setParams(bl);
        try {
            SwingUtilities.invokeAndWait(grabFullScreenTask);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    private static class GrabFullScreenTask
    implements Runnable {
        public boolean mode;

        private GrabFullScreenTask() {
        }

        public synchronized void setParams(boolean bl) {
            this.mode = bl;
        }

        @Override
        public synchronized void run() {
            GraphicsBridge.grabFullScreen(this.mode);
        }
    }
}

