/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.services.productdesc;

import com.sun.jme.remoting.CommException;
import com.sun.jme.remoting.DataRecv;
import com.sun.jme.remoting.DataSend;
import com.sun.jme.remoting.SerializableObject;
import com.sun.jme.services.productdesc.StringUtils;

public final class ProductDescriptor
implements SerializableObject {
    private short vendorId;
    private short productId;
    private short productVersionId;

    public ProductDescriptor() {
    }

    public ProductDescriptor(short s, short s2, short s3) {
        this.vendorId = s;
        this.productId = s2;
        this.productVersionId = s3;
    }

    public ProductDescriptor(String string) {
        int n;
        String[] stringArray = new String[3];
        try {
            n = StringUtils.splitString(stringArray, string, '&');
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Descriptor string has too many parts!");
        }
        if (n < 2) {
            throw new IllegalArgumentException("Descriptor string needs to have at least 2 parts!");
        }
        Short s = null;
        Short s2 = null;
        Short s3 = null;
        boolean bl = true;
        try {
            for (int i = 0; i < n; ++i) {
                if (stringArray[i].startsWith("VID_")) {
                    s = this.parseValue(stringArray[i]);
                    continue;
                }
                if (stringArray[i].startsWith("PID_")) {
                    s2 = this.parseValue(stringArray[i]);
                    continue;
                }
                if (stringArray[i].startsWith("VER_")) {
                    s3 = this.parseValue(stringArray[i]);
                    continue;
                }
                throw new IllegalArgumentException("Invalid part: " + stringArray[i] + "!");
            }
            if (s != null && s2 != null) {
                bl = false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (bl) {
            throw new IllegalArgumentException("Invalid descriptor string!");
        }
        this.vendorId = s;
        this.productId = s2;
        this.productVersionId = s3 != null ? s3 : (short)0;
    }

    public short getVendorId() {
        return this.vendorId;
    }

    public short getProductId() {
        return this.productId;
    }

    public short getProductVersionId() {
        return this.productVersionId;
    }

    public void sendObject(DataSend dataSend) throws CommException {
        dataSend.sendShort((int)this.vendorId);
        dataSend.sendShort((int)this.productId);
        dataSend.sendShort((int)this.productVersionId);
    }

    public void recvObject(DataRecv dataRecv) throws CommException {
        short s = dataRecv.recvShort();
        short s2 = dataRecv.recvShort();
        short s3 = dataRecv.recvShort();
        this.vendorId = s;
        this.productId = s2;
        this.productVersionId = s3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ProductDescriptor)) {
            return false;
        }
        ProductDescriptor productDescriptor = (ProductDescriptor)object;
        return this.vendorId == productDescriptor.vendorId && this.productId == productDescriptor.productId && this.productVersionId == productDescriptor.productVersionId;
    }

    public int hashCode() {
        int n = 7;
        n = 73 * n + this.vendorId;
        n = 73 * n + this.productId;
        n = 73 * n + this.productVersionId;
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(26);
        stringBuffer.append("VID_");
        StringUtils.appendHexString(stringBuffer, this.vendorId, 4);
        stringBuffer.append("&PID_");
        StringUtils.appendHexString(stringBuffer, this.productId, 4);
        stringBuffer.append("&VER_");
        StringUtils.appendHexString(stringBuffer, this.productVersionId, 4);
        return stringBuffer.toString();
    }

    private Short parseValue(String string) throws NumberFormatException {
        return new Short((short)Integer.parseInt(string.substring(4), 16));
    }
}

