/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.services.productdesc;

import com.sun.jme.remoting.CommException;
import com.sun.jme.remoting.DataRecv;
import com.sun.jme.remoting.DataSend;
import com.sun.jme.remoting.SerializableObject;
import com.sun.jme.services.productdesc.StringUtils;

public final class ProductInstanceId
implements SerializableObject {
    private long mostSignificantPart;
    private long leastSignificantPart;

    public ProductInstanceId() {
    }

    public ProductInstanceId(long l, long l2) {
        this.mostSignificantPart = l;
        this.leastSignificantPart = l2;
    }

    public ProductInstanceId(String string) {
        long l;
        long l2;
        int n;
        String[] stringArray = new String[5];
        try {
            n = StringUtils.splitString(stringArray, string, '-');
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Instance id string has too many parts!");
        }
        if (n < 5) {
            throw new IllegalArgumentException("Instance id string needs to have 5 parts!");
        }
        try {
            l2 = Long.parseLong(stringArray[0], 16);
            l = l2 << 32;
            int n2 = Integer.parseInt(stringArray[1], 16);
            l |= (long)((n2 & 0xFFFF) << 16);
            n2 = Integer.parseInt(stringArray[2], 16);
            l |= (long)(n2 & 0xFFFF);
            n2 = Integer.parseInt(stringArray[3], 16);
            long l3 = (long)n2 << 48;
            l2 = Long.parseLong(stringArray[4], 16);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid instance id string!");
        }
        this.mostSignificantPart = l;
        this.leastSignificantPart = l3 |= l2 & 0xFFFFFFFFFFFFL;
    }

    public long getLeastSignificantPart() {
        return this.leastSignificantPart;
    }

    public long getMostSignificantPart() {
        return this.mostSignificantPart;
    }

    public void sendObject(DataSend dataSend) throws CommException {
        dataSend.sendLong(this.mostSignificantPart);
        dataSend.sendLong(this.leastSignificantPart);
    }

    public void recvObject(DataRecv dataRecv) throws CommException {
        long l = dataRecv.recvLong();
        long l2 = dataRecv.recvLong();
        this.mostSignificantPart = l;
        this.leastSignificantPart = l2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ProductInstanceId)) {
            return false;
        }
        ProductInstanceId productInstanceId = (ProductInstanceId)object;
        return this.mostSignificantPart == productInstanceId.mostSignificantPart && this.leastSignificantPart == productInstanceId.leastSignificantPart;
    }

    public int hashCode() {
        int n = 7;
        n = 73 * n + (int)(this.leastSignificantPart & 0xFFFFFFFFL);
        n = 73 * n + (int)(this.leastSignificantPart >> 32 & 0xFFFFFFFFL);
        n = 73 * n + (int)(this.mostSignificantPart & 0xFFFFFFFFL);
        n = 73 * n + (int)(this.mostSignificantPart >> 32 & 0xFFFFFFFFL);
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(36);
        StringUtils.appendHexString(stringBuffer, (int)(this.mostSignificantPart >>> 32), 8);
        stringBuffer.append('-');
        StringUtils.appendHexString(stringBuffer, (int)(this.mostSignificantPart >>> 16), 4);
        stringBuffer.append('-');
        StringUtils.appendHexString(stringBuffer, (int)this.mostSignificantPart, 4);
        stringBuffer.append('-');
        StringUtils.appendHexString(stringBuffer, (int)(this.leastSignificantPart >>> 48), 4);
        stringBuffer.append('-');
        StringUtils.appendHexString(stringBuffer, (int)(this.leastSignificantPart >>> 32), 4);
        StringUtils.appendHexString(stringBuffer, (int)this.leastSignificantPart, 8);
        return stringBuffer.toString();
    }
}

