/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.remoting;

import com.sun.jme.remoting.ClassRegistry;
import com.sun.jme.remoting.CommException;
import com.sun.jme.remoting.CommandInputStream;
import com.sun.jme.remoting.ObjectSkeleton;
import com.sun.jme.remoting.ResponseOutputStream;
import com.sun.jme.remoting.SerializableObject;
import com.sun.jme.remoting.SkeletonRegistry;
import com.sun.jme.remoting.StubRegistry;

public abstract class BasicObjectSkeleton
implements ObjectSkeleton {
    protected Object localObject;
    protected StubRegistry stubRegistry;
    protected SkeletonRegistry skeletonRegistry;
    protected ClassRegistry classRegistry;
    protected CommandInputStream commandInputStream;
    protected ResponseOutputStream responseOutputStream;

    @Override
    public final void setLocalObject(Object object) {
        this.localObject = object;
    }

    @Override
    public final void setStubRegistry(StubRegistry stubRegistry) {
        this.stubRegistry = stubRegistry;
    }

    @Override
    public final void setSkeletonRegistry(SkeletonRegistry skeletonRegistry) {
        this.skeletonRegistry = skeletonRegistry;
    }

    @Override
    public final void setClassRegistry(ClassRegistry classRegistry) {
        this.classRegistry = classRegistry;
    }

    @Override
    public final void setCommandInputStream(CommandInputStream commandInputStream) {
        this.commandInputStream = commandInputStream;
    }

    @Override
    public final void setResponseOutputStream(ResponseOutputStream responseOutputStream) {
        this.responseOutputStream = responseOutputStream;
    }

    protected final int getRemoteExceptionId(Exception exception) throws CommException {
        try {
            return this.classRegistry.getOrRegisterRemoteClass(exception.getClass().getName());
        }
        catch (IllegalStateException illegalStateException) {
            return 0;
        }
    }

    protected final void sendNoExceptionResponse() throws CommException {
        this.responseOutputStream.sendInt(-1);
    }

    protected final void sendExceptionResponse(int n, Exception exception) throws CommException {
        this.responseOutputStream.sendInt(n);
        if (n != 0 && exception instanceof SerializableObject) {
            SerializableObject serializableObject = (SerializableObject)((Object)exception);
            serializableObject.sendObject(this.responseOutputStream);
        }
    }
}

