/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.remoting;

import com.sun.jme.remoting.CommException;
import com.sun.jme.remoting.DataSend;
import java.io.DataOutputStream;
import java.io.IOException;

class DataSendImpl
implements DataSend {
    private final DataOutputStream dataOutputStream;

    public DataSendImpl(DataOutputStream dataOutputStream) {
        this.dataOutputStream = dataOutputStream;
    }

    @Override
    public void sendBoolean(boolean bl) throws CommException {
        try {
            this.dataOutputStream.writeBoolean(bl);
        }
        catch (IOException iOException) {
            throw new CommException(iOException);
        }
    }

    @Override
    public void sendByte(int n) throws CommException {
        try {
            this.dataOutputStream.writeByte(n);
        }
        catch (IOException iOException) {
            throw new CommException(iOException);
        }
    }

    @Override
    public void sendChar(int n) throws CommException {
        try {
            this.dataOutputStream.writeChar(n);
        }
        catch (IOException iOException) {
            throw new CommException(iOException);
        }
    }

    @Override
    public void sendDouble(double d) throws CommException {
        try {
            this.dataOutputStream.writeDouble(d);
        }
        catch (IOException iOException) {
            throw new CommException(iOException);
        }
    }

    @Override
    public void sendFloat(float f) throws CommException {
        try {
            this.dataOutputStream.writeFloat(f);
        }
        catch (IOException iOException) {
            throw new CommException(iOException);
        }
    }

    @Override
    public void sendInt(int n) throws CommException {
        try {
            this.dataOutputStream.writeInt(n);
        }
        catch (IOException iOException) {
            throw new CommException(iOException);
        }
    }

    @Override
    public void sendLong(long l) throws CommException {
        try {
            this.dataOutputStream.writeLong(l);
        }
        catch (IOException iOException) {
            throw new CommException(iOException);
        }
    }

    @Override
    public void sendShort(int n) throws CommException {
        try {
            this.dataOutputStream.writeShort(n);
        }
        catch (IOException iOException) {
            throw new CommException(iOException);
        }
    }

    @Override
    public void sendString(String string) throws CommException {
        try {
            if (string == null) {
                this.dataOutputStream.writeInt(-1);
            } else {
                this.dataOutputStream.writeInt(string.length());
                this.dataOutputStream.writeUTF(string);
            }
        }
        catch (IOException iOException) {
            throw new CommException(iOException);
        }
    }

    public void close() {
        try {
            this.dataOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void flush() {
        try {
            this.dataOutputStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

