/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.remoting;

import com.sun.jme.remoting.NamedObjectRegistry;
import com.sun.jme.remoting.RemotableObjectInfo;
import java.util.Hashtable;

public final class DefaultNamedObjectRegistry
implements NamedObjectRegistry {
    public static final String STUBS_PKG = "stubs";
    public static final String STUB_PFX = "Stub";
    public static final String SKELETONS_PKG = "skeletons";
    public static final String SKELETON_PFX = "Skeleton";
    private final Hashtable nameToRemObjectInfo = new Hashtable();
    private final Hashtable nameToObjectStubClass = new Hashtable();
    private final Object lock = new Object();

    public void registerRemotableObject(String string, Object object, Class clazz) {
        Class clazz2 = this.findSkeletonClass(clazz);
        this.registerCustomRemotableObject(string, new RemotableObjectInfo(object, clazz2));
    }

    public void registerCustomRemotableObject(String string, Object object, Class clazz) {
        this.registerCustomRemotableObject(string, new RemotableObjectInfo(object, clazz));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCustomRemotableObject(String string, RemotableObjectInfo remotableObjectInfo) {
        Object object = this.lock;
        synchronized (object) {
            if (this.nameToRemObjectInfo.containsKey(string)) {
                throw new IllegalArgumentException();
            }
            this.nameToRemObjectInfo.put(string, remotableObjectInfo);
        }
    }

    @Override
    public RemotableObjectInfo getRemotableObjectInfo(String string) {
        return (RemotableObjectInfo)this.nameToRemObjectInfo.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCustomObjectStubClass(String string, Class clazz) {
        Object object = this.lock;
        synchronized (object) {
            if (this.nameToObjectStubClass.containsKey(string)) {
                throw new IllegalArgumentException();
            }
            this.nameToObjectStubClass.put(string, clazz);
        }
    }

    public void registerObjectStubClass(String string, Class clazz) throws IllegalArgumentException {
        this.registerCustomObjectStubClass(string, this.findStubClass(clazz));
    }

    @Override
    public Class getObjectStubClass(String string) {
        return (Class)this.nameToObjectStubClass.get(string);
    }

    private Class findStubClass(Class clazz) throws IllegalArgumentException {
        String string;
        String string2 = clazz.getName();
        int n = string2.lastIndexOf(46);
        if (n != -1) {
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            string = string3 + "." + STUBS_PKG + "." + string4 + STUB_PFX;
        } else {
            string = "stubs." + string2 + STUB_PFX;
        }
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Unable to find stub class (" + classNotFoundException.toString() + ")");
        }
    }

    private Class findSkeletonClass(Class clazz) throws IllegalArgumentException {
        String string;
        String string2 = clazz.getName();
        int n = string2.lastIndexOf(46);
        if (n != -1) {
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            string = string3 + "." + SKELETONS_PKG + "." + string4 + SKELETON_PFX;
        } else {
            string = "skeletons." + string2 + SKELETON_PFX;
        }
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Unable to find skeleton class (" + classNotFoundException.toString() + ")");
        }
    }
}

