/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.remoting;

import com.sun.jme.remoting.BasicObjectSkeleton;
import com.sun.jme.remoting.ClassRegistry;
import com.sun.jme.remoting.CommException;
import com.sun.jme.remoting.JointInputStream;
import com.sun.jme.remoting.JointOutputStream;
import com.sun.jme.remoting.NamedObjectRegistry;
import com.sun.jme.remoting.ObjectSkeleton;
import com.sun.jme.remoting.ObjectStub;
import com.sun.jme.remoting.ProtocolHandler;
import com.sun.jme.remoting.RegisteredClass;
import com.sun.jme.remoting.RemotableObjectInfo;
import com.sun.jme.remoting.RemotingHandler;
import com.sun.jme.remoting.SkeletonRegistry;
import com.sun.jme.remoting.StubRegistry;
import com.sun.jme.remoting.Version;
import com.sun.jme.remoting.VersionProvider;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;

final class RemotingHandlerImpl
extends RemotingHandler
implements SkeletonRegistry,
StubRegistry,
ClassRegistry,
ProtocolHandler,
Runnable {
    private static final int DATA_EXCHANGE_OBJECT_ID = 0;
    private static final int INVALID_OBJECT_ID = -1;
    private static final int INVALID_CLASS_ID = -1;
    private static final int RESPONSE_RESERVED_OBJECT_ID = -1;
    private static final int CMD_GET_REMOTE_OBJECT_ID = 0;
    private static final int CMD_GET_REMOTE_CLASS_ID = 1;
    private static final int CMD_GET_PROTOCOL_VERSION = 2;
    private static final int CMD_GET_GENERATOR_VERSION = 3;
    private static final Version PROTOCOL_VERSION = new Version("1.0");
    private static final String GENERATOR_VERSION_CLASS = "com.sun.jme.remoting.generator.GeneratorVersion";
    private static final String MSG_COMM_CHANNEL_CLOSED = "Communication channel has been closed!";
    private static final int CALL_DEPTH_MASK = 15;
    private static final int TRANSACTION_MASK = -16;
    private static final int TRANSACTION_SHIFT = 4;
    private final NamedObjectRegistry namedObjectRegistry;
    private final JointInputStream jointInputStream;
    private final JointOutputStream jointOutputStream;
    private final Hashtable objectIdToSkeleton;
    private final Hashtable objectIdToStub;
    private final Hashtable remObjectInfoToObjectId;
    private final Hashtable nameToStub;
    private final Hashtable idToLocalClass;
    private final Hashtable nameToLocalClass;
    private final Hashtable nameToRemoteClassId;
    private final Hashtable threadToSessionId;
    private final Object lock;
    private int nextObjectId;
    private int nextClassId;
    private int allowedConcurrentCalls;
    private int nextTransactionId;
    private boolean newInputAvailable;
    private int inputObjectId;
    private int inputSessionId;
    private int outputSessionId;
    private boolean releaseDispatchingThread;
    private boolean outputStreamLocked;
    private boolean stopped;

    public RemotingHandlerImpl(NamedObjectRegistry namedObjectRegistry, InputStream inputStream, OutputStream outputStream) {
        this.namedObjectRegistry = namedObjectRegistry;
        this.jointInputStream = new JointInputStream(this, new DataInputStream(inputStream));
        this.jointOutputStream = new JointOutputStream(this, new DataOutputStream(outputStream));
        this.objectIdToSkeleton = new Hashtable();
        this.objectIdToStub = new Hashtable();
        this.remObjectInfoToObjectId = new Hashtable();
        this.nameToStub = new Hashtable();
        this.idToLocalClass = new Hashtable();
        this.nameToLocalClass = new Hashtable();
        this.nameToRemoteClassId = new Hashtable();
        this.threadToSessionId = new Hashtable();
        this.lock = new Object();
        this.allowedConcurrentCalls = 1;
        this.getOrRegisterObjectSkeleton(this, DataExchangeSkeleton.class);
        this.registerExceptionClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void executeDispatchingLoop() {
        Thread thread = new Thread((Runnable)this, "Remoting handler execution thread");
        thread.start();
        try {
            while (true) {
                int n = this.jointInputStream.recvInt();
                int n2 = this.jointInputStream.recvInt();
                Object object = this.lock;
                synchronized (object) {
                    this.inputSessionId = n;
                    this.inputObjectId = n2;
                    this.newInputAvailable = true;
                    this.lock.notifyAll();
                    while (!this.stopped && !this.releaseDispatchingThread) {
                        this.lock.wait();
                    }
                    this.releaseDispatchingThread = false;
                    if (this.stopped) {
                        break;
                    }
                }
            }
        }
        catch (CommException commException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.stopDispatchingLoop();
        try {
            thread.join();
            return;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopDispatchingLoop() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.stopped) {
                this.jointInputStream.close();
                this.jointOutputStream.close();
                this.stopped = true;
                this.lock.notifyAll();
            }
        }
    }

    @Override
    public ObjectStub getRemoteObjectReference(String string) throws CommException {
        ObjectStub objectStub = (ObjectStub)this.nameToStub.get(string);
        if (objectStub != null) {
            return objectStub;
        }
        Class clazz = this.namedObjectRegistry.getObjectStubClass(string);
        if (clazz == null) {
            throw new CommException("Stub class for " + string + " not" + " registered.");
        }
        int n = this.jointOutputStream.beginSendCommand(0);
        this.jointOutputStream.sendInt(0);
        this.jointOutputStream.sendString(string);
        this.jointOutputStream.endSendCommand(n);
        this.jointInputStream.beginRecvResponse(n);
        int n2 = this.jointInputStream.recvInt();
        this.jointInputStream.endRecvResponse(n);
        if (n2 == -1) {
            return null;
        }
        ObjectStub objectStub2 = this.getOrRegisterObjectStub(n2, clazz);
        this.nameToStub.put(string, objectStub2);
        return objectStub2;
    }

    @Override
    public ObjectStub getRemoteObject(String string) throws CommException {
        ObjectStub objectStub = this.getRemoteObjectReference(string);
        if (objectStub == null) {
            throw new CommException("Stub class for " + string + " not" + " registered.");
        }
        return objectStub;
    }

    @Override
    public int getOrRegisterObjectSkeleton(Object object, Class clazz) {
        if (object == null) {
            return -1;
        }
        return this.getOrRegisterObjectSkeleton(new RemotableObjectInfo(object, clazz));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectStub getOrRegisterObjectStub(int n, Class clazz) {
        if (n == -1) {
            return null;
        }
        Integer n2 = new Integer(n);
        Object object = this.lock;
        synchronized (object) {
            ObjectStub objectStub;
            ObjectStub objectStub2 = (ObjectStub)this.objectIdToStub.get(n2);
            if (objectStub2 != null) {
                return objectStub2;
            }
            try {
                objectStub = (ObjectStub)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new IllegalArgumentException();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalArgumentException();
            }
            objectStub.setObjectId(n);
            objectStub.setStubRegistry(this);
            objectStub.setSkeletonRegistry(this);
            objectStub.setClassRegistry(this);
            objectStub.setCommandOutputStream(this.jointOutputStream);
            objectStub.setResponseInputStream(this.jointInputStream);
            this.objectIdToStub.put(n2, objectStub);
            return objectStub;
        }
    }

    @Override
    public int getOrRegisterRemoteClass(String string) throws CommException, IllegalStateException {
        Integer n = (Integer)this.nameToRemoteClassId.get(string);
        if (n != null) {
            return n;
        }
        int n2 = this.jointOutputStream.beginSendCommand(0);
        this.jointOutputStream.sendInt(1);
        this.jointOutputStream.sendString(string);
        this.jointOutputStream.endSendCommand(n2);
        this.jointInputStream.beginRecvResponse(n2);
        int n3 = this.jointInputStream.recvInt();
        this.jointInputStream.endRecvResponse(n2);
        if (n3 == -1) {
            throw new IllegalStateException("No " + string + " on the" + " remote side.");
        }
        this.nameToRemoteClassId.put(string, new Integer(n3));
        return n3;
    }

    @Override
    public Class getLocalClass(int n) throws IllegalArgumentException {
        Class clazz = (Class)this.idToLocalClass.get(new Integer(n));
        if (clazz == null) {
            throw new IllegalArgumentException("No class registered with id " + n);
        }
        return clazz;
    }

    @Override
    public void versionCheck() throws CommException {
        Version version = this.getProtocolVersion();
        Version version2 = this.getRemoteVersion(2);
        RemotingHandlerImpl.compareVersions(version, version2, "Protocol");
        Version version3 = this.getGeneratorVersion();
        Version version4 = this.getRemoteVersion(3);
        RemotingHandlerImpl.compareVersions(version3, version4, "Generator");
    }

    public Version getProtocolVersion() {
        return PROTOCOL_VERSION;
    }

    public Version getGeneratorVersion() {
        try {
            Class<?> clazz = Class.forName(GENERATOR_VERSION_CLASS);
            VersionProvider versionProvider = (VersionProvider)clazz.newInstance();
            return versionProvider.getVersion();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (ClassCastException classCastException) {
        }
        catch (CommException commException) {
            // empty catch block
        }
        return new Version();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getOrRegisterObjectSkeleton(RemotableObjectInfo remotableObjectInfo) {
        Object object = this.lock;
        synchronized (object) {
            ObjectSkeleton objectSkeleton;
            Integer n = (Integer)this.remObjectInfoToObjectId.get(remotableObjectInfo);
            if (n != null) {
                return n;
            }
            Object object2 = remotableObjectInfo.getLocalObject();
            Class clazz = remotableObjectInfo.getSkeletonClass();
            try {
                objectSkeleton = (ObjectSkeleton)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new IllegalArgumentException();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalArgumentException();
            }
            objectSkeleton.setLocalObject(object2);
            objectSkeleton.setStubRegistry(this);
            objectSkeleton.setSkeletonRegistry(this);
            objectSkeleton.setClassRegistry(this);
            objectSkeleton.setCommandInputStream(this.jointInputStream);
            objectSkeleton.setResponseOutputStream(this.jointOutputStream);
            int n2 = this.nextObjectId++;
            Integer n3 = new Integer(n2);
            this.remObjectInfoToObjectId.put(remotableObjectInfo, n3);
            this.objectIdToSkeleton.put(n3, objectSkeleton);
            return n2;
        }
    }

    private int handleGetRemoteObjectId(String string) {
        RemotableObjectInfo remotableObjectInfo = this.namedObjectRegistry.getRemotableObjectInfo(string);
        return remotableObjectInfo != null ? this.getOrRegisterObjectSkeleton(remotableObjectInfo) : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int handleGetRemoteClassId(String string) {
        Object object = this.lock;
        synchronized (object) {
            Class<?> clazz;
            RegisteredClass registeredClass = (RegisteredClass)this.nameToLocalClass.get(string);
            if (registeredClass != null) {
                return registeredClass.getClassId();
            }
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return -1;
            }
            int n = this.nextClassId++;
            RegisteredClass registeredClass2 = new RegisteredClass(n, clazz);
            this.nameToLocalClass.put(string, registeredClass2);
            this.idToLocalClass.put(new Integer(n), clazz);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (true) {
                int n;
                int n2;
                Object object = this.lock;
                synchronized (object) {
                    while (!(this.stopped || this.newInputAvailable && !RemotingHandlerImpl.isResponse(this.inputObjectId) && RemotingHandlerImpl.getCallDepth(this.inputSessionId) == 0)) {
                        this.lock.wait();
                    }
                    if (this.stopped) {
                        break;
                    }
                    n2 = this.inputSessionId;
                    n = this.inputObjectId;
                    this.newInputAvailable = false;
                }
                this.executeCommand(n2, n);
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (CommException commException) {
            commException.printStackTrace();
        }
        this.stopDispatchingLoop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int beginSendCommand(int n) throws CommException {
        int n2;
        Object object = this.lock;
        synchronized (object) {
            Thread thread = Thread.currentThread();
            Object v = this.threadToSessionId.get(thread);
            if (v != null) {
                n2 = RemotingHandlerImpl.increaseCallDepth((Integer)v);
            } else {
                while (!this.stopped && this.allowedConcurrentCalls == 0) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new CommException(interruptedException);
                    }
                }
                if (this.stopped) {
                    throw new CommException(MSG_COMM_CHANNEL_CLOSED);
                }
                --this.allowedConcurrentCalls;
                n2 = RemotingHandlerImpl.makeSessionId(this.nextTransactionId, 0);
                this.nextTransactionId = this.nextTransactionId + 1 & 0xFFFFFFF;
            }
            this.lockSending(n2);
        }
        this.jointOutputStream.sendInt(n2);
        this.jointOutputStream.sendInt(n);
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endSendCommand(int n) throws CommException {
        this.jointOutputStream.flush();
        Object object = this.lock;
        synchronized (object) {
            this.unlockSending(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginRecvCommand(int n) throws CommException {
        Object object = this.lock;
        synchronized (object) {
            this.verifyInputSessionId(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endRecvCommand(int n) throws CommException {
        Object object = this.lock;
        synchronized (object) {
            this.verifyInputSessionId(n);
            this.releaseDispatchingThread = true;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginSendResponse(int n) throws CommException {
        Object object = this.lock;
        synchronized (object) {
            this.lockSending(n);
        }
        this.jointOutputStream.sendInt(n);
        this.jointOutputStream.sendInt(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endSendResponse(int n) throws CommException {
        this.jointOutputStream.flush();
        Object object = this.lock;
        synchronized (object) {
            this.unlockSending(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginRecvResponse(int n) throws CommException {
        int n2 = RemotingHandlerImpl.getTransactionId(n);
        while (true) {
            int n3;
            int n4;
            Object object = this.lock;
            synchronized (object) {
                while (true) {
                    if (this.stopped) {
                        throw new CommException(MSG_COMM_CHANNEL_CLOSED);
                    }
                    if (this.newInputAvailable) {
                        if (RemotingHandlerImpl.isResponse(this.inputObjectId)) {
                            if (this.inputSessionId == n) {
                                this.newInputAvailable = false;
                                return;
                            }
                        } else if (RemotingHandlerImpl.getTransactionId(this.inputSessionId) == n2) break;
                    }
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new CommException(interruptedException);
                    }
                }
                n4 = this.inputSessionId;
                n3 = this.inputObjectId;
                this.newInputAvailable = false;
            }
            this.executeCommand(n4, n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endRecvResponse(int n) throws CommException {
        Object object = this.lock;
        synchronized (object) {
            this.verifyInputSessionId(n);
            ++this.allowedConcurrentCalls;
            this.releaseDispatchingThread = true;
            this.lock.notifyAll();
        }
    }

    private void verifyInputSessionId(int n) throws IllegalStateException {
        if (this.inputSessionId != n) {
            throw new IllegalStateException();
        }
    }

    private void lockSending(int n) throws CommException {
        while (!this.stopped && this.outputStreamLocked) {
            try {
                this.lock.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new CommException(interruptedException);
            }
        }
        if (this.stopped) {
            throw new CommException(MSG_COMM_CHANNEL_CLOSED);
        }
        this.outputStreamLocked = true;
        this.outputSessionId = n;
    }

    private void unlockSending(int n) throws IllegalStateException {
        if (!this.outputStreamLocked || this.outputSessionId != n) {
            throw new IllegalStateException();
        }
        this.outputStreamLocked = false;
        this.lock.notify();
    }

    private void executeCommand(int n, int n2) throws CommException {
        Thread thread = Thread.currentThread();
        Object v = this.threadToSessionId.get(thread);
        this.threadToSessionId.put(thread, new Integer(n));
        ObjectSkeleton objectSkeleton = this.getObjectSkeletonForId(n2);
        objectSkeleton.processNextCommand(n);
        if (v == null) {
            this.threadToSessionId.remove(thread);
        } else {
            this.threadToSessionId.put(thread, v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectSkeleton getObjectSkeletonForId(int n) throws CommException {
        ObjectSkeleton objectSkeleton;
        Object object = this.lock;
        synchronized (object) {
            Integer n2 = new Integer(n);
            objectSkeleton = (ObjectSkeleton)this.objectIdToSkeleton.get(n2);
        }
        if (objectSkeleton == null) {
            throw new CommException("Invalid object ID: " + n);
        }
        return objectSkeleton;
    }

    private void registerExceptionClass() {
        Class<Exception> clazz = Exception.class;
        int n = this.nextClassId++;
        RegisteredClass registeredClass = new RegisteredClass(n, clazz);
        this.nameToLocalClass.put(clazz.getName(), registeredClass);
        this.idToLocalClass.put(new Integer(n), clazz);
    }

    private Version getRemoteVersion(int n) {
        Version version = new Version();
        try {
            int n2 = this.jointOutputStream.beginSendCommand(0);
            this.jointOutputStream.sendInt(n);
            this.jointOutputStream.endSendCommand(n2);
            this.jointInputStream.beginRecvResponse(n2);
            version.recvObject(this.jointInputStream);
            this.jointInputStream.endRecvResponse(n2);
        }
        catch (CommException commException) {
            // empty catch block
        }
        return version;
    }

    private static boolean isResponse(int n) {
        return n == -1;
    }

    private static int getTransactionId(int n) {
        return n >>> 4;
    }

    private static int getCallDepth(int n) {
        return n & 0xF;
    }

    private static int makeSessionId(int n, int n2) {
        return n << 4 | n2 & 0xF;
    }

    private static int increaseCallDepth(int n) {
        int n2 = RemotingHandlerImpl.getCallDepth(n) + 1;
        return n & 0xFFFFFFF0 | n2 & 0xF;
    }

    private static void compareVersions(Version version, Version version2, String string) throws CommException {
        if (!version.equals(version2)) {
            throw new CommException(string + " version check failed in " + "jme remoting!" + " Local version " + version + " isn't equal to remote version " + version2 + ".");
        }
    }

    public static final class DataExchangeSkeleton
    extends BasicObjectSkeleton {
        @Override
        public void processNextCommand(int n) throws CommException {
            this.commandInputStream.beginRecvCommand(n);
            int n2 = this.commandInputStream.recvInt();
            switch (n2) {
                case 0: {
                    this.processGetRemoteObjectId(n);
                    break;
                }
                case 1: {
                    this.processGetRemoteClassId(n);
                    break;
                }
                case 2: {
                    this.processGetProtocolVersion(n);
                    break;
                }
                case 3: {
                    this.processGetGeneratorVersion(n);
                    break;
                }
                default: {
                    throw new CommException("Unrecognized command: " + n2);
                }
            }
        }

        private void processGetRemoteObjectId(int n) throws CommException {
            String string = this.commandInputStream.recvString();
            this.commandInputStream.endRecvCommand(n);
            int n2 = ((RemotingHandlerImpl)this.localObject).handleGetRemoteObjectId(string);
            this.responseOutputStream.beginSendResponse(n);
            this.responseOutputStream.sendInt(n2);
            this.responseOutputStream.endSendResponse(n);
        }

        private void processGetRemoteClassId(int n) throws CommException {
            String string = this.commandInputStream.recvString();
            this.commandInputStream.endRecvCommand(n);
            int n2 = ((RemotingHandlerImpl)this.localObject).handleGetRemoteClassId(string);
            this.responseOutputStream.beginSendResponse(n);
            this.responseOutputStream.sendInt(n2);
            this.responseOutputStream.endSendResponse(n);
        }

        private void processGetProtocolVersion(int n) throws CommException {
            this.commandInputStream.endRecvCommand(n);
            Version version = ((RemotingHandlerImpl)this.localObject).getProtocolVersion();
            this.responseOutputStream.beginSendResponse(n);
            version.sendObject(this.responseOutputStream);
            this.responseOutputStream.endSendResponse(n);
        }

        private void processGetGeneratorVersion(int n) throws CommException {
            this.commandInputStream.endRecvCommand(n);
            Version version = ((RemotingHandlerImpl)this.localObject).getGeneratorVersion();
            this.responseOutputStream.beginSendResponse(n);
            version.sendObject(this.responseOutputStream);
            this.responseOutputStream.endSendResponse(n);
        }
    }
}

