/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.deviceRegistry.rmi;

import com.sun.jme.toolkit.deviceRegistry.api.DeviceRegistration;
import com.sun.jme.toolkit.deviceRegistry.api.DeviceState;
import com.sun.jme.toolkit.deviceRegistry.api.DeviceStateListener;
import com.sun.jme.toolkit.deviceRegistry.rmi.DeviceStateManagerImplMBean;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.log4j.Logger;

public class DeviceStateManagerImpl
implements DeviceStateManagerImplMBean {
    private static final Logger LOGGER = Logger.getLogger(DeviceStateManagerImpl.class);
    private final List<DeviceStateListener> listeners = new CopyOnWriteArrayList<DeviceStateListener>();
    private final Map<Integer, DeviceState> nonDefaultStates = new HashMap<Integer, DeviceState>();

    public void addDeviceManagerListener(DeviceRegistration deviceRegistration) {
        this.addDeviceStateListener(new DeviceManagerListenerAdapter(deviceRegistration));
        for (Map.Entry<Integer, DeviceState> entry : this.nonDefaultStates.entrySet()) {
            if (!entry.getValue().isConnected()) continue;
            deviceRegistration.registeredDevice(entry.getKey().intValue());
        }
    }

    public void removeDeviceManagerListener(DeviceRegistration deviceRegistration) {
        for (DeviceStateListener deviceStateListener : this.listeners) {
            if (!(deviceStateListener instanceof DeviceManagerListenerAdapter) || ((DeviceManagerListenerAdapter)deviceStateListener).getDeviceManagerListener() != deviceRegistration) continue;
            this.removeDeviceStateListener(deviceStateListener);
            break;
        }
    }

    public synchronized void registeredDevice(int n) {
        LOGGER.debug((Object)("registeredDevice id = " + n));
        this.setDeviceState(n, DeviceState.CONNECTED);
    }

    public synchronized void unregisteredDevice(int n) {
        LOGGER.debug((Object)("unregisteredDevice id = " + n));
        this.setDeviceState(n, DeviceState.AVAILABLE);
    }

    public synchronized void setDeviceState(int n, DeviceState deviceState) {
        DeviceState deviceState2 = this.getDeviceState(n);
        if (deviceState2 != deviceState) {
            if (deviceState != DeviceState.DEFAULT) {
                this.nonDefaultStates.put(n, deviceState);
            } else {
                this.nonDefaultStates.remove(n);
            }
            LOGGER.debug((Object)("Device " + n + " state set to: " + deviceState));
            for (DeviceStateListener deviceStateListener : this.listeners) {
                deviceStateListener.stateChanged(n, deviceState2, deviceState);
            }
        }
    }

    public synchronized DeviceState getDeviceState(int n) {
        DeviceState deviceState = this.nonDefaultStates.get(n);
        return deviceState != null ? deviceState : DeviceState.DEFAULT;
    }

    public void addDeviceStateListener(DeviceStateListener deviceStateListener) {
        this.listeners.add(deviceStateListener);
    }

    public void removeDeviceStateListener(DeviceStateListener deviceStateListener) {
        this.listeners.remove(deviceStateListener);
    }

    private static final class DeviceManagerListenerAdapter
    implements DeviceStateListener {
        private final DeviceRegistration deviceManagerListener;

        public DeviceManagerListenerAdapter(DeviceRegistration deviceRegistration) {
            this.deviceManagerListener = deviceRegistration;
        }

        public void stateChanged(int n, DeviceState deviceState, DeviceState deviceState2) {
            if (deviceState.isConnected() == deviceState2.isConnected()) {
                return;
            }
            if (deviceState2.isConnected()) {
                this.deviceManagerListener.registeredDevice(n);
            } else {
                this.deviceManagerListener.unregisteredDevice(n);
            }
        }

        public DeviceRegistration getDeviceManagerListener() {
            return this.deviceManagerListener;
        }
    }
}

