/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.deviceRegistry.rmi;

import com.sun.jme.toolkit.deviceRegistry.api.DeviceRegistrationListener;
import com.sun.jme.toolkit.deviceRegistry.api.RegistrationData;
import com.sun.jme.toolkit.deviceRegistry.rmi.WorkdirDeviceManagerMBean;
import com.sun.jme.toolkit.environment.WorkdirHelper;
import com.sun.jme.toolkit.util.io.FileUtils;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.log4j.Logger;

public class WorkdirDeviceManager
implements WorkdirDeviceManagerMBean {
    static final String PROPERTIES_FILE_NAME = "properties.xml";
    private static final Logger logger = Logger.getLogger(WorkdirDeviceManager.class);
    private final Map<Integer, RegistrationData> deviceRegistrationMap;
    private WorkdirHelper workdirHelper;
    private final List<DeviceRegistrationListener> listeners;

    public WorkdirDeviceManager() {
        logger.trace((Object)"WorkdirDeviceManager() -->");
        this.deviceRegistrationMap = new HashMap<Integer, RegistrationData>();
        this.listeners = new CopyOnWriteArrayList<DeviceRegistrationListener>();
        logger.trace((Object)"<-- WorkdirDeviceManager()");
    }

    public void start() throws Exception {
        logger.trace((Object)"start() -->");
        this.workdirHelper.workDirectory().mkdirs();
        this.loadDeviceRegistrations();
        logger.trace((Object)"<-- start()");
    }

    public void setWorkdirHelper(WorkdirHelper workdirHelper) {
        this.workdirHelper = workdirHelper;
    }

    public synchronized int allocateDeviceId(RegistrationData registrationData) {
        logger.trace((Object)"allocateDeviceId() -->");
        int n = this.getNewDeviceId();
        RegistrationData registrationData2 = (RegistrationData)registrationData.clone();
        this.deviceRegistrationMap.put(n, registrationData2);
        File file = this.deviceWorkDirectory(n);
        file.mkdirs();
        WorkdirDeviceManager.createPropertyFile(file, registrationData2);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("<-- allocateDeviceId() = " + n));
        }
        for (DeviceRegistrationListener deviceRegistrationListener : this.listeners) {
            deviceRegistrationListener.deviceRegistered(n);
        }
        return n;
    }

    public synchronized void releaseDeviceId(int n) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("releaseDeviceId(deviceId = " + n + ") -->"));
        }
        this.deviceRegistrationMap.remove(n);
        File file = this.deviceWorkDirectory(n);
        FileUtils.deleteDir((File)file);
        for (DeviceRegistrationListener deviceRegistrationListener : this.listeners) {
            deviceRegistrationListener.deviceUnregistered(n);
        }
        logger.trace((Object)"<-- releaseDeviceId()");
    }

    public synchronized RegistrationData[] getDeviceRegistrations() {
        logger.trace((Object)"getDeviceRegistrations() -->");
        RegistrationData[] registrationDataArray = new RegistrationData[this.deviceRegistrationMap.size()];
        int n = 0;
        for (Map.Entry<Integer, RegistrationData> entry : this.deviceRegistrationMap.entrySet()) {
            registrationDataArray[n++] = (RegistrationData)entry.getValue().clone();
        }
        logger.trace((Object)"<-- getDeviceRegistrations()");
        return registrationDataArray;
    }

    public synchronized RegistrationData getDeviceRegistration(int n) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("getDeviceRegistration(deviceId = " + n + ") -->"));
        }
        RegistrationData registrationData = this.deviceRegistrationMap.get(n);
        logger.trace((Object)"<-- getDeviceRegistration()");
        return registrationData != null ? (RegistrationData)registrationData.clone() : null;
    }

    public synchronized void updateDeviceRegistration(int n, RegistrationData registrationData) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("updateDeviceRegistration(deviceId = " + n + ", props = " + registrationData + ") -->"));
        }
        RegistrationData registrationData2 = (RegistrationData)registrationData.clone();
        this.deviceRegistrationMap.put(n, registrationData2);
        File file = this.deviceWorkDirectory(n);
        WorkdirDeviceManager.createPropertyFile(file, registrationData2);
        logger.trace((Object)"<-- updateDeviceRegistration()");
    }

    public synchronized int lookupDeviceId(String string) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("lookupDeviceId(deviceName = " + string + ") -->"));
        }
        Set<Map.Entry<Integer, RegistrationData>> set = this.deviceRegistrationMap.entrySet();
        for (Map.Entry<Integer, RegistrationData> entry : set) {
            if (!string.equals(entry.getValue().getName())) continue;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("<-- lookupDeviceId() = " + entry.getKey()));
            }
            return entry.getKey();
        }
        logger.trace((Object)"<-- lookupDeviceId() = -1");
        return -1;
    }

    public synchronized int[] getDeviceIds(String string) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.deviceRegistrationMap.size());
        for (Map.Entry<Integer, RegistrationData> entry : this.deviceRegistrationMap.entrySet()) {
            if (string != null && !string.equals(entry.getValue().getAdapter())) continue;
            arrayList.add(entry.getKey());
        }
        Object object = new int[arrayList.size()];
        int n = 0;
        for (Integer n2 : arrayList) {
            object[n++] = n2;
        }
        return object;
    }

    public int[] getDeviceIds() {
        return this.getDeviceIds(null);
    }

    public synchronized File getDeviceWorkDirectory(int n) {
        if (!this.deviceRegistrationMap.containsKey(n)) {
            throw new IllegalArgumentException("Device " + n + " not" + " registered");
        }
        return this.deviceWorkDirectory(n);
    }

    private File deviceWorkDirectory(int n) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("deviceWorkDirectory(id = " + n + ")"));
        }
        return this.workdirHelper.deviceWorkDirectory(String.valueOf(n));
    }

    private static void createPropertyFile(File file, RegistrationData registrationData) {
        logger.trace((Object)"createPropertyFile() -->");
        if (registrationData != null) {
            try {
                XMLEncoder xMLEncoder = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(new File(file, PROPERTIES_FILE_NAME))));
                xMLEncoder.writeObject(registrationData);
                xMLEncoder.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                logger.debug((Object)"File not found", (Throwable)fileNotFoundException);
                fileNotFoundException.printStackTrace();
            }
        }
        logger.trace((Object)"<-- createPropertyFile()");
    }

    private static RegistrationData retrieveDeviceProperty(File file) {
        logger.trace((Object)"retrieveDeviceProperty() -->");
        try {
            XMLDecoder xMLDecoder = new XMLDecoder(new BufferedInputStream(new FileInputStream(new File(file, PROPERTIES_FILE_NAME))), null, null, RegistrationData.class.getClassLoader());
            RegistrationData registrationData = (RegistrationData)xMLDecoder.readObject();
            xMLDecoder.close();
            logger.trace((Object)"<-- retrieveDeviceProperty()");
            return registrationData;
        }
        catch (Exception exception) {
            logger.debug((Object)"Exception", (Throwable)exception);
            exception.printStackTrace();
            logger.trace((Object)"<-- retrieveDeviceProperty() = null");
            return null;
        }
    }

    private void loadDeviceRegistrations() {
        logger.trace((Object)"loadDeviceRegistrations() -->");
        File file = this.workdirHelper.workDirectory();
        File[] fileArray = file.listFiles();
        this.deviceRegistrationMap.clear();
        for (int i = 0; i < fileArray.length; ++i) {
            String string = fileArray[i].getName();
            try {
                int n = Integer.parseInt(string);
                if (n < 0) continue;
                RegistrationData registrationData = WorkdirDeviceManager.retrieveDeviceProperty(fileArray[i]);
                this.deviceRegistrationMap.put(n, registrationData);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        logger.trace((Object)"<-- loadDeviceRegistrations()");
    }

    private int getNewDeviceId() {
        logger.trace((Object)"getNewDeviceId() -->");
        int n = 0;
        while (this.deviceRegistrationMap.get(n) != null) {
            ++n;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("<-- getNewDeviceId() = " + n));
        }
        return n;
    }

    public void addDeviceRegistrationListener(DeviceRegistrationListener deviceRegistrationListener) {
        this.listeners.add(deviceRegistrationListener);
    }

    public void removeDeviceRegistrationListener(DeviceRegistrationListener deviceRegistrationListener) {
        this.listeners.remove(deviceRegistrationListener);
    }
}

