/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DirectoryHelper {
    private ProgressListener listener;
    private ProgressData progress = new ProgressData();
    private boolean interrupt;

    public void registerProgressListener(ProgressListener progressListener) {
        this.listener = progressListener;
    }

    public boolean deleteDir(String string) throws IOException {
        File file = new File(string);
        if (!file.exists() || !file.isDirectory()) {
            return false;
        }
        this.progress.clear();
        this.interrupt = false;
        return this.recursiveDelete(file);
    }

    public boolean copyDir(String string, String string2) throws IOException, FileNotFoundException {
        this.progress.clear();
        this.interrupt = false;
        return this.recursiveCopy(new File(string), new File(string2));
    }

    public long getDirSize(String string) {
        File file = new File(string);
        if (!file.exists() || !file.isDirectory()) {
            return -1L;
        }
        this.progress.clear();
        this.interrupt = false;
        return this.recursiveGetSize(file);
    }

    public long getFilesCount(String string) {
        File file = new File(string);
        if (!file.exists() || !file.isDirectory()) {
            return -1L;
        }
        this.progress.clear();
        this.interrupt = false;
        return this.recursiveGetFilesCount(file);
    }

    public void interrupt() {
        this.interrupt = true;
    }

    private boolean recursiveDelete(File file) throws IOException {
        String[] stringArray;
        if (file.isFile()) {
            long l = file.length();
            this.progress.addFile(file.getAbsolutePath());
            this.notifyListener();
            if (this.interrupt) {
                return false;
            }
            boolean bl = file.delete();
            if (bl) {
                this.progress.addBytes(l);
                this.notifyListener();
            }
            return bl;
        }
        for (String string : stringArray = file.list()) {
            File file2 = new File(file, string);
            if (this.recursiveDelete(file2) && !this.interrupt) continue;
            return false;
        }
        return file.delete();
    }

    private long recursiveGetSize(File file) {
        if (file.isFile()) {
            this.progress.addFile(file.getAbsolutePath());
            this.notifyListener();
            if (this.interrupt) {
                return -1L;
            }
            return file.length();
        }
        String[] stringArray = file.list();
        long l = 0L;
        for (String string : stringArray) {
            if (this.interrupt) {
                return -1L;
            }
            File file2 = new File(file, string);
            l += this.recursiveGetSize(file2);
        }
        return l;
    }

    private long recursiveGetFilesCount(File file) {
        if (file.isFile()) {
            this.progress.addFile(file.getAbsolutePath());
            this.notifyListener();
            if (this.interrupt) {
                return -1L;
            }
            return 1L;
        }
        String[] stringArray = file.list();
        long l = 0L;
        for (String string : stringArray) {
            if (this.interrupt) {
                return -1L;
            }
            File file2 = new File(file, string);
            l += this.recursiveGetFilesCount(file2);
        }
        return l;
    }

    private boolean recursiveCopy(File file, File file2) throws IOException, FileNotFoundException {
        if (this.interrupt) {
            return false;
        }
        if (file.isDirectory()) {
            String[] stringArray;
            if (!file2.exists()) {
                file2.mkdir();
            }
            for (String string : stringArray = file.list()) {
                this.recursiveCopy(new File(file, string), new File(file2, string));
                if (!this.interrupt) continue;
                return false;
            }
        } else {
            int n;
            if (!file.exists()) {
                throw new FileNotFoundException(file.getPath());
            }
            this.progress.addFile(file.getAbsolutePath());
            this.notifyListener();
            if (this.interrupt) {
                return false;
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[1024];
            while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
                this.progress.addBytes(n);
                this.notifyListener();
                if (!this.interrupt) continue;
                ((InputStream)fileInputStream).close();
                ((OutputStream)fileOutputStream).close();
                file2.delete();
                return false;
            }
            ((InputStream)fileInputStream).close();
            ((OutputStream)fileOutputStream).close();
        }
        return true;
    }

    private void notifyListener() {
        if (this.listener != null) {
            this.listener.updateProgress(this.progress);
        }
    }

    public static interface ProgressListener {
        public void updateProgress(ProgressData var1);
    }

    public class ProgressData {
        private String currentFile;
        private long bytes;
        private int files;

        public ProgressData() {
            this.clear();
        }

        public void clear() {
            this.currentFile = null;
            this.bytes = 0L;
            this.files = 0;
        }

        public long getBytes() {
            return this.bytes;
        }

        public int getFilesCount() {
            return this.files;
        }

        public String getCurrentFile() {
            return this.currentFile;
        }

        public void addFile(String string) {
            this.currentFile = string;
            ++this.files;
        }

        public void addBytes(long l) {
            this.bytes += l;
        }
    }
}

