/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp;

import com.sun.jme.emulator.events.spi.EventManagerSpi;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

public class FileConnEventGenPanel {
    private static Vector<String> roots = new Vector();
    private static List<String> unmountedRoots = new ArrayList<String>();
    private static EventManagerSpi eventBridge;
    private static String fileSystemDirectory;
    private static String inherentRoot;
    private static String unmountedFileSystemDirectory;

    public static void setFileSystemDirectory(String string) {
        fileSystemDirectory = string;
    }

    public static void setUnmountedFileSystemDirectory(String string) {
        unmountedFileSystemDirectory = string;
    }

    public void start() {
        FileConnEventGenPanel.retrieveRoots();
        FileConnEventGenPanel.retrieveUnmountedRoots();
    }

    public static void setEventBridge(EventManagerSpi eventManagerSpi) {
        eventBridge = eventManagerSpi;
    }

    public void setInherentRoot(String string) {
        inherentRoot = string;
    }

    private static void retrieveRoots() {
        if (roots.size() > 0) {
            return;
        }
        File file = new File(fileSystemDirectory);
        if (!file.exists()) {
            file.mkdirs();
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].isDirectory()) continue;
            roots.addElement(fileArray[i].getName() + '/');
        }
    }

    private static void retrieveUnmountedRoots() {
        File file = new File(unmountedFileSystemDirectory);
        unmountedRoots.clear();
        if (!file.exists()) {
            return;
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].isDirectory()) continue;
            unmountedRoots.add(fileArray[i].getName() + '/');
        }
    }

    public String getRootDir() {
        return fileSystemDirectory;
    }

    public String getUnmountedRootDir() {
        return unmountedFileSystemDirectory;
    }

    public static String getMountedRoots() {
        FileConnEventGenPanel.retrieveRoots();
        Enumeration<String> enumeration = roots.elements();
        StringBuffer stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append((Object)enumeration.nextElement());
        }
        String string = stringBuffer.toString();
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static List getMountedRootsList() {
        FileConnEventGenPanel.retrieveRoots();
        Enumeration<String> enumeration = roots.elements();
        Vector<String> vector = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        return vector;
    }

    public static List<String> getUnmountedRootsList() {
        FileConnEventGenPanel.retrieveUnmountedRoots();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(unmountedRoots);
        return arrayList;
    }

    public static String getInherentRoot() {
        return inherentRoot;
    }

    public static boolean isMountedRoot(String string) {
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        return roots.contains(string);
    }

    public static boolean isUnmountedRoot(String string) {
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        return unmountedRoots.contains(string);
    }

    public void mountFS(String string) {
        if (string != null && !"".equals(string)) {
            if (string.charAt(string.length() - 1) != '/') {
                string = string + '/';
            }
            File file = new File(fileSystemDirectory, string);
            File file2 = new File(unmountedFileSystemDirectory, string);
            if (file2.exists()) {
                file2.renameTo(file);
                unmountedRoots.remove(string);
            } else if (!file.exists()) {
                file.mkdirs();
            }
            roots.addElement(string);
            eventBridge.injectSystemEvent(Integer.parseInt("6000"));
        }
    }

    public void unmountFS(String string) {
        if (string.equals(inherentRoot + "/")) {
            return;
        }
        roots.removeElement(string);
        unmountedRoots.add(string);
        eventBridge.injectSystemEvent(Integer.parseInt("6001"));
        File file = new File(fileSystemDirectory, string);
        File file2 = new File(unmountedFileSystemDirectory);
        File file3 = new File(file2, string);
        if (!file2.exists()) {
            file2.mkdir();
        }
        file.renameTo(file3);
    }

    public void deleteUnmountedFS(String string) {
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        unmountedRoots.remove(string);
    }
}

