/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.util.io;

import com.sun.kvem.environment.ToolkitDirs;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class FileUtils {
    public static boolean deleteDir(File file) {
        FileUtils.deleteDirIml(file);
        boolean bl = false;
        try {
            file.delete();
            bl = file.isDirectory();
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        return !bl;
    }

    private static void deleteDirIml(File file) {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(file, stringArray[i]);
                if (file2.isDirectory()) {
                    FileUtils.deleteDir(file2);
                    file2.delete();
                    continue;
                }
                file2.delete();
            }
        } else {
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, File file2) throws IOException {
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            int n;
            byte[] byArray = new byte[1024];
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file2);
            while ((n = fileInputStream.read(byArray)) > -1) {
                fileOutputStream.write(byArray, 0, n);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            throw new IOException("File Not Found: " + fileNotFoundException);
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            finally {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
        }
    }

    public static File copyToTempFile(File file, String string, String string2) throws IOException {
        File file2 = File.createTempFile(string, string2, file.getAbsoluteFile().getParentFile());
        if (!Boolean.getBoolean("kvem.savetmp")) {
            file2.deleteOnExit();
        }
        FileUtils.copyFile(file, file2);
        return file2;
    }

    public static void copyDirectory(File file, File file2, boolean bl) throws IOException {
        if (!file.exists()) {
            return;
        }
        for (File file3 : file.listFiles()) {
            File file4;
            if (!file3.isDirectory()) {
                file4 = new File(file2, file3.getName());
                FileUtils.copyFile(file3, file4);
                continue;
            }
            if (!bl) continue;
            file4 = new File(file2, file3.getName());
            file4.mkdirs();
            FileUtils.copyDirectory(file3, file4, true);
        }
    }

    public static File[] getAPIFiles() {
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                String string = file.getName();
                int n = string.length();
                if (n > 4 && string.substring(n - 4).equalsIgnoreCase(".jar")) {
                    try {
                        Manifest manifest = new JarFile(file).getManifest();
                        Attributes attributes = manifest.getMainAttributes();
                        return attributes.getValue("API-Type") != null;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return false;
            }
        };
        return new File(ToolkitDirs.API).listFiles(fileFilter);
    }

    public static File[] splitFileListString(String string) {
        return FileUtils.splitFileListString(string, File.pathSeparator);
    }

    public static File[] splitFileListString(String string, String string2) {
        ArrayList<File> arrayList = new ArrayList<File>();
        int n = string.indexOf(string2);
        int n2 = 0;
        while (n != -1) {
            FileUtils.addFile(arrayList, string, n2, n);
            n2 = n + string2.length();
            n = string.indexOf(string2, n2);
        }
        FileUtils.addFile(arrayList, string, n2, string.length());
        return arrayList.toArray(new File[arrayList.size()]);
    }

    public static String createFileListString(File[] fileArray) {
        return FileUtils.createFileListString(fileArray, File.pathSeparator);
    }

    public static String createFileListString(File[] fileArray, String string) {
        if (fileArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(fileArray[0].getAbsolutePath());
        for (int i = 1; i < fileArray.length; ++i) {
            stringBuilder.append(string);
            stringBuilder.append(fileArray[i].getAbsolutePath());
        }
        return stringBuilder.toString();
    }

    public static String normalizeFileListString(String string) {
        return FileUtils.normalizeFileListString(string, File.pathSeparator);
    }

    public static String normalizeFileListString(String string, String string2) {
        File[] fileArray = FileUtils.splitFileListString(string, string2);
        return FileUtils.createFileListString(fileArray, string2);
    }

    private static void addFile(List<File> list, String string, int n, int n2) {
        if (n == n2) {
            return;
        }
        String string2 = string.substring(n, n2).trim();
        if (string2.length() > 0) {
            list.add(new File(string2));
        }
    }
}

