/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.tools.http;

import com.sun.kvem.tools.http.HttpServer;
import com.sun.kvem.tools.http.RequestListener;
import com.sun.kvem.util.MIMETypeHelper;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class Handler
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(Handler.class);
    public static final int BUFFER_SIZE = 2048;
    public static final byte[] EOL = new byte[]{13, 10};
    public static final int HTTP_OK = 200;
    public static final int HTTP_NOT_FOUND = 404;
    public static final int HTTP_BAD_METHOD = 405;
    public static final int DEFAULT_TIMEOUT = 0;
    public static final Map MIME_TYPES = Handler.createMimeTypesMap();
    private Socket socket;
    private HttpServer server;
    private volatile boolean keepRunning = true;
    private List<RequestListener> listeners;

    public Handler(HttpServer httpServer) {
        this(httpServer, "HTTP Request handler");
    }

    public Handler(HttpServer httpServer, String string) {
        super(string);
        this.server = httpServer;
    }

    public static Map createMimeTypesMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("", "content/unknown");
        hashMap.put("htm", "text/html");
        hashMap.put("html", "text/html");
        hashMap.put("text", "text/plain");
        hashMap.put("txt", "text/plain");
        hashMap.put("jad", "text/vnd.sun.j2me.app-descriptor");
        hashMap.put("jar", "application/java-archive");
        hashMap.put("png", "image/png");
        hashMap.put("gif", "image/gif");
        hashMap.put("jpg", "image/jpeg");
        hashMap.put("mpg", "video/mpeg");
        hashMap.put("wav", "audio/x-wav");
        hashMap.put("mid", "audio/midi");
        hashMap.put("jts", "audio/jts");
        hashMap.put("jpp", "text/vnd.sun.pay.provision");
        return hashMap;
    }

    public synchronized void setSocket(Socket socket) {
        this.socket = socket;
        this.notify();
    }

    public synchronized void stopHandling() {
        this.keepRunning = false;
        this.notify();
    }

    @Override
    public synchronized void run() {
        while (true) {
            if (this.socket == null && this.keepRunning) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            if (!this.keepRunning) break;
            try {
                this.handleClient();
            }
            catch (Exception exception) {
                LOGGER.error((Object)exception, (Throwable)exception);
            }
            this.setSocket(null);
            this.server.addIdleHandler(this);
        }
    }

    public void setRequestListeners(List<RequestListener> list) {
        this.listeners = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleClient() throws IOException {
        LOGGER.info((Object)"Handling client request");
        BufferedInputStream bufferedInputStream = new BufferedInputStream(this.socket.getInputStream());
        PrintStream printStream = new PrintStream(this.socket.getOutputStream());
        this.socket.setSoTimeout(0);
        this.socket.setTcpNoDelay(true);
        byte[] byArray = new byte[2048];
        try {
            Object object;
            Object object2;
            int n = 0;
            Request request = new Request();
            while (n < 2048) {
                if ((n = ((InputStream)bufferedInputStream).read(byArray, n, 2048 - n)) == -1) {
                    return;
                }
                request.data = new String(byArray);
                LOGGER.debug((Object)("Request: " + request.data));
                if (this.shouldKeepReading(request)) continue;
            }
            if (request == null) {
                return;
            }
            if (this.listeners != null) {
                object2 = this.listeners.iterator();
                while (object2.hasNext()) {
                    object = (RequestListener)object2.next();
                    object.notifyRequest(request.data);
                }
            }
            if (this.isInvalidRequestType((String)(object = ((StringTokenizer)(object2 = new StringTokenizer(request.data, " "))).nextToken()))) {
                this.notifyResponse("Invalid request type: " + (String)object);
                this.respondToInvalidRequest((String)object, printStream);
            } else {
                File file = this.parseDest(((StringTokenizer)object2).nextToken());
                LOGGER.info((Object)("Request was mapped to the file " + file));
                this.notifyResponse(String.format("Request was mapped to the %s file %s", file.exists() ? "existing" : "non-existing", file));
                this.respond((String)object, file, printStream);
            }
        }
        finally {
            printStream.close();
            this.socket.close();
        }
    }

    private void respondToInvalidRequest(String string, PrintStream printStream) throws IOException {
        printStream.print("HTTP/1.0 405 Request '" + string + "' not supported.");
        printStream.write(EOL);
        printStream.write(EOL);
        printStream.flush();
    }

    private boolean shouldKeepReading(Request request) {
        this.parseContentLength(request);
        if (request.contentLength == 0) {
            if (request.data.indexOf("\r\n\r\n") != -1 || request.data.indexOf("\r\r") != -1 || request.data.indexOf("\n\n") != -1) {
                return false;
            }
        } else if (request.contentLength > 0) {
            int n = Math.max(request.data.indexOf("\r\n\r\n"), request.data.indexOf("\r\r"));
            if (request.data.charAt(n + request.contentLength) == '\u0000') {
                request.content = request.data.substring(n, n + request.contentLength);
                return false;
            }
        } else {
            return true;
        }
        return true;
    }

    private void parseContentLength(Request request) {
        int n;
        int n2 = -1;
        int n3 = request.data.indexOf("Content-Length:");
        LOGGER.debug((Object)("index: " + n3));
        if (n3 != -1 && ((n = request.data.indexOf("\n", n3)) != -1 || (n = request.data.indexOf(13, n3)) != -1)) {
            String string = request.data.substring(n3 + 16, --n);
            LOGGER.debug((Object)("Content-Length header: " + string));
            n2 = Integer.parseInt(string);
        }
        if (n2 >= 0) {
            request.contentLength = n2;
        }
    }

    private void respond(String string, File file, PrintStream printStream) throws IOException {
        boolean bl = file.exists();
        LOGGER.info((Object)("Requested file exists: " + bl));
        if (string.equals("HEAD")) {
            this.sendHeader(bl, printStream);
            if (bl && !file.isDirectory()) {
                printStream.print("Content-length: " + file.length());
                printStream.write(EOL);
                String string2 = file.getName();
                printStream.print("Content-type: " + this.getContentType(string2));
            }
            printStream.write(EOL);
            printStream.write(EOL);
        } else if (string.equals("GET")) {
            this.sendHeader(bl, printStream);
            if (bl) {
                this.sendFile(file, printStream);
            }
        }
    }

    private File parseDest(String string) {
        String string2 = string.replace('/', File.separatorChar);
        if (string2.startsWith(File.separator)) {
            string2 = string2.substring(1);
        }
        return new File(this.server.getRootDirectory(), string2);
    }

    private boolean isInvalidRequestType(String string) throws IOException {
        return !string.equals("GET") && !string.equals("HEAD");
    }

    private void sendHeader(boolean bl, PrintStream printStream) throws IOException {
        int n = bl ? 200 : 404;
        printStream.print("HTTP/1.0 " + n + " OK");
        printStream.write(EOL);
        printStream.print("Server: WTK HTTP server");
        printStream.write(EOL);
        printStream.print("Date: " + new Date());
        printStream.write(EOL);
        if (!bl) {
            printStream.write(EOL);
            printStream.println("Error ...\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendFile(File file, PrintStream printStream) throws IOException {
        Object object;
        if (!file.isDirectory()) {
            printStream.print("Content-length: " + file.length());
            printStream.write(EOL);
            printStream.print("Last Modified: " + new Date(file.lastModified()));
            printStream.write(EOL);
            object = file.getName();
            printStream.print("Content-type: " + this.getContentType((String)object));
            printStream.write(EOL);
        }
        printStream.write(EOL);
        FileInputStream fileInputStream = new FileInputStream(file.getAbsolutePath());
        object = new byte[2048];
        try {
            int n;
            while ((n = ((InputStream)fileInputStream).read((byte[])object)) > 0) {
                printStream.write((byte[])object, 0, n);
            }
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
    }

    private String getContentType(String string) {
        int n = string.lastIndexOf(46);
        String string2 = string.substring(n + 1);
        String string3 = null;
        if (n > 0) {
            string3 = (String)MIME_TYPES.get(string2);
        }
        if (string3 == null) {
            string3 = MIMETypeHelper.getMIMEType(string2);
        }
        if (string3 == null || "".equals(string3)) {
            string3 = "unknown/unknown";
        }
        return string3;
    }

    private void notifyResponse(String string) {
        if (this.listeners != null) {
            for (RequestListener requestListener : this.listeners) {
                requestListener.notifyResponse(string);
            }
        }
    }

    class Request {
        int contentLength;
        String data;
        String content;

        Request() {
        }
    }
}

