/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.location.script.player;

import com.sun.jme.toolkit.location.script.player.ScriptLocation;
import com.sun.kvem.environment.Debug;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Timer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class LocationScript {
    private static Debug debug = Debug.create(LocationScript.class);
    private List waypoints = new LinkedList();
    private Timer timer;
    public static final int SCRIPT_STOPPED = 0;
    public static final int SCRIPT_RUNNING = 1;
    private int state = 0;
    private ScriptLocation currentLocation;
    private float currentSpeed = -1.0f;
    private ScriptLocation firstWaypoint;
    private ScriptLocation lastWaypoint;
    private ScriptLocation prevWaypoint;
    private ScriptLocation fromWaypoint;
    private ScriptLocation toWaypoint;
    private Iterator waypointsIterator;
    private long startTime;
    private long accumulatedTime;
    private InnerObservable stateChangeObservable = new InnerObservable();
    private InnerObservable locationChangeObservable = new InnerObservable();
    private static final double DEG2RAD = 0.01745329252;
    private static final double FLATTENING = 298.257223563;
    private static final double EARTH_RADIUS = 6378137.0;

    private LocationScript() {
    }

    public static LocationScript load(InputStream inputStream) throws IOException {
        final LocationScript locationScript = new LocationScript();
        try {
            SAXParserFactory.newInstance().newSAXParser().parse(new InputSource(inputStream), new DefaultHandler(){
                private long time = 0L;

                @Override
                public void startElement(String string, String string2, String string3, Attributes attributes) {
                    if (string3.equals("waypoint")) {
                        this.time += (long)this.getValue(attributes, "time", 0.0);
                        ScriptLocation scriptLocation = new ScriptLocation(this.time, (float)this.getValue(attributes, "course", 0.0), this.getValue(attributes, "latitude", 0.0), this.getValue(attributes, "longitude", 0.0), (float)this.getValue(attributes, "altitude", 0.0));
                        locationScript.waypoints.add(scriptLocation);
                    }
                }

                double getValue(Attributes attributes, String string, double d) {
                    String string2 = attributes.getValue(string);
                    if (string2 == null) {
                        return d;
                    }
                    return Double.parseDouble(string2);
                }
            });
            locationScript.initializeLocation();
        }
        catch (SAXException sAXException) {
            debug.exception(1, (Throwable)sAXException);
            throw new IOException(sAXException.toString());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            debug.exception(1, (Throwable)parserConfigurationException);
            throw new IOException(parserConfigurationException.toString());
        }
        inputStream.close();
        return locationScript;
    }

    public void addStateChangeObserver(Observer observer) {
        this.stateChangeObservable.addObserver(observer);
    }

    public void deleteStateChangeObserver(Observer observer) {
        this.stateChangeObservable.deleteObserver(observer);
    }

    public void addLocationChangeObserver(Observer observer) {
        this.locationChangeObservable.addObserver(observer);
    }

    public void deleteLocationChangeObserver(Observer observer) {
        this.locationChangeObservable.deleteObserver(observer);
    }

    public void start() {
        if (this.state == 1) {
            throw new IllegalStateException("Script is already running!");
        }
        if (this.isLastLocation()) {
            throw new IllegalStateException("Script has been finished already!");
        }
        this.startTime = System.currentTimeMillis();
        this.timer = new Timer(500, new TimeActionListener());
        this.timer.start();
        this.state = 1;
        this.stateChangeObservable.setChanged();
        this.stateChangeObservable.notifyObservers(this);
    }

    public void stop() {
        if (this.state == 0) {
            throw new IllegalStateException("Script has been stopped already!");
        }
        this.timer.stop();
        this.timer = null;
        long l = System.currentTimeMillis() - this.startTime;
        this.setTimeAux(this.firstWaypoint.getTime() + this.accumulatedTime + l);
        this.accumulatedTime = this.isLastLocation() ? 0L : (this.accumulatedTime += l);
        this.state = 0;
        this.stateChangeObservable.setChanged();
        this.stateChangeObservable.notifyObservers(this);
    }

    public void moveToNextWaypoint() {
        if (this.isLastLocation()) {
            throw new IllegalStateException("Script has been finished already!");
        }
        this.setTime(this.toWaypoint.getTime());
    }

    public void moveToPreviousWaypoint() {
        if (this.isFirstLocation()) {
            throw new IllegalStateException("Script is at the beginning!");
        }
        if (this.currentLocation.equals(this.fromWaypoint)) {
            this.setTime(this.prevWaypoint.getTime());
        } else {
            this.setTime(this.fromWaypoint.getTime());
        }
    }

    public void moveToFirstWaypoint() {
        if (this.isFirstLocation()) {
            throw new IllegalStateException("Script is at the beginning!");
        }
        this.setTime(this.firstWaypoint.getTime());
    }

    public void moveToLastWaypoint() {
        if (this.isLastLocation()) {
            throw new IllegalStateException("Script is at the end!");
        }
        this.setTime(this.lastWaypoint.getTime());
    }

    public void setTime(long l) {
        if (this.firstWaypoint == null) {
            return;
        }
        if (l < this.fromWaypoint.getTime()) {
            this.waypointsIterator = this.waypoints.iterator();
            this.prevWaypoint = null;
            this.fromWaypoint = (ScriptLocation)this.waypointsIterator.next();
            this.toWaypoint = this.waypointsIterator.hasNext() ? (ScriptLocation)this.waypointsIterator.next() : this.fromWaypoint;
            this.currentSpeed = -1.0f;
        }
        this.setTimeAux(l);
        this.accumulatedTime = this.currentLocation.getTime() - this.firstWaypoint.getTime();
        if (this.state == 1) {
            this.startTime = System.currentTimeMillis();
        }
    }

    public int getCurrentState() {
        return this.state;
    }

    public ScriptLocation getCurrentLocation() {
        return this.currentLocation;
    }

    public boolean isFirstLocation() {
        return this.currentLocation == null || this.currentLocation.equals(this.firstWaypoint);
    }

    public boolean isLastLocation() {
        return this.currentLocation == null || this.currentLocation.equals(this.lastWaypoint);
    }

    public float getCurrentSpeed() {
        if (this.state != 1) {
            return 0.0f;
        }
        if (this.currentSpeed < 0.0f) {
            this.updateSpeed();
        }
        return this.currentSpeed;
    }

    public Iterator getWaypoints() {
        return this.waypoints.iterator();
    }

    public ScriptLocation getFirstWaypoint() {
        return this.firstWaypoint;
    }

    public ScriptLocation getLastWaypoint() {
        return this.lastWaypoint;
    }

    private void initializeLocation() {
        this.waypointsIterator = this.waypoints.iterator();
        if (!this.waypointsIterator.hasNext()) {
            return;
        }
        this.fromWaypoint = this.firstWaypoint = (ScriptLocation)this.waypointsIterator.next();
        if (!this.waypointsIterator.hasNext()) {
            this.lastWaypoint = this.firstWaypoint;
            this.toWaypoint = this.firstWaypoint;
            this.setCurrentLocation(this.firstWaypoint);
            return;
        }
        this.lastWaypoint = (ScriptLocation)this.waypoints.get(this.waypoints.size() - 1);
        this.toWaypoint = (ScriptLocation)this.waypointsIterator.next();
        this.setCurrentLocation(this.firstWaypoint);
    }

    private void setCurrentLocation(ScriptLocation scriptLocation) {
        if (!scriptLocation.equals(this.currentLocation)) {
            this.currentLocation = scriptLocation;
            this.locationChangeObservable.setChanged();
            this.locationChangeObservable.notifyObservers(this);
        }
    }

    private void setTimeAux(long l) {
        long l2;
        while (l >= this.toWaypoint.getTime()) {
            if (!this.waypointsIterator.hasNext()) {
                this.setCurrentLocation(this.toWaypoint);
                return;
            }
            this.prevWaypoint = this.fromWaypoint;
            this.fromWaypoint = this.toWaypoint;
            this.toWaypoint = (ScriptLocation)this.waypointsIterator.next();
            this.currentSpeed = -1.0f;
        }
        long l3 = this.fromWaypoint.getTime();
        float f = l3 != (l2 = this.toWaypoint.getTime()) ? (float)(l - l3) / (float)(l2 - l3) : 1.0f;
        double d = this.fromWaypoint.getLatitude() + (this.toWaypoint.getLatitude() - this.fromWaypoint.getLatitude()) * (double)f;
        double d2 = this.fromWaypoint.getLongitude() + (this.toWaypoint.getLongitude() - this.fromWaypoint.getLongitude()) * (double)f;
        float f2 = this.fromWaypoint.getAltitude() + (this.toWaypoint.getAltitude() - this.fromWaypoint.getAltitude()) * f;
        this.setCurrentLocation(new ScriptLocation(l, this.fromWaypoint.getCourse(), d, d2, f2));
    }

    private void updateSpeed() {
        this.currentSpeed = !this.fromWaypoint.equals(this.toWaypoint) ? this.calculateSpeed(this.fromWaypoint, this.toWaypoint) : 0.0f;
    }

    private float calculateSpeed(ScriptLocation scriptLocation, ScriptLocation scriptLocation2) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0033528106647474805;
        double d13 = -12.5;
        double d14 = scriptLocation.getLongitude() * 0.01745329252;
        double d15 = scriptLocation.getLatitude() * 0.01745329252;
        double d16 = scriptLocation2.getLongitude() * 0.01745329252;
        double d17 = scriptLocation2.getLatitude() * 0.01745329252;
        double d18 = 1.0 - d12;
        double d19 = d18 * Math.sin(d15) / Math.cos(d15);
        double d20 = d18 * Math.sin(d17) / Math.cos(d17);
        double d21 = 1.0 / Math.sqrt(1.0 + d19 * d19);
        double d22 = d21 * d19;
        double d23 = 1.0 / Math.sqrt(1.0 + d20 * d20);
        double d24 = d21 * d23;
        double d25 = d24 * d20;
        double d26 = d25 * d19;
        double d27 = d16 - d14;
        do {
            d6 = Math.sin(d27);
            d8 = Math.cos(d27);
            d19 = d23 * d6;
            d20 = d25 - d22 * d23 * d8;
            d7 = Math.sqrt(d19 * d19 + d20 * d20);
            d9 = d24 * d8 + d26;
            d4 = Math.atan2(d7, d9);
            d5 = d24 * d6 / d7;
            d11 = -d5 * d5 + 1.0;
            d10 = d26 + d26;
            if (d11 > 0.0) {
                d10 = -d10 / d11 + d9;
            }
            d3 = d10 * d10 * 2.0 - 1.0;
            d = ((-3.0 * d11 + 4.0) * d12 + 4.0) * d11 * d12 / 16.0;
            d2 = d27;
            d27 = ((d3 * d9 * d + d10) * d7 * d + d4) * d5;
        } while (Math.abs(d2 - (d27 = (1.0 - d) * d27 * d12 + d16 - d14)) <= d13);
        d26 = Math.atan2(d19, d20);
        d27 = Math.sqrt((1.0 / d18 / d18 - 1.0) * d11 + 1.0) + 1.0;
        d27 = (d27 - 2.0) / d27;
        d = 1.0 - d27;
        d = (d27 * d27 / 4.0 + 1.0) / d;
        d2 = (0.375 * d27 * d27 - 1.0) * d27;
        d27 = d3 * d9;
        d24 = 1.0 - d3 * d3;
        double d28 = ((((d7 * d7 * 4.0 - 3.0) * d24 * d10 * d2 / 6.0 - d27) * d2 / 4.0 + d10) * d7 * d2 + d4) * d * 6378137.0 * d18;
        return (float)((double)Math.abs(scriptLocation2.getTime() - scriptLocation.getTime()) / 1000.0 * d28);
    }

    private class TimeActionListener
    implements ActionListener {
        private TimeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            long l = System.currentTimeMillis() - LocationScript.this.startTime;
            LocationScript.this.setTimeAux(LocationScript.this.firstWaypoint.getTime() + LocationScript.this.accumulatedTime + l);
            if (LocationScript.this.isLastLocation()) {
                LocationScript.this.timer.stop();
                LocationScript.this.timer = null;
                LocationScript.this.accumulatedTime = 0L;
                LocationScript.this.state = 0;
                LocationScript.this.stateChangeObservable.setChanged();
                LocationScript.this.stateChangeObservable.notifyObservers(this);
            }
        }
    }

    private class InnerObservable
    extends Observable {
        private InnerObservable() {
        }

        @Override
        public void setChanged() {
            super.setChanged();
        }
    }
}

