/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.ueiproxy;

import com.sun.jme.toolkit.deviceRegistry.api.DeviceManager;
import com.sun.jme.toolkit.deviceRegistry.api.RegistrationData;
import com.sun.jme.toolkit.deviceadapter.api.DeviceProperties;
import com.sun.jme.toolkit.ueiproxy.CommandHandler;
import com.sun.jme.toolkit.ueiproxy.DeviceManagerConnector;
import com.sun.jme.toolkit.ueiproxy.Main;
import com.sun.jme.toolkit.ueiproxy.RunOptions;
import com.sun.jme.toolkit.ueiproxy.UEIPropertiesHelper;
import com.sun.jme.toolkit.ueiproxy.UeiProxyException;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class QueryHandler
implements CommandHandler {
    private static final String COMMAND = "-Xquery";
    private static final Logger logger = Logger.getLogger(QueryHandler.class);
    private DeviceManagerConnector deviceManagerConnector;
    private Main main;

    public void setDeviceManagerConnector(DeviceManagerConnector deviceManagerConnector) {
        this.deviceManagerConnector = deviceManagerConnector;
    }

    public void setUEIProxyMain(Main main) {
        this.main = main;
    }

    public void processCommand(String string, String[] stringArray, String string2, RunOptions runOptions) throws UeiProxyException {
        DeviceManager deviceManager = this.deviceManagerConnector.getDeviceManager();
        StringBuffer stringBuffer = new StringBuffer();
        if (string == null) {
            System.out.println("# List of supported devices");
            System.out.print("device.list: ");
            Object[] objectArray = deviceManager.getDeviceRegistrations();
            Arrays.sort(objectArray);
            String string3 = System.getProperty("uei-proxy.default-device");
            if (objectArray.length > 0) {
                if (string3 != null) {
                    System.out.print(string3);
                    if (string == null || string != null && string3.equals(string)) {
                        this.appendPropertiesForDevice(stringBuffer, string3, deviceManager.lookupDeviceId(string3));
                    }
                    if (objectArray.length > 1) {
                        System.out.print(",");
                    }
                }
                for (int i = 0; i < objectArray.length; ++i) {
                    String string4 = objectArray[i].getName();
                    if (string3 != null && string3.equals(string4)) continue;
                    System.out.print(string4);
                    if (string == null || string != null && string4.equals(string)) {
                        this.appendPropertiesForDevice(stringBuffer, string4, deviceManager.lookupDeviceId(string4));
                    }
                    if (i >= objectArray.length - 1) continue;
                    System.out.print(",");
                }
            }
            System.out.println();
            System.out.println("uei.version: 1.0.1");
            System.out.println("uei.arguments: " + UEIPropertiesHelper.list2String((List)this.main.getSupportedCommands()));
        } else {
            RegistrationData[] registrationDataArray = new RegistrationData[]{deviceManager.getDeviceRegistration(deviceManager.lookupDeviceId(string))};
            this.appendPropertiesForDevice(stringBuffer, string, deviceManager.lookupDeviceId(string));
        }
        System.out.println(stringBuffer.toString());
    }

    private void appendPropertiesForDevice(StringBuffer stringBuffer, String string, int n) {
        stringBuffer.append("\n");
        stringBuffer.append("# Properties for device ");
        stringBuffer.append(string);
        stringBuffer.append("\n");
        try {
            DeviceProperties deviceProperties = this.deviceManagerConnector.getDeviceProperties(n);
            this.putPropertyLine(stringBuffer, string, "descriptor", deviceProperties.getDescription());
            this.putPropertyLine(stringBuffer, string, "version.configuration", deviceProperties.getConfiguration());
            this.putPropertyLine(stringBuffer, string, "version.profile", deviceProperties.getProfile());
            this.putPropertyLine(stringBuffer, string, "screen.width", deviceProperties.getScreenWidth());
            this.putPropertyLine(stringBuffer, string, "screen.height", deviceProperties.getScreenHeight());
            this.putPropertyLine(stringBuffer, string, "screen.isColor", deviceProperties.isColor());
            this.putPropertyLine(stringBuffer, string, "screen.isTouch", deviceProperties.isTouch());
            this.putPropertyLine(stringBuffer, string, "screen.bitDepth", deviceProperties.getBitDepth());
            String string2 = deviceProperties.getSecurityDomains();
            if (string2 != null && string2.length() > 0) {
                this.putPropertyLine(stringBuffer, string, "security.domains", string2);
            }
            this.putPropertyLine(stringBuffer, string, "uei.arguments", UEIPropertiesHelper.array2String((String[])deviceProperties.getArguments()));
            String string3 = UEIPropertiesHelper.array2String((String[])deviceProperties.getBootClassPath());
            this.putPropertyLine(stringBuffer, string, "bootclasspath", string3);
            this.putPropertyLine(stringBuffer, string, "apis", string3);
        }
        catch (Exception exception) {
            stringBuffer.append("Cannot obtain device properties: ");
            stringBuffer.append(exception.getMessage());
            logger.error((Object)"Cannot obtain device properties", (Throwable)exception);
        }
    }

    public String getCommand() {
        logger.trace((Object)"getCommand() -->");
        logger.trace((Object)"<-- getCommand() = -Xquery");
        return COMMAND;
    }

    public String getCommandDescription() {
        logger.trace((Object)"getCommandDescription() -->");
        logger.trace((Object)"<-- getCommandDescription()");
        return "-Xquery            Print device information";
    }

    private void putPropertyLine(StringBuffer stringBuffer, String string, String string2, String string3) {
        if (string3 != null) {
            stringBuffer.append(string);
            stringBuffer.append(".");
            stringBuffer.append(string2);
            stringBuffer.append(": ");
            stringBuffer.append(string3);
            stringBuffer.append("\n");
        }
    }

    public boolean requiresDeviceName() {
        return false;
    }

    public boolean addSupportedCommand(String string) {
        return string.startsWith(COMMAND);
    }
}

