/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cldchi.tools.memoryprofiler.data;

import com.sun.cldchi.tools.memoryprofiler.data.JavaObject;

public class ClassStatistics {
    public final String _class_name;
    private int _count;
    private int _total_size;
    private static int _total_heap_size;
    private int _dead_size;
    private int _old_gen_size;

    public ClassStatistics(String string) {
        this._class_name = string;
        this._old_gen_size = 0;
        this._dead_size = 0;
        this._total_size = 0;
        this._count = 0;
    }

    public int getHeapPercentage() {
        if (_total_heap_size == 0) {
            return 0;
        }
        return 10000 * this._total_size / _total_heap_size;
    }

    public int getAverageSize() {
        if (this._count == 0) {
            return 0;
        }
        return this._total_size / this._count;
    }

    public int getLivePercentage() {
        if (this._total_size == 0) {
            return 0;
        }
        return 10000 * (this._total_size - this._dead_size) / this._total_size;
    }

    public int getOldGenPercentage() {
        if (this._total_size == 0) {
            return 0;
        }
        return 10000 * this._old_gen_size / this._total_size;
    }

    public void add(JavaObject javaObject, int n) {
        _total_heap_size += javaObject.size;
        ++this._count;
        this._total_size += javaObject.size;
        if (!javaObject.alive()) {
            this._dead_size += javaObject.size;
        }
        if (javaObject.address < n) {
            this._old_gen_size += javaObject.size;
        }
    }

    public static void reset() {
        _total_heap_size = 0;
    }

    public int getCount() {
        return this._count;
    }

    public int getTotalSize() {
        return this._total_size;
    }
}

