/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cldchi.tools.memoryprofiler.data;

import com.sun.cldchi.tools.memoryprofiler.data.ClassStatistics;
import com.sun.cldchi.tools.memoryprofiler.data.JavaClass;
import com.sun.cldchi.tools.memoryprofiler.data.JavaObject;
import com.sun.cldchi.tools.memoryprofiler.data.MPDataProvider;
import com.sun.cldchi.tools.memoryprofiler.jdwp.BoundException;
import com.sun.cldchi.tools.memoryprofiler.jdwp.DebugeeException;
import com.sun.cldchi.tools.memoryprofiler.jdwp.VMConnection;
import com.sun.cldchi.tools.memoryprofiler.jdwp.VMReply;
import java.net.ConnectException;
import java.net.SocketException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;

class GlobalData
implements MPDataProvider {
    private VMConnection _connector;
    private int _heap_start;
    private int _heap_top;
    private int _old_gen_end;
    private int _allocation_top;
    private HashMap _allJavaObjects = new HashMap();
    private HashMap _allClasses = new HashMap();
    private static final int MPGetGlobalData = 4609;
    private static final int MPGetHeapData = 4610;
    private static final int MPGetClasses = 4611;
    private static final int MPGetRoots = 4612;
    private static final int MPVMSuspend = 4613;
    private static final int MPVMResume = 4614;
    private static final int MPVMStackTrace = 4615;
    public static final String InternalObjectName = "VM Internal object";
    public static final String StaticsObjectName = "Statics of class ";
    public static final String StackObjectName = "Stack object";
    private static final int CLASS_ID_OFFSET = 0;
    private static final int TASK_ID_OFFSET = 16;
    private static final int OBJ_TYPE_OFFSET = 23;

    public int get_heap_start() {
        return this._heap_start;
    }

    public int get_heap_top() {
        return this._heap_top;
    }

    public int get_old_gen_end() {
        return this._old_gen_end;
    }

    public int get_allocation_top() {
        return this._allocation_top;
    }

    GlobalData(VMConnection vMConnection) {
        this._connector = vMConnection;
    }

    private void update() throws SocketException {
        this.getClassList();
        this.getAllData();
        this.getRoots();
        try {
            VMReply vMReply = this._connector.sendReplyCommand(4609);
            this._heap_start = vMReply.getInt();
            this._heap_top = vMReply.getInt();
            this._old_gen_end = vMReply.getInt();
            this._allocation_top = vMReply.getInt();
        }
        catch (DebugeeException debugeeException) {
            this.reset();
            throw new SocketException(debugeeException.getMessage());
        }
        catch (BoundException boundException) {
            this.reset();
            throw new SocketException(boundException.getMessage());
        }
        this.calculateDeadObjects();
    }

    public JavaClass[] getClassList() throws SocketException {
        this._allClasses.clear();
        JavaClass[] javaClassArray = null;
        try {
            VMReply vMReply = this._connector.sendReplyCommand(4611);
            int n = vMReply.getInt();
            javaClassArray = new JavaClass[n];
            for (int i = 0; i < n; ++i) {
                int n2 = vMReply.getInt();
                String string = this.objectTypeNameFromJNI(vMReply.getString());
                JavaClass javaClass = new JavaClass(n2, string);
                this._allClasses.put(new Integer(n2), javaClass);
                javaClassArray[i] = javaClass;
            }
        }
        catch (Exception exception) {
            this.reset();
            throw new SocketException(exception.getMessage());
        }
        return javaClassArray;
    }

    private void getAllData() throws SocketException {
        int n = 1;
        int n2 = 1;
        this._allJavaObjects.clear();
        try {
            int n3;
            do {
                VMReply vMReply = this._connector.sendReplyCommand(4610);
                n3 = vMReply.getInt();
                while (n3 != -1 && n3 != -2) {
                    int n4;
                    int n5;
                    int n6 = vMReply.getInt();
                    int n7 = vMReply.getInt();
                    int n8 = n7 >> 23;
                    int n9 = -1;
                    if (n8 == 2) {
                        n9 = vMReply.getInt();
                        ++n;
                    }
                    int n10 = vMReply.getInt();
                    int[] nArray = new int[n10];
                    HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>(n10);
                    if (n8 == 2) {
                        for (n5 = 0; n5 < n10; ++n5) {
                            nArray[n5] = vMReply.getInt();
                            n4 = vMReply.getInt();
                            Integer n11 = (Integer)hashMap.get(new Integer(nArray[n5]));
                            if (n11 != null && n11 >= n4) continue;
                            hashMap.put(new Integer(nArray[n5]), new Integer(n4));
                        }
                        n += n10;
                    } else {
                        for (n5 = 0; n5 < n10; ++n5) {
                            nArray[n5] = vMReply.getInt();
                        }
                    }
                    JavaClass javaClass = (JavaClass)this._allClasses.get(new Integer(n7 &= 0x7FFFFF));
                    n4 = n7;
                    if (javaClass != null) {
                        n4 = javaClass.id;
                    }
                    if (n8 == 0) {
                        this._allJavaObjects.put(new Integer(n3), new JavaObject(n3, n4, n6, nArray, 0));
                    } else if (n8 == 1) {
                        this._allJavaObjects.put(new Integer(n3), new JavaObject(n3, n4, n6, nArray, 1));
                    } else if (n8 == 2) {
                        this._allJavaObjects.put(new Integer(n3), new JavaObject(n3, -1, n6, nArray, 2, hashMap, n9));
                    } else if (n8 == 3) {
                        this._allJavaObjects.put(new Integer(n3), new JavaObject(n3, -1, n6, nArray, 3));
                    } else {
                        System.out.println("Wrong response from VM! Unknown object type. Skipped!");
                    }
                    n3 = vMReply.getInt();
                    n += 4;
                    n += n10;
                    ++n2;
                }
            } while (n3 != -1);
        }
        catch (Exception exception) {
            this.reset();
            throw new SocketException(exception.getMessage());
        }
        this.updateAllObjects();
    }

    private void updateAllObjects() {
        Iterator iterator = this._allJavaObjects.values().iterator();
        while (iterator.hasNext()) {
            JavaObject javaObject = (JavaObject)iterator.next();
            for (int i = 0; i < javaObject._references_addresses.length; ++i) {
                JavaObject javaObject2 = this.getObjectByAddress(javaObject._references_addresses[i]);
                if (javaObject2 == null) continue;
                javaObject.add_reference(javaObject2);
                javaObject2.add_referee(javaObject);
            }
        }
    }

    private JavaObject getObjectByAddress(int n) {
        Integer n2 = new Integer(n);
        return (JavaObject)this._allJavaObjects.get(n2);
    }

    public JavaObject[] getObjectsOfClass(JavaClass javaClass) {
        Object object;
        if (javaClass == null) {
            return new JavaObject[0];
        }
        int n = 0;
        int n2 = javaClass.id;
        JavaObject[] javaObjectArray = this._allJavaObjects.values().iterator();
        while (javaObjectArray.hasNext()) {
            object = (JavaObject)javaObjectArray.next();
            if (((JavaObject)object).object_type != 0 || ((JavaObject)object).class_id != n2) continue;
            ++n;
        }
        javaObjectArray = new JavaObject[n];
        n = 0;
        object = this._allJavaObjects.values().iterator();
        while (object.hasNext()) {
            JavaObject javaObject = (JavaObject)object.next();
            if (javaObject.object_type != 0 || javaObject.class_id != n2) continue;
            javaObjectArray[n++] = javaObject;
        }
        return javaObjectArray;
    }

    public Iterator getObjects() {
        return this._allJavaObjects.values().iterator();
    }

    public void connect(String string, int n) throws ConnectException, SocketException {
        this._connector.connect(string, n);
        this.pauseVM();
    }

    public String getObjectTypeName(JavaObject javaObject) {
        if (javaObject.object_type == 0 || javaObject.object_type == 1) {
            JavaClass javaClass = (JavaClass)this._allClasses.get(new Integer(javaObject.class_id));
            if (javaClass == null) {
                System.out.println(javaObject.class_id);
                System.out.println(javaObject.object_type);
                return "null!";
            }
            if (javaObject.object_type == 0) {
                return javaClass.name;
            }
            return StaticsObjectName + javaClass.name;
        }
        if (javaObject.object_type == 2) {
            return StackObjectName;
        }
        if (javaObject.object_type == 3) {
            return InternalObjectName;
        }
        return "Wrong object type! Report a bug please!";
    }

    private void getRoots() throws SocketException {
        try {
            VMReply vMReply = this._connector.sendReplyCommand(4612);
            int n = vMReply.getInt();
            while (n != -1) {
                Integer n2 = new Integer(n);
                JavaObject javaObject = (JavaObject)this._allJavaObjects.get(n2);
                if (javaObject != null) {
                    javaObject.setRootDistance(0);
                }
                n = vMReply.getInt();
            }
        }
        catch (Exception exception) {
            this.reset();
            throw new SocketException(exception.getMessage());
        }
    }

    private void calculateDeadObjects() {
        boolean bl = true;
        while (bl) {
            bl = false;
            Iterator iterator = this._allJavaObjects.values().iterator();
            while (iterator.hasNext()) {
                JavaObject javaObject = (JavaObject)iterator.next();
                if (javaObject.getRootDistance() == -1) continue;
                Object[] objectArray = javaObject.get_references();
                for (int i = 0; i < objectArray.length; ++i) {
                    JavaObject javaObject2 = (JavaObject)objectArray[i];
                    if (javaObject2.getRootDistance() == -1) {
                        javaObject2.setRootDistance(javaObject.getRootDistance() + 1);
                        bl = true;
                        continue;
                    }
                    if (javaObject2.getRootDistance() <= 1 + javaObject.getRootDistance()) continue;
                    javaObject2.setRootDistance(javaObject.getRootDistance() + 1);
                    bl = true;
                }
            }
        }
    }

    public JavaObject[] pathFromTheRoot(JavaObject javaObject) {
        if (javaObject == null) {
            return null;
        }
        if (javaObject.getRootDistance() == -1) {
            return null;
        }
        JavaObject[] javaObjectArray = new JavaObject[javaObject.getRootDistance() + 1];
        int n = javaObject.getRootDistance();
        while (n > 0) {
            javaObjectArray[n--] = javaObject;
            Object[] objectArray = javaObject.get_referees();
            for (int i = 0; i < objectArray.length; ++i) {
                JavaObject javaObject2 = (JavaObject)objectArray[i];
                if (javaObject2.getRootDistance() != javaObject.getRootDistance() - 1) continue;
                javaObject = javaObject2;
                break;
            }
            if (n == javaObject.getRootDistance()) continue;
            throw new RuntimeException("problem here!");
        }
        javaObjectArray[n--] = javaObject;
        return javaObjectArray;
    }

    public JavaObject[] getObjectsFromTheAddresses(int n, int n2) {
        Object object;
        if (n > n2) {
            throw new RuntimeException();
        }
        int n3 = 0;
        JavaObject[] javaObjectArray = this._allJavaObjects.values().iterator();
        while (javaObjectArray.hasNext()) {
            object = (JavaObject)javaObjectArray.next();
            if (((JavaObject)object).address + ((JavaObject)object).size <= n || ((JavaObject)object).address >= n2) continue;
            ++n3;
        }
        javaObjectArray = new JavaObject[n3];
        n3 = 0;
        object = this._allJavaObjects.values().iterator();
        while (object.hasNext()) {
            JavaObject javaObject = (JavaObject)object.next();
            if (javaObject.address + javaObject.size <= n || javaObject.address >= n2) continue;
            javaObjectArray[n3++] = javaObject;
        }
        Arrays.sort(javaObjectArray, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((JavaObject)object).address - ((JavaObject)object2).address;
            }
        });
        return javaObjectArray;
    }

    public void pauseVM() throws SocketException {
        try {
            this._connector.sendCommand(4613);
            this.update();
        }
        catch (Exception exception) {
            this.reset();
            throw new SocketException(exception.getMessage());
        }
    }

    public void resumeVM() throws SocketException {
        try {
            this.reset();
            this._connector.sendCommand(4614);
        }
        catch (Exception exception) {
            this.reset();
            throw new SocketException(exception.getMessage());
        }
    }

    public ClassStatistics[] calculateStatistics() {
        int n;
        ClassStatistics[] classStatisticsArray;
        ClassStatistics.reset();
        int n2 = this._allClasses.values().size() + 1;
        HashMap<Integer, ClassStatistics> hashMap = new HashMap<Integer, ClassStatistics>(n2);
        Object[] objectArray = this._allClasses.values().iterator();
        while (objectArray.hasNext()) {
            classStatisticsArray = (JavaClass)objectArray.next();
            hashMap.put(new Integer(classStatisticsArray.id), new ClassStatistics(classStatisticsArray.name));
        }
        hashMap.put(new Integer(-1), new ClassStatistics("Internal VM Objects"));
        objectArray = this._allJavaObjects.values().iterator();
        while (objectArray.hasNext()) {
            ClassStatistics classStatistics;
            classStatisticsArray = (JavaObject)objectArray.next();
            n = classStatisticsArray.class_id;
            if (classStatisticsArray.object_type != 0) {
                n = -1;
            }
            if ((classStatistics = (ClassStatistics)hashMap.get(new Integer(n))) == null) continue;
            classStatistics.add((JavaObject)classStatisticsArray, this.get_old_gen_end());
        }
        objectArray = hashMap.values().toArray();
        Arrays.sort(objectArray, new Comparator(){

            public int compare(Object object, Object object2) {
                ClassStatistics classStatistics = (ClassStatistics)object;
                ClassStatistics classStatistics2 = (ClassStatistics)object2;
                return classStatistics2.getHeapPercentage() - classStatistics.getHeapPercentage();
            }
        });
        classStatisticsArray = new ClassStatistics[objectArray.length];
        for (n = 0; n < classStatisticsArray.length; ++n) {
            classStatisticsArray[n] = (ClassStatistics)objectArray[n];
        }
        return classStatisticsArray;
    }

    private String objectTypeNameFromJNI(String string) {
        if (string.indexOf("L") != 0 || string.lastIndexOf(";") != string.length() - 1) {
            return string;
        }
        char[] cArray = new char[string.length() - 2];
        string.getChars(1, string.length() - 1, cArray, 0);
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != '/') continue;
            cArray[i] = 46;
        }
        return new String(cArray);
    }

    public void closeConnections() {
        this.reset();
        this._connector.closeConnections();
    }

    private void setConnector(VMConnection vMConnection) {
        if (this._connector == null) {
            this._connector = vMConnection;
            return;
        }
        if (this._connector.isConnected()) {
            throw new IllegalStateException("Another connector is connected to the VM");
        }
        this._connector = vMConnection;
        this.reset();
    }

    public String getStackTrace(JavaObject javaObject, int n) throws SocketException {
        if (javaObject.object_type != 2) {
            return "JavaObject of wrong type type was passed to MPDataProvider.getStackTrace.\nPlease report a bug!";
        }
        int[] nArray = new int[2];
        nArray[0] = javaObject._stack_id;
        Integer n2 = (Integer)javaObject._stack_offsets.get(new Integer(n));
        nArray[1] = n2;
        String string = null;
        try {
            VMReply vMReply = this._connector.sendReplyCommand(4615, nArray);
            string = vMReply.getString();
        }
        catch (Exception exception) {
            string = "VM connection is broken!";
            this.reset();
            throw new SocketException(exception.getMessage());
        }
        return string;
    }

    private void reset() {
        this._heap_start = 0;
        this._heap_top = 0;
        this._old_gen_end = 0;
        this._allocation_top = 0;
        this._allJavaObjects.clear();
        this._allClasses.clear();
        ClassStatistics.reset();
    }
}

