/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cldchi.tools.memoryprofiler.jdwp;

import com.sun.cldchi.tools.memoryprofiler.jdwp.Command;
import com.sun.cldchi.tools.memoryprofiler.jdwp.DebugeeException;
import com.sun.cldchi.tools.memoryprofiler.jdwp.Packet;
import com.sun.cldchi.tools.memoryprofiler.jdwp.Reply;
import com.sun.cldchi.tools.memoryprofiler.jdwp.SocketTransport;
import com.sun.cldchi.tools.memoryprofiler.jdwp.Tools;
import com.sun.cldchi.tools.memoryprofiler.jdwp.VMConnection;
import com.sun.cldchi.tools.memoryprofiler.jdwp.VMReply;
import com.sun.cldchi.tools.memoryprofiler.jdwp.jdwp;
import java.io.IOException;
import java.net.ConnectException;
import java.util.Vector;

class BackEndTest
extends jdwp
implements VMConnection {
    public static boolean verbose = false;
    public boolean is_connected = false;
    public SocketTransport debug;

    BackEndTest() {
    }

    public void connect(String string, int n) throws ConnectException {
        try {
            this.openConnections(string, n);
            this.is_connected = true;
        }
        catch (DebugeeException debugeeException) {
            throw new ConnectException(debugeeException.getMessage());
        }
        catch (IOException iOException) {
            throw new ConnectException(iOException.getMessage());
        }
    }

    private void openConnections(String string, int n) throws ConnectException, DebugeeException {
        try {
            Tools.wait(1000);
            this.debug = new SocketTransport();
            this.debug.attachToServer(string, n);
            this.debug.Handshake();
        }
        catch (Exception exception) {
            System.err.println("* Exception.\n");
            throw new ConnectException("Can't create JDWP connection.");
        }
        System.out.println("* JDWP connection is installed.");
        this.getIDSizes();
    }

    public void closeConnections() {
        if (this.debug != null) {
            try {
                this.debug.done();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.debug = null;
        }
        this.is_connected = false;
    }

    public static void print(String string) {
        if (string.equals("")) {
            return;
        }
        System.out.println(string);
    }

    public static void print(Vector vector) throws Exception {
        System.out.println(Tools.listVector(vector));
    }

    public static void print(Packet packet, String string) throws Exception {
        BackEndTest.print(packet.parse(string));
    }

    public Command sendCommand(Command command) throws DebugeeException {
        try {
            this.debug.sendCommand(command);
        }
        catch (IOException iOException) {
            throw new DebugeeException(iOException.getMessage());
        }
        return command;
    }

    public void printReplies() throws IOException {
        this.debug.receive();
        if (this.debug.Replies.size() == 0) {
            return;
        }
        BackEndTest.print("\nReplies:\n");
        for (int i = 0; i < this.debug.Replies.size(); ++i) {
            BackEndTest.print("\n" + (Reply)this.debug.Replies.elementAt(i) + "\n");
        }
    }

    public Reply checkReply(Command command) throws IOException, DebugeeException {
        this.sendCommand(command);
        Reply reply = this.debug.receiveReply(command.getID(), 100000);
        if (reply.getErrorCode() == 1025) {
            BackEndTest.print("\nCommand:\n" + command);
            this.printReplies();
            throw new DebugeeException("Reply packet is not received.");
        }
        return reply;
    }

    public Reply checkReply(Command command, int n, String string) throws IOException, DebugeeException {
        Reply reply = this.checkReply(command);
        if (reply.getErrorCode() != n) {
            BackEndTest.print("\nCommand:\n" + command + "\nReply:\n" + reply);
            String string2 = "Unexpected error code";
            string = !string.equals("") ? "Unexpected error code (" + string + ")." : "Unexpected error code.";
            throw new DebugeeException(string);
        }
        return reply;
    }

    public void getIDSizes() throws DebugeeException {
        try {
            Command command = new Command(263);
            Reply reply = this.checkReply(command);
            reply.resetDataParser();
            fieldIDSize = reply.getInt();
            methodIDSize = reply.getInt();
            objectIDSize = reply.getInt();
            referenceTypeIDSize = reply.getInt();
            frameIDSize = reply.getInt();
        }
        catch (Exception exception) {
            throw new DebugeeException("Exception occured in IDSizes function");
        }
    }

    public VMReply sendReplyCommand(int n, int[] nArray) throws DebugeeException {
        try {
            Command command = new Command(n);
            for (int i = 0; i < nArray.length; ++i) {
                command.addInt(nArray[i]);
            }
            Reply reply = this.checkReply(command);
            reply.resetDataParser();
            return reply;
        }
        catch (IOException iOException) {
            throw new DebugeeException(iOException.getMessage());
        }
    }

    public VMReply sendReplyCommand(int n) throws DebugeeException {
        try {
            Reply reply = this.checkReply(new Command(n));
            reply.resetDataParser();
            return reply;
        }
        catch (IOException iOException) {
            throw new DebugeeException(iOException.getMessage());
        }
    }

    public void sendCommand(int n) throws DebugeeException {
        this.sendCommand(new Command(n));
    }

    public boolean isConnected() {
        return this.is_connected;
    }
}

