/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cldchi.tools.memoryprofiler.jdwp;

import com.sun.cldchi.tools.memoryprofiler.jdwp.BoundException;
import com.sun.cldchi.tools.memoryprofiler.jdwp.Tools;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

class ByteBuffer {
    private int Delta;
    private int CurrentSize;
    int parseOffset;
    protected byte[] bytes;

    public ByteBuffer() {
        this(128, 128);
    }

    public ByteBuffer(int n, int n2) {
        if (n2 <= 0) {
            n2 = 16;
        }
        this.Delta = n2;
        this.CurrentSize = 0;
        this.bytes = new byte[n];
        this.parseOffset = 0;
    }

    public int length() {
        return this.CurrentSize;
    }

    private void checkSpace(int n) {
        int n2;
        if (this.bytes.length >= this.CurrentSize + n) {
            return;
        }
        for (n2 = this.bytes.length; n2 < this.CurrentSize + n; n2 += this.Delta) {
        }
        byte[] byArray = new byte[n2];
        for (int i = 0; i < this.CurrentSize; ++i) {
            byArray[i] = this.bytes[i];
        }
        this.bytes = byArray;
    }

    public void putByte(int n, int n2) throws BoundException {
        if (n < 0 || n >= this.CurrentSize) {
            throw new BoundException();
        }
        this.bytes[n] = (byte)(n2 & 0xFF);
    }

    public void putBytes(int n, byte[] byArray, int n2, int n3) throws BoundException {
        for (int i = 0; i < n3; ++i) {
            this.putByte(n++, byArray[n2++]);
        }
    }

    public void putID(int n, long l, int n2) throws BoundException {
        if (n2 <= 0 || n2 > 8) {
            throw new BoundException();
        }
        int n3 = (n2 - 1) * 8;
        for (int i = 0; i < n2; ++i) {
            this.putByte(n++, (int)(l >>> n3 & 0xFFL));
            n3 -= 8;
        }
    }

    public void putInt(int n, int n2) throws BoundException {
        this.putID(n, n2, 4);
    }

    public void putShort(int n, int n2) throws BoundException {
        this.putID(n, n2, 2);
    }

    public void putLong(int n, long l) throws BoundException {
        this.putID(n, l, 8);
    }

    public void addByte(int n) {
        this.checkSpace(1);
        int n2 = this.CurrentSize++;
        try {
            this.putByte(n2, n);
        }
        catch (BoundException boundException) {
            // empty catch block
        }
    }

    public void addBytes(byte[] byArray, int n, int n2) {
        this.checkSpace(n2);
        int n3 = this.CurrentSize;
        this.CurrentSize += n2;
        try {
            this.putBytes(n3, byArray, n, n2);
        }
        catch (BoundException boundException) {
            // empty catch block
        }
    }

    public void addID(long l, int n) {
        this.checkSpace(n);
        int n2 = this.CurrentSize;
        this.CurrentSize += n;
        try {
            this.putID(n2, l, n);
        }
        catch (BoundException boundException) {
            // empty catch block
        }
    }

    public void addInt(int n) {
        this.addID(n, 4);
    }

    public void addShort(int n) {
        this.addID(n, 2);
    }

    public void addLong(long l) {
        this.addID(l, 8);
    }

    public void addString(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeUTF(string);
        }
        catch (IOException iOException) {
            System.err.println("Error creating the UTF-8 sring");
            return;
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        int n = byArray[0] << 8 & 0xFF00 | byArray[1] & 0xFF;
        this.addByte(0);
        this.addByte(0);
        this.addBytes(byArray, 0, n + 2);
    }

    public void resetParser() {
        this.parseOffset = 0;
    }

    public void resetParser(int n) {
        this.parseOffset = n;
    }

    public boolean isParsed() {
        return this.parseOffset == this.CurrentSize;
    }

    public int getByte() throws BoundException {
        if (this.parseOffset >= this.CurrentSize) {
            throw new BoundException();
        }
        return this.bytes[this.parseOffset++] & 0xFF;
    }

    public long getID(int n) throws BoundException {
        if (n <= 0 || n > 8) {
            throw new BoundException();
        }
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            l = l * 256L + (long)this.getByte();
        }
        return l;
    }

    public int getInt() throws BoundException {
        return (int)this.getID(4);
    }

    public int getShort() throws BoundException {
        return (int)this.getID(2);
    }

    public long getLong() throws BoundException {
        return this.getID(8);
    }

    public String getString() throws BoundException {
        int n = this.getInt();
        if (n < 0) {
            throw new BoundException();
        }
        if (n == 0) {
            return "";
        }
        byte[] byArray = new byte[n + 2];
        byArray[0] = (byte)(n >> 8 & 0xFF);
        byArray[1] = (byte)(n & 0xFF);
        for (int i = 0; i < n; ++i) {
            byArray[i + 2] = (byte)this.getByte();
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            String string = dataInputStream.readUTF();
            return string;
        }
        catch (IOException iOException) {
            throw new BoundException(iOException.getMessage());
        }
    }

    public int getByte(int n) throws BoundException {
        int n2 = this.parseOffset;
        this.parseOffset = n;
        int n3 = this.getByte();
        this.parseOffset = n2;
        return n3;
    }

    public long getID(int n, int n2) throws BoundException {
        int n3 = this.parseOffset;
        this.parseOffset = n;
        long l = this.getID(n2);
        this.parseOffset = n3;
        return l;
    }

    public int getInt(int n) throws BoundException {
        return (int)this.getID(n, 4);
    }

    public int getShort(int n) throws BoundException {
        return (int)this.getID(n, 2);
    }

    public long getLong(int n) throws BoundException {
        return this.getID(n, 8);
    }

    public String getString(int n) throws BoundException {
        int n2 = this.parseOffset;
        this.parseOffset = n;
        String string = this.getString();
        this.parseOffset = n2;
        return string;
    }

    public void deleteBytes(int n) {
        int n2 = 0;
        while (n < this.CurrentSize) {
            this.bytes[n2++] = this.bytes[n++];
        }
        this.CurrentSize = n2;
    }

    public void resetBuffer() {
        this.CurrentSize = 0;
    }

    public String toString(int n) {
        String string = "";
        String string2 = "";
        String string3 = "";
        int n2 = 0;
        for (int i = n; i < this.length(); ++i) {
            string2 = string2 + Tools.Hex(this.bytes[i], 2) + " ";
            string3 = this.bytes[i] >= 0 && this.bytes[i] < 32 ? string3 + "." : string3 + new String(this.bytes, i, 1);
            if (i != this.length() - 1 && (i - n & 0xF) != 15) continue;
            string = string + Tools.Hex(n2, 4) + ": " + Tools.PadR(string2, 48) + "  " + string3 + "\n";
            string2 = "";
            string3 = "";
            n2 += 16;
        }
        return string;
    }

    public String toString() {
        return this.toString(0);
    }
}

