/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cldchi.tools.memoryprofiler.jdwp;

import com.sun.cldchi.tools.memoryprofiler.jdwp.BoundException;
import com.sun.cldchi.tools.memoryprofiler.jdwp.ByteBuffer;
import com.sun.cldchi.tools.memoryprofiler.jdwp.Tools;
import com.sun.cldchi.tools.memoryprofiler.jdwp.jdwp;
import java.util.Vector;

class Packet
extends ByteBuffer {
    public static final int flNoFlags = 0;
    public static final int flReply = 128;
    public static final int LengthOffset = 0;
    public static final int IdOffset = 4;
    public static final int FlagsOffset = 8;
    public static final int CommandOffset = 9;
    public static final int ErrorCodeOffset = 9;
    public static final int PacketHeaderSize = 11;

    public Packet() {
        while (this.length() < 11) {
            this.addByte(0);
        }
    }

    public void setLength() {
        try {
            this.putInt(0, this.length());
        }
        catch (BoundException boundException) {
            // empty catch block
        }
    }

    public int getID() {
        int n = 0;
        try {
            n = this.getInt(4);
        }
        catch (BoundException boundException) {
            // empty catch block
        }
        return n;
    }

    public void setID(int n) {
        try {
            this.putInt(4, n);
        }
        catch (BoundException boundException) {
            // empty catch block
        }
    }

    public int getFlags() {
        return this.bytes[8] & 0xFF;
    }

    public void setFlags(int n) {
        this.bytes[8] = (byte)(n & 0xFF);
    }

    public void resetDataParser() {
        this.resetParser(11);
    }

    public int getDataSize() {
        return this.length() - 11;
    }

    public void addFieldID(long l) {
        this.addID(l, jdwp.fieldIDSize);
    }

    public void addMethodID(long l) {
        this.addID(l, jdwp.methodIDSize);
    }

    public void addObjectID(long l) {
        this.addID(l, jdwp.objectIDSize);
    }

    public void addReferenceTypeID(long l) {
        this.addID(l, jdwp.referenceTypeIDSize);
    }

    public void addFrameID(long l) {
        this.addID(l, jdwp.frameIDSize);
    }

    public long getFieldID() throws BoundException {
        return this.getID(jdwp.fieldIDSize);
    }

    public long getMethodID() throws BoundException {
        return this.getID(jdwp.methodIDSize);
    }

    public long getObjectID() throws BoundException {
        return this.getID(jdwp.objectIDSize);
    }

    public long getReferenceTypeID() throws BoundException {
        return this.getID(jdwp.referenceTypeIDSize);
    }

    public long getFrameID() throws BoundException {
        return this.getID(jdwp.frameIDSize);
    }

    public Vector parse(String string) throws BoundException {
        boolean bl;
        boolean bl2 = bl = string.indexOf(46) == -1;
        if (!bl) {
            if (string.indexOf(46) != string.length() - 1) {
                throw new BoundException();
            }
            string = Tools.Left(string, string.length() - 1);
        }
        Vector vector = new Vector();
        this.resetDataParser();
        this.doParse(string, vector);
        if (bl && !this.isParsed()) {
            throw new BoundException();
        }
        return vector;
    }

    private void doParse(String string, Vector vector) throws BoundException {
        char[] cArray = string.toCharArray();
        block23: for (int i = 0; i < cArray.length; ++i) {
            switch (cArray[i]) {
                case 'b': {
                    vector.add(new Integer(this.getByte()));
                    continue block23;
                }
                case 'i': {
                    vector.add(new Integer(this.getInt()));
                    continue block23;
                }
                case 'S': {
                    vector.add(new Integer(this.getShort()));
                    continue block23;
                }
                case 'l': {
                    vector.add(new Long(this.getLong()));
                    continue block23;
                }
                case 's': {
                    vector.add(this.getString());
                    continue block23;
                }
                case 'f': {
                    vector.add(new Long(this.getFieldID()));
                    continue block23;
                }
                case 'm': {
                    vector.add(new Long(this.getMethodID()));
                    continue block23;
                }
                case 'o': {
                    vector.add(new Long(this.getObjectID()));
                    continue block23;
                }
                case 'r': {
                    vector.add(new Long(this.getReferenceTypeID()));
                    continue block23;
                }
                case 'F': {
                    vector.add(new Long(this.getFrameID()));
                    continue block23;
                }
                case 'v': {
                    int n = this.getByte();
                    vector.add(new Integer(n));
                    switch (n) {
                        case 76: 
                        case 91: {
                            vector.add(new Long(this.getObjectID()));
                            continue block23;
                        }
                        case 66: {
                            vector.add(new Integer(this.getByte()));
                            continue block23;
                        }
                        case 73: {
                            vector.add(new Integer(this.getInt()));
                            continue block23;
                        }
                        case 83: {
                            vector.add(new Integer(this.getShort()));
                            continue block23;
                        }
                        case 86: {
                            vector.add("void value");
                            continue block23;
                        }
                        case 90: {
                            vector.add(new Integer(this.getByte()));
                            continue block23;
                        }
                        case 74: {
                            vector.add(new Long(this.getLong()));
                            continue block23;
                        }
                    }
                    throw new BoundException();
                }
                case '(': {
                    if (i == 0) {
                        throw new BoundException();
                    }
                    if (cArray[i - 1] != 'i') {
                        throw new BoundException();
                    }
                    int n = (Integer)vector.elementAt(vector.size() - 1);
                    if (n < 0) {
                        throw new BoundException();
                    }
                    int n2 = 1;
                    int n3 = -1;
                    for (int j = i + 1; j < cArray.length; ++j) {
                        if (cArray[j] == '(') {
                            ++n2;
                        }
                        if (cArray[j] != ')' || --n2 != 0) continue;
                        n3 = j;
                        break;
                    }
                    if (n3 == -1) {
                        throw new BoundException();
                    }
                    String string2 = new String(cArray, i + 1, n3 - i - 1);
                    for (int j = 0; j < n; ++j) {
                        this.doParse(string2, vector);
                    }
                    i = n3;
                    continue block23;
                }
                default: {
                    throw new BoundException();
                }
            }
        }
    }
}

