/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cldchi.tools.memoryprofiler.jdwp;

import com.sun.cldchi.tools.memoryprofiler.jdwp.Reply;
import com.sun.cldchi.tools.memoryprofiler.jdwp.Tools;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Vector;

class SocketTransportImpl
extends Thread {
    private static Object sync = new Object();
    private static Object sync1 = new Object();
    private static Object sync2 = new Object();
    private String serverName;
    private int portNumber;
    private boolean finished = true;
    private DataInputStream inputStream;
    private DataOutputStream outputStream;
    private Socket socket;
    private Vector replies;
    private Vector repliesInternal = new Vector();
    private int expectedSize = -1;
    private int currentInPrivateBuffer = 0;
    private int handShakeSize;
    private byte[] privateBuffer = new byte[1024];
    private boolean cycleStarted = false;

    public void initAsClient(String string, int n, Vector vector) throws IOException {
        this.serverName = string;
        this.portNumber = n;
        this.replies = vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        Object object = sync;
        // MONITORENTER : object
        this.finished = false;
        // MONITOREXIT : object
        object = new byte[100000];
        try {
            this.attachToServer();
            boolean bl = false;
            Object object2 = sync;
            // MONITORENTER : object2
            bl = this.finished;
            // MONITOREXIT : object2
            object2 = this;
            // MONITORENTER : object2
            this.notifyAll();
            // MONITOREXIT : object2
            while (!bl) {
                int n;
                int n2;
                object2 = sync1;
                // MONITORENTER : object2
                sync1.wait();
                // MONITOREXIT : object2
                object2 = sync2;
                // MONITORENTER : object2
                this.cycleStarted = true;
                // MONITOREXIT : object2
                if (this.expectedSize != -1) {
                    for (int i = 0; i != this.expectedSize; i += this.inputStream.read((byte[])object, i, this.expectedSize - i)) {
                    }
                    Object object3 = sync2;
                    // MONITORENTER : object3
                    for (int i = 0; i < this.expectedSize; ++i) {
                        this.privateBuffer[i] = (byte)object[i];
                    }
                    this.expectedSize = -1;
                    // MONITOREXIT : object3
                    continue;
                }
                for (n = 0; n != 11; n += n2) {
                    n2 = this.inputStream.read((byte[])object, n, 11 - n);
                    if (n2 != -1) continue;
                    throw new IOException("Connection closed");
                }
                int n3 = (object[0] & 0xFF) << 24 | (object[1] & 0xFF) << 16 | (object[2] & 0xFF) << 8 | object[3] & 0xFF;
                n = 0;
                if (n3 > ((Object)object).length) {
                    byte[] byArray = new byte[n3];
                    System.arraycopy(object, 0, byArray, 0, 11);
                    object = byArray;
                }
                while (n != n3 - 11) {
                    int n4 = this.inputStream.read((byte[])object, n + 11, n3 - 11 - n);
                    n += n4;
                    if (n4 != -1) continue;
                    throw new IOException("Connection closed");
                }
                Reply reply = new Reply();
                reply.resetBuffer();
                reply.addBytes((byte[])object, 0, n3);
                Object object4 = this.repliesInternal;
                // MONITORENTER : object4
                this.repliesInternal.add(reply);
                // MONITOREXIT : object4
                object4 = sync;
                // MONITORENTER : object4
                bl = this.finished;
                // MONITOREXIT : object4
            }
        }
        catch (IOException iOException) {
            Object object5 = sync;
            // MONITORENTER : object5
            this.finished = true;
            // MONITOREXIT : object5
            object5 = this;
            // MONITORENTER : object5
            this.notifyAll();
            // MONITOREXIT : object5
        }
        catch (InterruptedException interruptedException) {
            Object object6 = sync;
            // MONITORENTER : object6
            this.finished = true;
            // MONITOREXIT : object6
            object6 = this;
            // MONITORENTER : object6
            this.notifyAll();
            // MONITOREXIT : object6
        }
        Object object7 = sync;
        // MONITORENTER : object7
        this.finished = true;
        // MONITOREXIT : object7
        this.doneInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done() {
        Object object = sync;
        synchronized (object) {
            this.finished = true;
        }
        this.doneInternal();
    }

    private synchronized void doneInternal() {
        try {
            if (this.socket == null) {
                return;
            }
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive() throws IOException {
        Object object = sync;
        synchronized (object) {
            if (this.finished) {
                throw new SocketException("Connection closed");
            }
        }
        object = sync1;
        synchronized (object) {
            sync1.notifyAll();
        }
        object = this.repliesInternal;
        synchronized (object) {
            this.replies.addAll(this.repliesInternal);
            this.repliesInternal.clear();
        }
    }

    public void write(int n) throws IOException {
        this.outputStream.write(n);
    }

    public void attachToServer() throws IOException, UnknownHostException {
        this.socket = new Socket(this.serverName, this.portNumber);
        Tools.wait(100);
        System.out.println("Socket Created.");
        this.socket.setTcpNoDelay(true);
        this.inputStream = new DataInputStream(this.socket.getInputStream());
        this.outputStream = new DataOutputStream(this.socket.getOutputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startHandShake(int n) {
        Object object;
        this.currentInPrivateBuffer = 0;
        this.expectedSize = n;
        this.handShakeSize = n;
        boolean bl = true;
        do {
            object = sync1;
            synchronized (object) {
                sync1.notifyAll();
            }
            object = sync2;
            synchronized (object) {
                bl = !this.cycleStarted;
            }
        } while (bl);
        object = sync2;
        synchronized (object) {
            this.cycleStarted = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readNextFromPrivateBuffer() throws IOException {
        Object object = sync;
        synchronized (object) {
            if (this.finished) {
                throw new SocketException("Connection closed");
            }
        }
        object = sync2;
        synchronized (object) {
            return this.privateBuffer[this.currentInPrivateBuffer++];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int availableInPrivateBuffer() throws IOException {
        Object object = sync;
        synchronized (object) {
            if (this.finished) {
                throw new SocketException("Connection closed");
            }
        }
        object = sync2;
        synchronized (object) {
            if (this.expectedSize == -1) {
                return this.handShakeSize;
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStarted() {
        Object object = sync;
        synchronized (object) {
            return !this.finished;
        }
    }
}

