/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cldchi.tools.memoryprofiler.jdwp;

import com.sun.cldchi.tools.memoryprofiler.jdwp.BoundException;
import com.sun.cldchi.tools.memoryprofiler.jdwp.ByteBuffer;
import com.sun.cldchi.tools.memoryprofiler.jdwp.Command;
import com.sun.cldchi.tools.memoryprofiler.jdwp.Reply;
import com.sun.cldchi.tools.memoryprofiler.jdwp.Tools;
import java.io.IOException;
import java.util.Vector;

abstract class Transport {
    private static ByteBuffer buffer = new ByteBuffer();
    private static final int MaxPacketSize = 131072;
    private static final int delta = 2;
    private static final int handshakeTimeout = 50000;
    public Vector Replies = new Vector();

    Transport() {
    }

    public abstract int available() throws IOException;

    public abstract int read() throws IOException;

    public abstract void write(int var1) throws IOException;

    public void write(byte[] byArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            this.write(byArray[n + i]);
        }
    }

    public void Handshake() throws IOException {
        String string = "JDWP-Handshake";
        byte[] byArray = string.getBytes();
        this.write(byArray, 0, byArray.length);
        int n = 50000;
        do {
            Tools.wait(500);
        } while ((n -= 500) > 0 && this.available() < byArray.length);
        if (this.available() < byArray.length) {
            throw new IOException("Target failed to handshake.");
        }
        for (int i = 0; i < byArray.length; ++i) {
            byte by = (byte)(this.read() & 0xFF);
            if (by == byArray[i]) continue;
            throw new IOException("Target failed to handshake.");
        }
    }

    public void sendCommand(Command command) throws IOException {
        command.setLength();
        this.write(command.bytes, 0, command.length());
    }

    public void sendBadCommandPacket(Command command, int n) throws IOException {
        try {
            command.putInt(0, n);
        }
        catch (BoundException boundException) {
            // empty catch block
        }
        this.write(command.bytes, 0, command.length());
    }

    public void receive() throws IOException {
        while (this.available() > 0) {
            buffer.addByte(this.read());
        }
        while (buffer.length() >= 11) {
            int n = 0;
            buffer.resetParser();
            try {
                n = buffer.getInt();
            }
            catch (BoundException boundException) {
                // empty catch block
            }
            if (n < 0 || n > 131072) {
                throw new IOException("Wrong JDWP packet size: " + n + ".");
            }
            if (n > buffer.length()) {
                return;
            }
            Reply reply = new Reply();
            reply.resetBuffer();
            reply.addBytes(Transport.buffer.bytes, 0, n);
            buffer.deleteBytes(n);
            this.Replies.add(reply);
        }
    }

    public Reply receiveReply() throws IOException {
        this.receive();
        if (this.Replies.size() == 0) {
            return Reply.Error(1025);
        }
        return (Reply)this.Replies.remove(0);
    }

    public Reply receiveReply(int n) throws IOException {
        this.receive();
        for (int i = 0; i < this.Replies.size(); ++i) {
            if (((Reply)this.Replies.elementAt(i)).getFlags() != 128 || ((Reply)this.Replies.elementAt(i)).getID() != n) continue;
            return (Reply)this.Replies.remove(i);
        }
        return Reply.Error(1025);
    }

    public Reply receiveReply(int n, int n2) throws IOException {
        Reply reply = this.receiveReply(n);
        while (reply.getErrorCode() == 1025 && n2 > 0) {
            Tools.wait(2);
            reply = this.receiveReply(n);
            n2 -= 2;
        }
        return reply;
    }

    public Reply receiveEvent(int n, int n2) throws IOException {
        while (n2 > 0) {
            this.receive();
            for (int i = 0; i < this.Replies.size(); ++i) {
                Reply reply = (Reply)this.Replies.elementAt(i);
                if (reply.getFlags() != 0 || reply.getErrorCode() != n) continue;
                return (Reply)this.Replies.remove(i);
            }
            Tools.wait(2);
            n2 -= 2;
        }
        return Reply.Error(1025);
    }
}

