/*
 * Decompiled with CFR 0.152.
 */
package view;

import com.sun.cldchi.tools.memoryprofiler.data.JavaClass;
import com.sun.cldchi.tools.memoryprofiler.data.MPDataProvider;
import com.sun.cldchi.tools.memoryprofiler.data.MPDataProviderFactory;
import com.sun.cldchi.tools.memoryprofiler.jdwp.VMConnectionFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.ConnectException;
import java.net.SocketException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import view.CommandLineException;
import view.StatisticsDialog;
import view.ViewMemoryPanel;
import view.ViewObjectsPanel;

public class Client {
    private MPDataProvider _data_provider;
    private JList _classes_list;
    private JList _object_list;
    private JFrame _frame;
    private ViewMemoryPanel _memory_access_panel;
    private ViewObjectsPanel _view_objects_panel;
    private JButton _vm_controller;
    private JButton _connection_controller;
    private JButton _statistics_btn;
    private JLabel _statusLabel;
    private boolean isConnected = false;
    private static String hostName = "localhost";
    private static int port = 5000;
    private boolean vm_run = false;

    public static void main(String[] stringArray) {
        try {
            if (Client.parseArgs(stringArray) < 0) {
                System.exit(1);
            }
        }
        catch (CommandLineException commandLineException) {
            System.err.println(commandLineException);
            System.exit(1);
        }
        new Client().initUI();
    }

    private void initConnection() throws ConnectException, SocketException {
        this._data_provider.connect(hostName, port);
    }

    private void initUI() {
        this._data_provider = MPDataProviderFactory.getMPDataProvider(VMConnectionFactory.getVMConnectionImpl());
        this._frame = new JFrame("Java Heap Memory Observe Tool");
        this._frame.pack();
        this._frame.setLocation(0, 0);
        this._frame.setSize(1000, 700);
        this._frame.setVisible(true);
        this._frame.setResizable(true);
        this._frame.getContentPane().setLayout(new GridBagLayout());
        this._frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (Client.this.isConnected && !Client.this.vm_run) {
                    try {
                        Client.this._data_provider.resumeVM();
                        try {
                            Thread.sleep(200L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        System.out.println("Exitting, VM execution resumed.");
                    }
                    catch (Exception exception) {
                        System.err.println("Exitting, VM execution could not be resumed.");
                    }
                }
                Client.this._data_provider.closeConnections();
                System.exit(0);
            }
        });
        this._classes_list = new JList();
        this._memory_access_panel = new ViewMemoryPanel(this._data_provider);
        this._memory_access_panel.setSize(1000, 300);
        this._memory_access_panel.update();
        this._frame.getContentPane().add((Component)this._memory_access_panel, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(){

            public Dimension getPreferredSize() {
                return new Dimension(350, 250);
            }
        };
        this._classes_list.setSelectionMode(0);
        this._classes_list.addListSelectionListener(new ClassesListSelectionListener());
        jScrollPane.getViewport().setView(this._classes_list);
        jPanel.add("Center", jScrollPane);
        this._frame.getContentPane().add((Component)jPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        this._view_objects_panel = new ViewObjectsPanel(this._data_provider);
        this._view_objects_panel.initUI(true);
        this._frame.getContentPane().add((Component)this._view_objects_panel, new GridBagConstraints(2, 1, 1, 1, 1.5, 1.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        JPanel jPanel2 = new JPanel();
        this._statistics_btn = new JButton("Statistics");
        this._statistics_btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StatisticsDialog.showDialog(Client.this._frame, Client.this._data_provider.calculateStatistics());
            }
        });
        jPanel2.add(this._statistics_btn);
        this._vm_controller = new JButton("Resume");
        this._vm_controller.addActionListener(new VMActionListener());
        jPanel2.add(this._vm_controller);
        this._connection_controller = new JButton("Connect");
        this._connection_controller.addActionListener(new ConnectionActionListener());
        jPanel2.add(this._connection_controller);
        this._statusLabel = new JLabel("Disconnected");
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Memory Observer tool status");
        this._statusLabel.setBorder(titledBorder);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add("North", jPanel2);
        jPanel3.add("South", this._statusLabel);
        this._frame.getContentPane().add((Component)jPanel3, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 14, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.setDisconnected();
        this._frame.invalidate();
        this._frame.validate();
        this._frame.repaint();
    }

    private void update() {
        try {
            this._classes_list.setListData(this._data_provider.getClassList());
            this._memory_access_panel.update();
        }
        catch (SocketException socketException) {
            this.setDisconnected();
        }
    }

    private void onClassesSelectionChanged() {
        JavaClass javaClass = (JavaClass)this._classes_list.getSelectedValue();
        if (javaClass != null) {
            this._memory_access_panel.set_selected_class_id(javaClass);
            Object[] objectArray = this._data_provider.getObjectsOfClass(javaClass);
            this._view_objects_panel.setObjects(objectArray);
        } else {
            this._view_objects_panel.setObjects(new Object[0]);
        }
        this._frame.invalidate();
        this._frame.validate();
        this._frame.repaint();
    }

    private void onObjectSelectionChanged() {
        this._frame.invalidate();
        this._frame.validate();
        this._frame.repaint();
    }

    private static int parseArgs(String[] stringArray) throws CommandLineException {
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < stringArray.length - 1; ++i) {
            if (stringArray[i].equals("-port")) {
                if (bl) {
                    throw new CommandLineException("Port already defined");
                }
                bl = true;
                try {
                    port = Integer.valueOf(stringArray[++i]);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new CommandLineException("Invalid port number");
                }
            }
            if (stringArray[i].equals("-host")) {
                if (bl2) {
                    throw new CommandLineException("Host already defined");
                }
                bl2 = true;
                hostName = stringArray[++i];
                continue;
            }
            throw new CommandLineException("Unknown switch " + stringArray[i]);
        }
        return 0;
    }

    private static void usage() {
        System.err.println("Usage:\njava view.Client -host <hostname> -port <portname>");
    }

    private void setDisconnected() {
        this.isConnected = false;
        this._classes_list.setListData(new Object[0]);
        this._memory_access_panel.update();
        this._vm_controller.setEnabled(false);
        this._statistics_btn.setEnabled(false);
        this._connection_controller.setEnabled(true);
        this._connection_controller.setText("Connect");
        this._statusLabel.setText("Disconnected");
    }

    private void setConnected() {
        this.isConnected = true;
        this._vm_controller.setEnabled(true);
        this._statistics_btn.setEnabled(true);
        this._connection_controller.setText("Connected!");
        this._statusLabel.setText("Connected");
        this._connection_controller.setEnabled(false);
    }

    class VMActionListener
    implements ActionListener {
        VMActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (!Client.this.vm_run) {
                    Client.this._statusLabel.setText("Resuming VM execution..");
                    Client.this._data_provider.resumeVM();
                    Client.this._statusLabel.setText("VM running");
                } else {
                    Client.this._statusLabel.setText("Pausing VM execution..");
                    Client.this._data_provider.pauseVM();
                    Client.this._statusLabel.setText("VM paused");
                }
                Client.this.vm_run = !Client.this.vm_run;
            }
            catch (SocketException socketException) {
                Client.this.vm_run = false;
                Client.this.setDisconnected();
            }
            if (Client.this.vm_run) {
                Client.this._vm_controller.setText("Pause");
            } else {
                Client.this._vm_controller.setText("Resume");
            }
            if (!Client.this.vm_run) {
                Client.this.update();
            }
        }
    }

    class ConnectionActionListener
    implements ActionListener {
        ConnectionActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!Client.this.isConnected) {
                try {
                    Client.this.initConnection();
                    Client.this.update();
                    Client.this.setConnected();
                }
                catch (ConnectException connectException) {
                    JOptionPane.showMessageDialog(null, "Could not connect to the VM! Check parameters! Host:" + hostName + " port:" + port, "Connection Error", 0);
                    System.out.println("");
                }
                catch (SocketException socketException) {
                    JOptionPane.showMessageDialog(null, "VM connection was broken during initial update!", "Connection Error", 0);
                }
            } else {
                Client.this._data_provider.closeConnections();
                Client.this.setDisconnected();
            }
        }
    }

    class ClassesListSelectionListener
    implements ListSelectionListener {
        ClassesListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            Client.this.onClassesSelectionChanged();
        }
    }
}

