/*
 * Decompiled with CFR 0.152.
 */
package view;

import com.sun.cldchi.tools.memoryprofiler.data.JavaClass;
import com.sun.cldchi.tools.memoryprofiler.data.JavaObject;
import com.sun.cldchi.tools.memoryprofiler.data.MPDataProvider;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import view.ViewRootPathDialog;

public class ViewMemoryPanel
extends JComponent {
    MPDataProvider _data_provider;
    private static final int _hor_bloc_number = 100;
    private static final int _ver_bloc_number = 20;
    private static final int _block_number = 2000;
    private int _block_height = -1;
    private int _block_width = -1;
    private double[] _block_utilization_count = new double[2000];
    private JavaClass selected_class = null;
    private int[] _block_object_count = new int[2000];
    private int _inline_allocation_top = -1;
    private int _old_generation_end = -1;
    private int _heap_start = -1;
    private int _heap_top = -1;

    public ViewMemoryPanel(MPDataProvider mPDataProvider) {
        this._data_provider = mPDataProvider;
        this.setMinimumSize(new Dimension(600, 300));
        this.addMouseListener(new ViewMemoryMouseListener());
    }

    public void set_selected_class_id(JavaClass javaClass) {
        this.selected_class = javaClass;
    }

    public void update() {
        this._inline_allocation_top = this._data_provider.get_allocation_top();
        this._old_generation_end = this._data_provider.get_old_gen_end();
        this._heap_start = this._data_provider.get_heap_start();
        this._heap_top = this._data_provider.get_heap_top();
        this.update_block_utilization();
        this.repaint();
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        int n = graphics.getFontMetrics().stringWidth("_inline_allocation_top block");
        this._block_width = (dimension.width - n - 10) / 102;
        this._block_height = dimension.height / 20;
        this.prepare_blocks();
        for (int i = 0; i < 2000; ++i) {
            this.draw_block(graphics, i);
        }
        this.draw_inline_allocations(graphics);
        this.draw_old_generation_end(graphics);
        this.draw_agenda(graphics);
    }

    public void draw_agenda(Graphics graphics) {
        int n = this._block_width * 100 + 10;
        int n2 = 1;
        this.draw_block_symbol(graphics, n, n2, 100.0, 0);
        this.draw_allocation_top_symbol(graphics, n, n2, false);
        graphics.setColor(Color.BLACK);
        graphics.drawString("_inline_allocation_top block", n + 2 * this._block_width, n2 + this._block_height);
        this.draw_block_symbol(graphics, n, n2 += 2 * this._block_height, 100.0, 0);
        this.draw_old_generation_end_symbol(graphics, n, n2, false);
        graphics.setColor(Color.BLACK);
        graphics.drawString("_old_generation_end block", n + 2 * this._block_width, n2 + this._block_height);
        this.draw_block_symbol(graphics, n, n2 += 2 * this._block_height, 1.0, 0);
        graphics.setColor(Color.BLACK);
        graphics.drawString("block with 100% utilization", n + 2 * this._block_width, n2 + this._block_height);
        this.draw_block_symbol(graphics, n, n2 += 2 * this._block_height, 0.5, 0);
        graphics.setColor(Color.BLACK);
        graphics.drawString("block with 50% utilization", n + 2 * this._block_width, n2 + this._block_height);
        this.draw_block_symbol(graphics, n, n2 += 2 * this._block_height, 0.0, 0);
        graphics.setColor(Color.BLACK);
        graphics.drawString("block with 0% utilization", n + 2 * this._block_width, n2 + this._block_height);
        this.draw_block_symbol(graphics, n, n2 += 2 * this._block_height, 100.0, 1);
        graphics.setColor(Color.BLACK);
        graphics.drawString("block with object ", n + 2 * this._block_width, n2 + this._block_height / 2);
        graphics.drawString("of selected type", n + 2 * this._block_width, n2 + 3 * this._block_height / 2);
        this.draw_block_symbol(graphics, n, n2 += 2 * this._block_height, 100.0, 110);
        graphics.setColor(Color.BLACK);
        graphics.drawString("block with many objects ", n + 2 * this._block_width, n2 + this._block_height / 2);
        graphics.drawString("of selected type", n + 2 * this._block_width, n2 + 3 * this._block_height / 2);
    }

    public Dimension getPreferredSize() {
        return new Dimension(900, 300);
    }

    private void draw_old_generation_end(Graphics graphics) {
        int n = this.get_block_number(this._old_generation_end);
        int n2 = this._block_width * (n % 100);
        int n3 = this._block_height * (n / 100);
        this.draw_old_generation_end_symbol(graphics, n2, n3, false);
    }

    private void draw_inline_allocations(Graphics graphics) {
        int n = this.get_block_number(this._inline_allocation_top);
        int n2 = this._block_width * (n % 100);
        int n3 = this._block_height * (n / 100);
        this.draw_allocation_top_symbol(graphics, n2, n3, false);
    }

    private void draw_block(Graphics graphics, int n) {
        int n2 = this._block_width * (n % 100);
        int n3 = this._block_height * (n / 100);
        this.draw_block_symbol(graphics, n2, n3, this._block_utilization_count[n], this._block_object_count[n]);
    }

    private void prepare_blocks() {
        for (int i = 0; i < 2000; ++i) {
            this._block_object_count[i] = 0;
        }
        JavaObject[] javaObjectArray = this._data_provider.getObjectsOfClass(this.selected_class);
        for (int i = 0; i < javaObjectArray.length; ++i) {
            int n;
            int n2 = javaObjectArray[i].address;
            int n3 = n = this.get_block_number(n2);
            this._block_object_count[n3] = this._block_object_count[n3] + 1;
        }
    }

    private void update_block_utilization() {
        for (int i = 0; i < 2000; ++i) {
            int n = this.get_address_by_block_num(i);
            int n2 = this.get_address_by_block_num(i + 1);
            JavaObject[] javaObjectArray = this._data_provider.getObjectsFromTheAddresses(n, n2);
            int n3 = 0;
            int n4 = 0;
            for (int j = 0; j < javaObjectArray.length; ++j) {
                n3 += javaObjectArray[j].size;
                if (!javaObjectArray[j].alive()) continue;
                n4 += javaObjectArray[j].size;
            }
            this._block_utilization_count[i] = n3 == 0 ? 1.0 : (double)n4 / (double)n3;
        }
    }

    private int get_block_number(int n) {
        if (n < this._heap_start || n > this._heap_top) {
            return -1;
        }
        double d = (double)(n - this._heap_start) / (double)(this._heap_top - this._heap_start);
        int n2 = (int)(d * 2000.0);
        return n2;
    }

    private int get_block_num_by_mouse_event(MouseEvent mouseEvent) {
        return mouseEvent.getY() / this._block_height * 100 + mouseEvent.getX() / this._block_width;
    }

    private int get_address_by_block_num(int n) {
        return (int)((double)this._heap_start + (double)(this._heap_top - this._heap_start) * ((double)n / 2000.0));
    }

    private void draw_allocation_top_symbol(Graphics graphics, int n, int n2, boolean bl) {
        graphics.setColor(new Color(164, 255, 64));
        graphics.drawRect(n, n2, 1, this._block_height);
    }

    private void draw_old_generation_end_symbol(Graphics graphics, int n, int n2, boolean bl) {
        graphics.setColor(new Color(64, 64, 255));
        graphics.drawRect(n, n2, 1, this._block_height);
    }

    private void draw_block_symbol(Graphics graphics, int n, int n2, double d, int n3) {
        int n4 = (int)(255.0 * Math.sqrt(1.0 - d));
        graphics.setColor(new Color(n4, 0, 0));
        graphics.fillRect(n + 1, n2 + 1, this._block_width - 1, this._block_height - 1);
        graphics.setColor(new Color(255, 255, 0));
        int n5 = 0;
        if (n3 > 0) {
            n5 = 1;
        }
        if (n3 > 10) {
            n5 = 2;
        }
        if (n3 > 100) {
            n5 = 3;
            --n;
        }
        graphics.fillOval(n + this._block_width / 2, n2 + this._block_height / 2, n5, n5);
    }

    public boolean contains(int n, int n2) {
        if (!super.contains(n, n2)) {
            return false;
        }
        if (n2 > this._block_height * 20 || n > this._block_width * 100) {
            return false;
        }
        int n3 = n2 / this._block_height * 100 + n / this._block_width;
        int n4 = this.get_address_by_block_num(n3);
        this.setToolTipText("0x" + Integer.toHexString(n4));
        return true;
    }

    class ViewMemoryMouseListener
    extends MouseAdapter {
        ViewMemoryMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() != 1) {
                return;
            }
            int n = ViewMemoryPanel.this.get_address_by_block_num(ViewMemoryPanel.this.get_block_num_by_mouse_event(mouseEvent));
            int n2 = ViewMemoryPanel.this.get_address_by_block_num(ViewMemoryPanel.this.get_block_num_by_mouse_event(mouseEvent) + 1);
            String string = "Objects from " + Integer.toHexString(n) + " to " + Integer.toHexString(n2);
            ViewRootPathDialog.showDialog(ViewMemoryPanel.this, ViewMemoryPanel.this._data_provider.getObjectsFromTheAddresses(n, n2), string, ViewMemoryPanel.this._data_provider);
        }
    }
}

