/*
 * Decompiled with CFR 0.152.
 */
package view;

import com.sun.cldchi.tools.memoryprofiler.data.JavaObject;
import com.sun.cldchi.tools.memoryprofiler.data.MPDataProvider;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.net.SocketException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import view.ViewRootPathDialog;

public class ViewObjectsPanel
extends JPanel {
    private JLabel address_label = new JLabel("address");
    private JTextField address_field = new JTextField();
    private JLabel type_label = new JLabel("type");
    private JTextField type_field = new JTextField();
    private JTable references = new ObjectListTable(new ObjectListTableModel());
    private JTable referees = new ObjectListTable(new ObjectListTableModel());
    private JavaObject _obj = null;
    private MPDataProvider _provider;
    private JButton _root_path;
    private JList _object_list;
    private JButton _stack_location;
    private Object[] _objects;

    public ViewObjectsPanel(MPDataProvider mPDataProvider) {
        this._provider = mPDataProvider;
    }

    public void initUI(boolean bl) {
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.address_label);
        jPanel.add(this.address_field);
        this.address_field.setEditable(false);
        this.type_field.setEditable(false);
        this.address_field.setPreferredSize(new Dimension(80, 20));
        this.type_field.setPreferredSize(new Dimension(120, 20));
        jPanel.add(this.type_label);
        jPanel.add(this.type_field);
        if (bl) {
            this._root_path = new JButton("Show path from the root");
            this._root_path.addActionListener(new ShowRootPathListener());
            this._root_path.setFont(this._root_path.getFont().deriveFont(9.0f));
            this._root_path.setEnabled(false);
            jPanel.add(this._root_path);
        } else {
            this._stack_location = new JButton("Show stack trace");
            this._stack_location.addActionListener(new ShowStackTraceListener());
            this._stack_location.setFont(this._stack_location.getFont().deriveFont(9.0f));
            this._stack_location.setEnabled(false);
            jPanel.add(this._stack_location);
        }
        this.add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        JPanel jPanel2 = new JPanel();
        JScrollPane jScrollPane = new JScrollPane();
        this._object_list = new JList();
        this._object_list.setSelectionMode(0);
        this._object_list.addListSelectionListener(new ObjectListSelectionListener());
        jScrollPane.getViewport().setView(this._object_list);
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 2, 1.0, 1.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        jPanel2.add((Component)new JLabel("Referees"), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        jPanel2.add((Component)new JLabel("References"), new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        jScrollPane = new JScrollPane();
        jScrollPane.getViewport().setView(this.referees);
        jPanel2.add((Component)jScrollPane, new GridBagConstraints(1, 1, 1, 1, 2.5, 21.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        jScrollPane = new JScrollPane();
        jScrollPane.getViewport().setView(this.references);
        jPanel2.add((Component)jScrollPane, new GridBagConstraints(2, 1, 1, 1, 2.5, 21.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)jPanel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 20.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
    }

    private void setObject(JavaObject javaObject) {
        this._obj = javaObject;
        ObjectListTableModel objectListTableModel = (ObjectListTableModel)this.references.getModel();
        ObjectListTableModel objectListTableModel2 = (ObjectListTableModel)this.referees.getModel();
        if (javaObject != null) {
            this.address_field.setText(javaObject.toString());
            this.type_field.setText(this._provider.getObjectTypeName(javaObject));
            objectListTableModel.setData(javaObject.get_references());
            objectListTableModel2.setData(javaObject.get_referees());
            if (this._root_path != null) {
                this._root_path.setEnabled(javaObject.getRootDistance() != -1);
            }
            if (this._stack_location != null) {
                this._stack_location.setEnabled(javaObject.object_type == 2);
            }
        } else {
            this.address_field.setText("");
            this.type_field.setText("");
            objectListTableModel.setData(null);
            objectListTableModel2.setData(null);
            if (this._root_path != null) {
                this._root_path.setEnabled(false);
            }
        }
        objectListTableModel.fireTableDataChanged();
        objectListTableModel2.fireTableDataChanged();
    }

    public void setObjects(Object[] objectArray) {
        this._object_list.setListData(objectArray);
        this._objects = objectArray;
        this.repaint();
    }

    class ShowStackTraceListener
    implements ActionListener {
        ShowStackTraceListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            for (int i = 0; i < ViewObjectsPanel.this._objects.length - 1; ++i) {
                if (ViewObjectsPanel.this._objects[i] != ViewObjectsPanel.this._obj) continue;
                int n = ((JavaObject)((ViewObjectsPanel)ViewObjectsPanel.this)._objects[i + 1]).address;
                String string = null;
                try {
                    string = ViewObjectsPanel.this._provider.getStackTrace((JavaObject)ViewObjectsPanel.this._objects[i], n);
                }
                catch (SocketException socketException) {
                    // empty catch block
                }
                JOptionPane.showMessageDialog(null, string, "Object location StackTrace", -1);
            }
        }
    }

    class ObjectListSelectionListener
    implements ListSelectionListener {
        ObjectListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            JavaObject javaObject = (JavaObject)ViewObjectsPanel.this._object_list.getSelectedValue();
            ViewObjectsPanel.this.setObject(javaObject);
        }
    }

    class ShowRootPathListener
    implements ActionListener {
        ShowRootPathListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object[] objectArray = ViewObjectsPanel.this._provider.pathFromTheRoot(ViewObjectsPanel.this._obj);
            ViewRootPathDialog.showDialog(ViewObjectsPanel.this, objectArray, "Path from the Root", ViewObjectsPanel.this._provider);
        }
    }

    class ObjectListTable
    extends JTable {
        public ObjectListTable(TableModel tableModel) {
            super(tableModel);
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            int n = this.rowAtPoint(mouseEvent.getPoint());
            int n2 = this.columnAtPoint(mouseEvent.getPoint());
            return (String)this.getModel().getValueAt(n, n2);
        }
    }

    class ObjectListTableModel
    extends AbstractTableModel {
        private Object[] _data;

        ObjectListTableModel() {
        }

        public void setData(Object[] objectArray) {
            this._data = objectArray;
        }

        public int getColumnCount() {
            return 2;
        }

        public Object getValueAt(int n, int n2) {
            if (this._data == null) {
                return "y";
            }
            if (n >= this._data.length) {
                return "z";
            }
            if (n2 == 0) {
                return this._data[n].toString();
            }
            if (n2 == 1) {
                return ViewObjectsPanel.this._provider.getObjectTypeName((JavaObject)this._data[n]);
            }
            throw new RuntimeException();
        }

        public int getRowCount() {
            if (this._data == null) {
                return 0;
            }
            return this._data.length;
        }

        public String getColumnName(int n) {
            if (n == 0) {
                return "address";
            }
            if (n == 1) {
                return "type";
            }
            throw new RuntimeException("Should not reach here!");
        }
    }
}

