/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp;

import com.sun.jme.emulator.events.EventDataProviderManager;
import com.sun.jme.emulator.events.GenericEventManager;
import com.sun.jme.emulator.events.spi.EventManagerSpi;
import com.sun.kvem.midp.EventBridgeMBean;
import java.awt.event.MouseEvent;
import java.io.UnsupportedEncodingException;
import org.apache.log4j.Logger;

public class EventBridge
extends GenericEventManager
implements EventManagerSpi,
EventBridgeMBean {
    private static final Logger LOGGER = Logger.getLogger(EventBridge.class);
    private EventDataProviderManager eventDataProviderManager;
    private static EventBridge instance;
    static final int SUSPEND_ALL = 1;
    static final int RESUME_ALL = 2;
    static final int SHUTDOWN = 3;
    static final int SUSPEND_CURRENT = 4;
    static final int RESUME_PREVIOUS = 5;
    static final int KILL_CURRENT = 6;
    static final int CHANGE_LOCALE = 7;
    static final int SWITCH_STATE = 8;
    static final int ROTATE = 9;
    static final int MAX_KEY_CODE = 0;
    static final int CLDC_EVENT_INVALID = -2;
    static final int CLDC_EVENT_STOP = -1;
    static final int CLDC_EVENT_KEYDOWN = 0;
    static final int CLDC_EVENT_KEYUP = 1;
    static final int CLDC_EVENT_KEYREPEAT = 2;
    static final int CLDC_EVENT_PENDOWN = 3;
    static final int CLDC_EVENT_PENUP = 4;
    static final int CLDC_EVENT_PENMOVE = 5;
    static final int CLDC_EVENT_TIMER = 6;
    static final int CLDC_EVENT_COMMAND = 7;
    static final int CLDC_EVENT_REPAINT = 8;
    static final int CLDC_EVENT_KEYTYPED = 9;
    static final int CLDC_EVENT_MMEOM = 10;
    static final int CLDC_EVENT_SYSTEM = 11;

    public EventBridge() {
        instance = this;
    }

    public void setEventDataProviderManager(EventDataProviderManager eventDataProviderManager) {
        this.eventDataProviderManager = eventDataProviderManager;
    }

    public static void initialize() {
    }

    public static int[] getEvents(boolean bl, long l) {
        return instance.takeEvent(bl, l);
    }

    public static boolean isNetworkMonitorActive() {
        boolean bl = Boolean.getBoolean("netmon.enabled");
        LOGGER.debug((Object)("NetworkMonitorActive netmon.enabled:" + bl));
        return bl;
    }

    public static String getExternalEventData(String string) {
        return EventBridge.instance.eventDataProviderManager.getEventData(string);
    }

    public void injectKeyPressedEvent(boolean bl, int n, int n2, int n3, int n4) {
        this.injectKeyEvent(0, n, n2);
    }

    public void injectKeyRepeatedEvent(boolean bl, int n, int n2, int n3, int n4) {
        this.injectKeyEvent(2, n, n2);
    }

    public void injectKeyReleasedEvent(boolean bl, int n, int n2, int n3, int n4) {
        this.injectKeyEvent(1, n, n2);
    }

    private void injectKeyEvent(int n, int n2, int n3) {
        int n4;
        int n5 = n4 = n2 > 0 ? n3 : n2;
        if (n4 == 65535) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("injectKeyEvent type:" + n + " keyCode:" + n4));
        }
        instance.queueEvent(new int[]{n, n4, 0, 0});
    }

    public void penDown(int n, int n2, MouseEvent mouseEvent) {
        LOGGER.debug((Object)("Mouse click at (" + n + "," + n2 + ")"));
        this.injectMouseEvent(n, n2, 3);
    }

    public void penUp(int n, int n2, MouseEvent mouseEvent) {
        LOGGER.debug((Object)("Mouse release at (" + n + "," + n2 + ")"));
        this.injectMouseEvent(n, n2, 4);
    }

    public void penMove(int n, int n2, MouseEvent mouseEvent) {
        LOGGER.debug((Object)("Mouse move at (" + n + "," + n2 + ")"));
        this.injectMouseEvent(n, n2, 5);
    }

    public void localeChanged(String string, String string2) {
        LOGGER.debug((Object)("Locale changed to " + string + (string2 != null ? "_" + string2 : "")));
        if (string.length() != 2 || string2 != null && string2.length() != 2) {
            throw new IllegalArgumentException("Wrong code length");
        }
        this.injectSystemEvent(7, this.encodeCharacters(string), this.encodeCharacters(string2 != null ? string2 : ""));
    }

    private int encodeCharacters(String string) {
        byte[] byArray;
        try {
            byArray = string.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string.getBytes();
        }
        int n = 0;
        for (byte by : byArray) {
            n = n << 8 | 0xFF & by;
        }
        return n;
    }

    private void injectMouseEvent(int n, int n2, int n3) {
        this.queueEvent(new int[]{n3, 0, n, n2});
    }

    public void injectShutdownEvent() {
        LOGGER.debug((Object)"Injecting SHUTDOWN event");
        this.injectSystemEvent(3);
    }

    public void injectSwitchStateEvent(int n) {
        LOGGER.debug((Object)("Injecting switch state event event (11, 8, " + n + ", 0)"));
        this.injectSystemEvent(8, n, 0);
    }

    public void injectRotateEvent(int n) {
        LOGGER.debug((Object)("Injecting rotate event (11, 9, " + n + ", 0)"));
        this.injectSystemEvent(9, n, 0);
    }

    public void injectSystemEvent(int n) {
        this.injectSystemEvent(n, 0, 0);
    }

    public void injectSystemEvent(int n, int n2, int n3) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("injectSystemEvent " + n + "," + n2 + "," + n3));
        }
        instance.queueEvent(new int[]{11, n, n2, n3});
    }

    public void injectResumeEvent() {
        this.injectSystemEvent(2);
    }

    public void injectJcovEvent() {
    }
}

