/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.devicedetection.rmi;

import com.sun.jme.toolkit.devicedetection.api.CompositeDeviceTypeDetector;
import com.sun.jme.toolkit.devicedetection.api.DetectionProcessListener;
import com.sun.jme.toolkit.devicedetection.api.DetectionProcessNotifier;
import com.sun.jme.toolkit.devicedetection.api.DeviceAddress;
import com.sun.jme.toolkit.devicedetection.api.DeviceAddressListener;
import com.sun.jme.toolkit.devicedetection.api.DeviceAddressManager;
import com.sun.jme.toolkit.devicedetection.api.DeviceTypeDetector;
import com.sun.jme.toolkit.devicedetection.api.VerbosityLevel;
import com.sun.jme.toolkit.devicedetection.rmi.AutoDevTypeDetectorImplMBean;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.log4j.Logger;

public final class AutoDevTypeDetectorImpl
implements AutoDevTypeDetectorImplMBean,
CompositeDeviceTypeDetector,
DetectionProcessListener,
DetectionProcessNotifier,
DeviceAddressListener,
Runnable {
    private static final Logger LOGGER = Logger.getLogger(AutoDevTypeDetectorImpl.class);
    private static final String REPORT_SRC = "AUT";
    private final List<DeviceTypeDetector> deviceTypeDetectors = new LinkedList<DeviceTypeDetector>();
    private final Set<PropertyChangeListener> propertyChangeListeners = new CopyOnWriteArraySet<PropertyChangeListener>();
    private final Set<DetectionProcessListener> detectionProcessListeners = new CopyOnWriteArraySet<DetectionProcessListener>();
    private final Object deviceDetectionLock = new Object();
    private final Object propertyChangeLock = new Object();
    private DeviceAddressManager deviceAddressManager;
    private Thread deviceDetectionThread;
    private boolean stopDetectionThread;
    private boolean runDeviceDetection = true;
    private long deviceDetectionPeriod;

    public void setDeviceAddressManager(DeviceAddressManager deviceAddressManager) {
        this.deviceAddressManager = deviceAddressManager;
    }

    public void setInitialDetectionPeriod(long l) {
        this.deviceDetectionPeriod = l;
    }

    public void start() {
        this.deviceDetectionThread = new Thread((Runnable)this, "Device type detector");
        this.deviceDetectionThread.start();
        this.deviceAddressManager.addDeviceAddressListener((DeviceAddressListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.deviceAddressManager.removeDeviceAddressListener((DeviceAddressListener)this);
        Object object = this.deviceDetectionLock;
        synchronized (object) {
            this.stopDetectionThread = true;
            this.deviceDetectionLock.notifyAll();
        }
        try {
            this.deviceDetectionThread.join();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detectNow() {
        Object object = this.deviceDetectionLock;
        synchronized (object) {
            this.runDeviceDetection = true;
            this.deviceDetectionLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDetectionPeriod(long l) {
        Object object = this.propertyChangeLock;
        synchronized (object) {
            long l2;
            Object object2 = this.deviceDetectionLock;
            synchronized (object2) {
                l2 = this.deviceDetectionPeriod;
                this.deviceDetectionPeriod = l;
            }
            if (l2 != l) {
                object2 = new PropertyChangeEvent(this, "detectionPeriod", l2, l);
                for (PropertyChangeListener propertyChangeListener : this.propertyChangeListeners) {
                    propertyChangeListener.propertyChange((PropertyChangeEvent)object2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDetectionPeriod() {
        Object object = this.deviceDetectionLock;
        synchronized (object) {
            return this.deviceDetectionPeriod;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeListeners.add(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeListeners.remove(propertyChangeListener);
    }

    public void addDeviceTypeDetector(DeviceTypeDetector deviceTypeDetector) {
        this.deviceTypeDetectors.add(deviceTypeDetector);
    }

    public void removeDeviceTypeDetector(DeviceTypeDetector deviceTypeDetector) {
        this.deviceTypeDetectors.remove(deviceTypeDetector);
    }

    public boolean accept(DeviceAddress deviceAddress, boolean bl, DetectionProcessListener detectionProcessListener) {
        boolean bl2 = false;
        for (DeviceTypeDetector deviceTypeDetector : this.deviceTypeDetectors) {
            if (!deviceTypeDetector.accept(deviceAddress, bl, detectionProcessListener)) continue;
            bl2 = true;
        }
        return bl2;
    }

    public void remove(DeviceAddress deviceAddress) {
        for (DeviceTypeDetector deviceTypeDetector : this.deviceTypeDetectors) {
            deviceTypeDetector.remove(deviceAddress);
        }
    }

    public void deviceAddressAdded(DeviceAddress deviceAddress, int n) {
        this.detectNow();
    }

    public void deviceAddressRemoved(DeviceAddress deviceAddress, int n) {
        if (n == 0) {
            this.remove(deviceAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            while (true) {
                DeviceAddress[] deviceAddressArray = this.deviceDetectionLock;
                // MONITORENTER : this.deviceDetectionLock
                if (!this.stopDetectionThread && !this.runDeviceDetection) {
                    this.deviceDetectionLock.wait(this.deviceDetectionPeriod);
                }
                if (this.stopDetectionThread) {
                    // MONITOREXIT : deviceAddressArray
                    return;
                }
                boolean bl = this.runDeviceDetection;
                this.runDeviceDetection = false;
                // MONITOREXIT : deviceAddressArray
                this.notifyDetectionStarted();
                for (DeviceAddress deviceAddress : deviceAddressArray = this.deviceAddressManager.getDeviceAddresses()) {
                    if (this.accept(deviceAddress, bl, this)) continue;
                    this.reportFailure(deviceAddress, VerbosityLevel.LOW, REPORT_SRC, "No compatible runtime detected on the device address");
                }
                this.notifyDetectionFinished();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized void notifyDetectionStarted() {
        for (DetectionProcessListener detectionProcessListener : this.detectionProcessListeners) {
            detectionProcessListener.notifyDetectionStarted();
        }
    }

    public synchronized void notifyDetectionFinished() {
        for (DetectionProcessListener detectionProcessListener : this.detectionProcessListeners) {
            detectionProcessListener.notifyDetectionFinished();
        }
    }

    public synchronized void reportSuccess(DeviceAddress deviceAddress, VerbosityLevel verbosityLevel, String string, String string2) {
        LOGGER.trace((Object)("(+) " + string + " [" + deviceAddress + "]: " + string2));
        for (DetectionProcessListener detectionProcessListener : this.detectionProcessListeners) {
            detectionProcessListener.reportSuccess(deviceAddress, verbosityLevel, string, string2);
        }
    }

    public synchronized void reportFailure(DeviceAddress deviceAddress, VerbosityLevel verbosityLevel, String string, String string2) {
        LOGGER.trace((Object)("(-) " + string + " [" + deviceAddress + "]: " + string2));
        for (DetectionProcessListener detectionProcessListener : this.detectionProcessListeners) {
            detectionProcessListener.reportFailure(deviceAddress, verbosityLevel, string, string2);
        }
    }

    public synchronized void reportProgress(DeviceAddress deviceAddress, VerbosityLevel verbosityLevel, String string, String string2) {
        LOGGER.trace((Object)("(=) " + string + " [" + deviceAddress + "]: " + string2));
        for (DetectionProcessListener detectionProcessListener : this.detectionProcessListeners) {
            detectionProcessListener.reportProgress(deviceAddress, verbosityLevel, string, string2);
        }
    }

    public void addDetectionProcessListener(DetectionProcessListener detectionProcessListener) {
        this.detectionProcessListeners.add(detectionProcessListener);
    }

    public void removeDetectionProcessListener(DetectionProcessListener detectionProcessListener) {
        this.detectionProcessListeners.remove(detectionProcessListener);
    }
}

