/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.devicedetection.rmi;

import com.sun.jme.toolkit.devicedetection.api.DeviceAddress;
import com.sun.jme.toolkit.devicedetection.api.DeviceAddressListener;
import com.sun.jme.toolkit.devicedetection.rmi.DeviceAddressManagerImplMBean;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.log4j.Logger;

public class DeviceAddressManagerImpl
implements DeviceAddressManagerImplMBean {
    private static final Logger LOGGER = Logger.getLogger(DeviceAddressManagerImpl.class);
    final Map<DeviceAddress, Integer> deviceAddresses = new HashMap<DeviceAddress, Integer>();
    final Set<DeviceAddressListener> listeners = new CopyOnWriteArraySet<DeviceAddressListener>();
    private File storageFile;

    public void setStorageFile(File file) {
        this.storageFile = file;
    }

    public void start() {
        try {
            if (this.storageFile.exists()) {
                DeviceAddress[] deviceAddressArray;
                for (DeviceAddress deviceAddress : deviceAddressArray = DeviceAddressManagerImpl.load(this.storageFile)) {
                    this.deviceAddresses.put(deviceAddress, 1);
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOGGER.error((Object)"Failed to load device addresses!", (Throwable)fileNotFoundException);
        }
    }

    public void stop() {
        try {
            File file = this.storageFile.getParentFile();
            if (!file.exists()) {
                file.mkdirs();
            }
            DeviceAddressManagerImpl.save(this.storageFile, this.getDeviceAddresses());
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOGGER.error((Object)"Failed to store device addresses!", (Throwable)fileNotFoundException);
        }
    }

    public synchronized int addDeviceAddress(DeviceAddress deviceAddress) {
        Integer n = this.deviceAddresses.get(deviceAddress);
        if (n != null) {
            int n2 = n + 1;
            this.deviceAddresses.put(deviceAddress, n2);
            this.notifyDeviceAddressAdded(deviceAddress, n2);
            return n2;
        }
        this.deviceAddresses.put(deviceAddress, 1);
        this.notifyDeviceAddressAdded(deviceAddress, 1);
        return 1;
    }

    public synchronized int removeDeviceAddress(DeviceAddress deviceAddress) {
        Integer n = this.deviceAddresses.get(deviceAddress);
        if (n == null) {
            return 0;
        }
        if (n < 2) {
            this.deviceAddresses.remove(deviceAddress);
            this.notifyDeviceAddressRemoved(deviceAddress, 0);
            return 0;
        }
        int n2 = n - 1;
        this.deviceAddresses.put(deviceAddress, n2);
        this.notifyDeviceAddressRemoved(deviceAddress, n2);
        return n2;
    }

    public synchronized <T extends DeviceAddress> T[] getDeviceAddresses(Class<T> clazz) {
        ArrayList<T> arrayList = new ArrayList<T>(this.deviceAddresses.size());
        for (DeviceAddress deviceAddress : this.deviceAddresses.keySet()) {
            if (!clazz.isInstance(deviceAddress)) continue;
            arrayList.add(clazz.cast(deviceAddress));
        }
        DeviceAddress[] deviceAddressArray = (DeviceAddress[])Array.newInstance(clazz, arrayList.size());
        return arrayList.toArray(deviceAddressArray);
    }

    public DeviceAddress[] getDeviceAddresses() {
        return this.getDeviceAddresses(DeviceAddress.class);
    }

    public synchronized int getRefCount(DeviceAddress deviceAddress) {
        Integer n = this.deviceAddresses.get(deviceAddress);
        return n != null ? n : 0;
    }

    public void addDeviceAddressListener(DeviceAddressListener deviceAddressListener) {
        this.listeners.add(deviceAddressListener);
    }

    public void removeDeviceAddressListener(DeviceAddressListener deviceAddressListener) {
        this.listeners.remove(deviceAddressListener);
    }

    private void notifyDeviceAddressAdded(DeviceAddress deviceAddress, int n) {
        for (DeviceAddressListener deviceAddressListener : this.listeners) {
            deviceAddressListener.deviceAddressAdded(deviceAddress, n);
        }
    }

    private void notifyDeviceAddressRemoved(DeviceAddress deviceAddress, int n) {
        for (DeviceAddressListener deviceAddressListener : this.listeners) {
            deviceAddressListener.deviceAddressRemoved(deviceAddress, n);
        }
    }

    private static DeviceAddress[] load(File file) throws FileNotFoundException {
        DeviceAddress[] deviceAddressArray;
        XMLDecoder xMLDecoder = new XMLDecoder(new BufferedInputStream(new FileInputStream(file)), null, null, DeviceAddress.class.getClassLoader());
        try {
            deviceAddressArray = (DeviceAddress[])xMLDecoder.readObject();
        }
        catch (RuntimeException runtimeException) {
            LOGGER.error((Object)("File " + file + " is corrupted!"), (Throwable)runtimeException);
            deviceAddressArray = new DeviceAddress[]{};
        }
        xMLDecoder.close();
        return deviceAddressArray;
    }

    private static void save(File file, DeviceAddress[] deviceAddressArray) throws FileNotFoundException {
        XMLEncoder xMLEncoder = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(file)));
        try {
            xMLEncoder.writeObject(deviceAddressArray);
        }
        catch (RuntimeException runtimeException) {
            LOGGER.error((Object)("Failed to update " + file + "!"), (Throwable)runtimeException);
        }
        xMLEncoder.close();
    }
}

