/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.services.profiler;

import com.sun.jme.remoting.CommException;
import com.sun.jme.remoting.DataRecv;
import com.sun.jme.remoting.DataSend;
import com.sun.jme.remoting.InOutSerializableArgument;
import com.sun.jme.services.profiler.ProfilerRecord;
import com.sun.jme.services.profiler.ProfilerRecordSource;

public class ProfilerRecordBuffer
implements InOutSerializableArgument {
    private static final int DEFAULT_BUFF_SIZE = 1024;
    private ProfilerRecordSource source;
    ProfilerRecord[] records;
    private int buffSize;
    private int count;

    public ProfilerRecordBuffer() {
        this.buffSize = 1024;
        this.source = null;
        this.clear();
    }

    public ProfilerRecordBuffer(int n) {
        this.buffSize = n;
        this.source = null;
        this.clear();
    }

    public void clear() {
        this.count = 0;
    }

    public void assignSource(ProfilerRecordSource profilerRecordSource) {
        this.source = profilerRecordSource;
    }

    public void sendObjectIn(DataSend dataSend) throws CommException {
        dataSend.sendInt(this.buffSize);
    }

    public void recvObjectIn(DataRecv dataRecv) throws CommException {
        this.buffSize = dataRecv.recvInt();
    }

    public void sendObjectOut(DataSend dataSend) throws CommException {
        ProfilerRecord profilerRecord;
        if (this.source == null) {
            return;
        }
        int n = 0;
        while ((profilerRecord = this.source.getNextRecord()) != null) {
            dataSend.sendInt(1);
            profilerRecord.sendObject(dataSend);
            if (++n != this.buffSize) continue;
            return;
        }
        dataSend.sendInt(0);
    }

    public void recvObjectOut(DataRecv dataRecv) throws CommException {
        if (this.records == null) {
            this.records = new ProfilerRecord[this.buffSize];
        }
        while (this.count < this.buffSize && dataRecv.recvInt() == 1) {
            ProfilerRecord profilerRecord = new ProfilerRecord();
            profilerRecord.recvObject(dataRecv);
            this.records[this.count] = profilerRecord;
            ++this.count;
        }
    }

    public int getRecordCount() {
        return this.count;
    }

    public ProfilerRecord getRecord(int n) {
        if (n < this.count) {
            return this.records[n];
        }
        return null;
    }
}

