/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.devaddr;

import com.sun.jme.toolkit.devaddr.ArgsIterator;
import com.sun.jme.toolkit.devaddr.command.AddAddrCommand;
import com.sun.jme.toolkit.devaddr.command.AddrManagerCommand;
import com.sun.jme.toolkit.devaddr.command.DelAddrCommand;
import com.sun.jme.toolkit.devaddr.command.ListAddrCommand;
import com.sun.jme.toolkit.devicedetection.api.DeviceAddress;
import com.sun.jme.toolkit.devicedetection.api.DeviceIpAddress;
import com.sun.jme.toolkit.ueiproxy.DeviceManagerConnector;
import com.sun.jme.toolkit.ueiproxy.UeiProxyException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;

public final class Main {
    private List<String> args;
    private AtomicInteger returnCode;
    private CountDownLatch shutdownLatch;
    private DeviceManagerConnector deviceManagerConnector;
    private String usage;

    public void setArgs(List<String> list) {
        this.args = list;
    }

    public void setReturnCode(AtomicInteger atomicInteger) {
        this.returnCode = atomicInteger;
    }

    public void setShutdownLatch(CountDownLatch countDownLatch) {
        this.shutdownLatch = countDownLatch;
    }

    public void setDeviceManagerConnector(DeviceManagerConnector deviceManagerConnector) {
        this.deviceManagerConnector = deviceManagerConnector;
    }

    public void setUsage(String string) {
        this.usage = string;
    }

    public void start() {
        String[] stringArray = new String[this.args.size()];
        this.args.toArray(stringArray);
        ArgsIterator argsIterator = new ArgsIterator(stringArray);
        try {
            int n = this.processArguments(argsIterator);
            this.returnCode.set(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException.getMessage());
            this.returnCode.set(1);
        }
        this.shutdownLatch.countDown();
    }

    private void printUsage() {
        System.out.println(this.usage);
    }

    private int processArguments(ArgsIterator argsIterator) throws IllegalArgumentException {
        int n;
        AddrManagerCommand addrManagerCommand;
        Object object;
        String string = argsIterator.getNext();
        if (string == null) {
            this.printUsage();
            return 0;
        }
        if ("add".equals(string)) {
            object = this.parseDeviceAddress(argsIterator);
            addrManagerCommand = new AddAddrCommand(this.deviceManagerConnector, (DeviceAddress)object);
        } else if ("del".equals(string)) {
            object = this.parseDeviceAddress(argsIterator);
            addrManagerCommand = new DelAddrCommand(this.deviceManagerConnector, (DeviceAddress)object);
        } else if ("list".equals(string)) {
            object = this.parseDeviceAddressType(argsIterator);
            addrManagerCommand = new ListAddrCommand(this.deviceManagerConnector, (Class<? extends DeviceAddress>)object);
        } else {
            throw new IllegalArgumentException("Command \"" + string + "\"" + " is not supported!");
        }
        object = argsIterator.getNext();
        if (object != null) {
            throw new IllegalArgumentException("Too many arguments for \"" + string + "\" command!");
        }
        try {
            n = addrManagerCommand.execute();
        }
        catch (UeiProxyException ueiProxyException) {
            System.err.println(ueiProxyException.getFormattedMessage());
            return 1;
        }
        return n;
    }

    private DeviceAddress parseDeviceAddress(ArgsIterator argsIterator) throws IllegalArgumentException {
        String string = argsIterator.getNext();
        if (string == null) {
            throw new IllegalArgumentException("Device address type not specified!");
        }
        if (!"ip".equals(string)) {
            throw new IllegalArgumentException("Address type \"" + string + "\" is not supported!");
        }
        DeviceAddress deviceAddress = this.parseDeviceIpAddress(argsIterator);
        return deviceAddress;
    }

    private DeviceAddress parseDeviceIpAddress(ArgsIterator argsIterator) throws IllegalArgumentException {
        String string = argsIterator.getNext();
        if (string == null) {
            throw new IllegalArgumentException("Device IP address not specified!");
        }
        try {
            InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            throw new IllegalArgumentException("The specified device IP address is invalid!");
        }
        return new DeviceIpAddress(string);
    }

    private Class<? extends DeviceAddress> parseDeviceAddressType(ArgsIterator argsIterator) throws IllegalArgumentException {
        String string = argsIterator.getNext();
        if (string == null) {
            return DeviceAddress.class;
        }
        if ("ip".equals(string)) {
            return DeviceIpAddress.class;
        }
        throw new IllegalArgumentException("Address type \"" + string + "\" is not supported!");
    }
}

