/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.devaddr.command;

import com.sun.jme.toolkit.devaddr.command.AddrManagerCommand;
import com.sun.jme.toolkit.devicedetection.api.DeviceAddress;
import com.sun.jme.toolkit.devicedetection.api.DeviceAddressManager;
import com.sun.jme.toolkit.ueiproxy.DeviceManagerConnector;
import com.sun.jme.toolkit.ueiproxy.UeiProxyException;

public final class AddAddrCommand
extends AddrManagerCommand {
    private final DeviceAddress deviceAddress;

    public AddAddrCommand(DeviceManagerConnector deviceManagerConnector, DeviceAddress deviceAddress) {
        super(deviceManagerConnector);
        this.deviceAddress = deviceAddress;
    }

    @Override
    public int execute() throws UeiProxyException {
        DeviceAddressManager deviceAddressManager = this.getDeviceAddressManager();
        try {
            int n = deviceAddressManager.addDeviceAddress(this.deviceAddress);
            System.out.println("Device address " + this.deviceAddress + " added.");
            if (n > 1) {
                System.out.println("(increased address reference count to " + n + ")");
            }
        }
        catch (RuntimeException runtimeException) {
            throw new UeiProxyException("Failed to add address " + this.deviceAddress + "!", (Throwable)runtimeException);
        }
        return 0;
    }
}

