/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.devaddr.command;

import com.sun.jme.toolkit.devaddr.command.AddrManagerCommand;
import com.sun.jme.toolkit.devicedetection.api.DeviceAddress;
import com.sun.jme.toolkit.devicedetection.api.DeviceAddressManager;
import com.sun.jme.toolkit.ueiproxy.DeviceManagerConnector;
import com.sun.jme.toolkit.ueiproxy.UeiProxyException;

public final class DelAddrCommand
extends AddrManagerCommand {
    private final DeviceAddress deviceAddress;

    public DelAddrCommand(DeviceManagerConnector deviceManagerConnector, DeviceAddress deviceAddress) {
        super(deviceManagerConnector);
        this.deviceAddress = deviceAddress;
    }

    @Override
    public int execute() throws UeiProxyException {
        DeviceAddressManager deviceAddressManager = this.getDeviceAddressManager();
        try {
            int n = deviceAddressManager.removeDeviceAddress(this.deviceAddress);
            System.out.println("Device address " + this.deviceAddress + " removed.");
            if (n > 0) {
                System.out.println("(decreased address reference count to " + n + ")");
            }
        }
        catch (RuntimeException runtimeException) {
            throw new UeiProxyException("Failed to remove address " + this.deviceAddress + "!", (Throwable)runtimeException);
        }
        return 0;
    }
}

