/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.devaddr.command;

import com.sun.jme.toolkit.devaddr.command.AddrManagerCommand;
import com.sun.jme.toolkit.devicedetection.api.DeviceAddress;
import com.sun.jme.toolkit.devicedetection.api.DeviceAddressManager;
import com.sun.jme.toolkit.ueiproxy.DeviceManagerConnector;
import com.sun.jme.toolkit.ueiproxy.UeiProxyException;
import java.util.Arrays;
import java.util.Comparator;

public final class ListAddrCommand
extends AddrManagerCommand {
    private final Class<? extends DeviceAddress> deviceAddressType;

    public ListAddrCommand(DeviceManagerConnector deviceManagerConnector, Class<? extends DeviceAddress> clazz) {
        super(deviceManagerConnector);
        this.deviceAddressType = clazz;
    }

    @Override
    public int execute() throws UeiProxyException {
        DeviceAddressManager deviceAddressManager = this.getDeviceAddressManager();
        try {
            DeviceAddress[] deviceAddressArray = deviceAddressManager.getDeviceAddresses(this.deviceAddressType);
            Arrays.sort(deviceAddressArray, new DeviceAddressComparator());
            for (DeviceAddress deviceAddress : deviceAddressArray) {
                try {
                    int n = deviceAddressManager.getRefCount(deviceAddress);
                    if (n == 1) {
                        System.out.println(deviceAddress);
                        continue;
                    }
                    if (n <= 1) continue;
                    System.out.println(deviceAddress + " (reference count " + n + ")");
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }
        catch (RuntimeException runtimeException) {
            throw new UeiProxyException("Failed to list device addresses!", (Throwable)runtimeException);
        }
        return 0;
    }

    private static final class DeviceAddressComparator
    implements Comparator<DeviceAddress> {
        private DeviceAddressComparator() {
        }

        @Override
        public final int compare(DeviceAddress deviceAddress, DeviceAddress deviceAddress2) {
            return deviceAddress.toString().compareTo(deviceAddress2.toString());
        }
    }
}

