/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem;

import java.awt.Color;

public class GammaCorrector {
    private final float inverseGamma;
    private final float gammaFactor;

    public GammaCorrector(float f) {
        this.inverseGamma = 1.0f / f;
        this.gammaFactor = (float)Math.pow(255.0, 1.0 - (double)this.inverseGamma);
    }

    private int correct(int n) {
        float f = n;
        return Math.round((float)Math.pow(f, this.inverseGamma) * this.gammaFactor);
    }

    public Color correct(int n, int n2, int n3) {
        return new Color(this.correct(n), this.correct(n2), this.correct(n3));
    }

    public Color correct(Color color) {
        return this.correct(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static void main(String[] stringArray) {
        Color[] colorArray = new Color[]{new Color(0, 0, 0), new Color(64, 0, 0), new Color(64, 64, 64), new Color(128, 0, 0), new Color(128, 128, 128), new Color(160, 0, 0), new Color(255, 0, 0), new Color(255, 255, 255)};
        float[] fArray = new float[]{0.5f, 1.0f, 1.5f, 2.5f};
        for (int i = 0; i < fArray.length; ++i) {
            float f = fArray[i];
            GammaCorrector gammaCorrector = new GammaCorrector(f);
            System.out.println("Gamma level = " + f + "\n");
            for (int j = 0; j < colorArray.length; ++j) {
                Color color = colorArray[j];
                Color color2 = gammaCorrector.correct(color);
                System.out.println(color + " -> " + color2);
            }
            System.out.println();
        }
    }
}

