/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.emulator.events;

import com.sun.jme.emulator.events.GenericEventManagerListener;
import com.sun.jme.emulator.events.GenericEventManagerMBean;
import com.sun.jme.emulator.events.spi.DeviceEventManagerSpi;
import com.sun.kvem.Lime;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class GenericEventManager
implements DeviceEventManagerSpi,
GenericEventManagerMBean {
    protected Lime lime;
    private Queue queue = new Queue();
    private List<GenericEventManagerListener> listenerList = new ArrayList<GenericEventManagerListener>();
    protected static final Logger LOGGER = Logger.getLogger(GenericEventManager.class);

    public void addListener(GenericEventManagerListener genericEventManagerListener) {
        this.listenerList.add(genericEventManagerListener);
    }

    public void removeListener(GenericEventManagerListener genericEventManagerListener) {
        this.listenerList.remove(genericEventManagerListener);
    }

    public void setLime(Lime lime) {
        this.lime = lime;
    }

    @Override
    public void queueEvent(Object object) {
        for (int i = 0; i < this.listenerList.size(); ++i) {
            GenericEventManagerListener genericEventManagerListener = this.listenerList.get(i);
            genericEventManagerListener.queueEvent(object);
        }
        this.queue.queue(object);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("Queuing event " + object));
        }
        this.lime.incrementEventCount();
    }

    @Override
    public Object dequeueEvent(long l) {
        Object object = this.queue.dequeue(l, true);
        if (object != null && LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("Dequeued event " + object));
        }
        return object;
    }

    public void deleteEvent(Object object) {
        this.queue.delete(object);
    }

    protected int[] takeEvent(boolean bl, long l) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("Get Event: forever = " + String.valueOf(bl) + ", waitFor = " + String.valueOf(l)));
        }
        long l2 = System.currentTimeMillis();
        long l3 = l2 + l;
        if (bl) {
            l3 = 0L;
        } else if (l < 0L) {
            l3 = l2;
        }
        int[] nArray = (int[])this.dequeueEvent(l3);
        if (LOGGER.isTraceEnabled()) {
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                LOGGER.trace((Object)n);
            }
        }
        return nArray;
    }

    private static class Queue {
        int start = 0;
        int end = 0;
        int count = 0;
        Object[] buffer = new Object[4];

        private Queue() {
        }

        synchronized void queue(Object object) {
            if (this.count == this.buffer.length) {
                Object[] objectArray = new Object[this.buffer.length * 2];
                System.arraycopy(this.buffer, this.start, objectArray, 0, this.buffer.length - this.start);
                System.arraycopy(this.buffer, 0, objectArray, this.buffer.length - this.start, this.start);
                this.start = 0;
                this.end = this.buffer.length;
                this.buffer = objectArray;
            }
            this.buffer[this.end++] = object;
            this.end %= this.buffer.length;
            ++this.count;
            this.notifyAll();
        }

        synchronized Object dequeue(long l, boolean bl) {
            long l2 = System.currentTimeMillis();
            if (l <= 0L) {
                l = Long.MAX_VALUE;
            }
            while (this.count == 0 && l2 < l) {
                try {
                    this.wait(l - l2);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                l2 = System.currentTimeMillis();
            }
            if (this.count == 0) {
                return null;
            }
            Object object = this.buffer[this.start];
            if (bl) {
                this.buffer[this.start] = null;
                ++this.start;
                this.start %= this.buffer.length;
                --this.count;
            }
            return object;
        }

        synchronized void delete(Object object) {
            int n = this.start;
            while (n != this.end) {
                if (this.buffer[n].equals(object)) {
                    this.end = (this.end + this.buffer.length - 1) % this.buffer.length;
                    while (n != this.end) {
                        this.buffer[n] = this.buffer[(n + 1) % this.buffer.length];
                        n = (n + 1) % this.buffer.length;
                    }
                    this.buffer[n] = null;
                    --this.count;
                    return;
                }
                n = (n + 1) % this.buffer.length;
            }
        }
    }
}

