/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.util;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class WindowUtils {
    static int lastX;
    static int lastY;
    static final int stepX = 45;
    static final int stepY = 40;
    static int minX;
    static int minY;
    static int maxX;
    static int maxY;

    public static void place(Window window) {
        int n = lastX + 45;
        int n2 = lastY + 40;
        int n3 = window.getWidth();
        int n4 = window.getHeight();
        if (n + n3 > maxX) {
            n = minX;
        }
        if (n2 + n4 > maxY) {
            n2 = minY;
        }
        if (minX + n3 > maxX) {
            n = 5;
        }
        if (minY + n4 > maxY) {
            n2 = 5;
        }
        window.setLocation(n, n2);
        lastX = n;
        lastY = n2;
    }

    public static void placeNextTo(Window window, Window window2) {
        int n = window.getWidth();
        int n2 = window2.getWidth();
        int n3 = window2.getX() - n - 5;
        int n4 = window2.getY();
        if (n3 < 0) {
            n3 = window2.getX() + 5 + n2;
        }
        window.setLocation(n3, n4);
    }

    public static void center(Window window, Window window2) {
        window.setLocationRelativeTo(window2);
    }

    public static void setFrameIcon(JFrame jFrame, String string) {
        ImageIcon imageIcon = new ImageIcon(string);
        jFrame.setIconImage(imageIcon.getImage());
    }

    public static Window getAncestorWindow(Container container) {
        for (Container container2 = container.getParent(); container2 != null; container2 = container2.getParent()) {
            if (!(container2 instanceof Window)) continue;
            return (Window)container2;
        }
        return null;
    }

    public static Point align(Dimension dimension, String string) {
        Point point = new Point();
        int n = 20;
        int n2 = 20;
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        if (string.equals("bottom_left")) {
            n2 = dimension2.height - dimension.height - 20;
        } else if (string.equals("top_right")) {
            n = dimension2.width - dimension.width - 20;
        } else if (string.equals("bottom_right")) {
            n = dimension2.width - dimension.width - 20;
            n2 = dimension2.height - dimension.height - 20;
        } else if (string.equals("center")) {
            n = (dimension2.width - dimension.width) / 2;
            n2 = (dimension2.height - dimension.height) / 2;
        } else if (string.equals("random")) {
            n = 20 + (int)Math.round(Math.random() * (double)(dimension2.width - dimension.width - 40));
            n2 = 20 + (int)Math.round(Math.random() * (double)(dimension2.height - dimension.height - 40));
        }
        point.x = n;
        point.y = n2;
        return point;
    }

    public static int getDefaultLabelFontHeight() {
        UIDefaults uIDefaults = UIManager.getDefaults();
        Font font = (Font)uIDefaults.get("Label.font");
        return font.getSize();
    }

    static {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = dimension.width;
        int n2 = dimension.height;
        minX = 50;
        minY = 50;
        if (minX > n) {
            minX = n / 2;
        }
        if (minY > n2) {
            minY = n2 / 2;
        }
        maxX = n - 50;
        maxY = n2 - 50;
        if (maxX > n * 4 / 5) {
            maxX = n * 4 / 5;
        }
        if (maxY > n2 * 4 / 5) {
            maxY = n2 * 4 / 5;
        }
        lastX = minX + (int)(Math.random() * (double)(maxX - minX) * 0.8);
        lastY = minY + (int)(Math.random() * (double)(maxY - minY) * 0.8);
    }
}

