/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.fileconnection;

import com.sun.kvem.midp.DirectoryHelper;
import com.sun.kvem.util.ActionReflector;
import com.sun.kvem.util.ToolkitResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class DirectoryOperation
extends JDialog
implements DirectoryHelper.ProgressListener {
    private final int MAX_PATH_LEN = 60;
    private final DirectoryHelper dirHelper = new DirectoryHelper();
    private JLabel label;
    private JProgressBar progress;
    private long count;
    private Result result;
    private State state;
    private String failure;
    private String hiddenPathPrefix;

    public DirectoryOperation(JFrame jFrame) {
        super((Frame)jFrame, true);
        this.dirHelper.registerProgressListener((DirectoryHelper.ProgressListener)this);
        JPanel jPanel = new JPanel(new BorderLayout(6, 6));
        jPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.label = new JLabel();
        jPanel.add((Component)this.label, "North");
        this.progress = new JProgressBar();
        this.progress.setPreferredSize(new Dimension(400, 30));
        jPanel.add((Component)this.progress, "Center");
        this.state = State.IDLE;
        String string = ToolkitResources.getString((String)"CANCEL");
        JButton jButton = new JButton(string);
        jButton.setToolTipText(ToolkitResources.getString((String)"CANCEL_HELP"));
        jButton.setMnemonic(ToolkitResources.getString((String)"CANCEL_SHORTCUT").charAt(0));
        jButton.setActionCommand("cancel");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1, 0, 0));
        jPanel2.add(jButton);
        jPanel.add((Component)jPanel2, "South");
        ActionReflector actionReflector = new ActionReflector((Object)this);
        jButton.addActionListener((ActionListener)actionReflector);
        this.getContentPane().add(jPanel);
        this.pack();
        this.setResizable(false);
        Rectangle rectangle = jFrame.getBounds();
        Point point = new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
        Dimension dimension = this.getSize();
        this.setLocation(point.x - dimension.width / 2, point.y - dimension.height / 2);
        this.addWindowListener(new WindowListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowOpened(WindowEvent windowEvent) {
                1 var2_2 = this;
                synchronized (var2_2) {
                    if (DirectoryOperation.this.state == State.IDLE) {
                        DirectoryOperation.this.setVisible(false);
                    }
                }
            }

            @Override
            public void windowActivated(WindowEvent windowEvent) {
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
            }

            @Override
            public void windowDeiconified(WindowEvent windowEvent) {
            }

            @Override
            public void windowIconified(WindowEvent windowEvent) {
            }
        });
    }

    public synchronized void cancel() {
        if (this.state == State.IDLE) {
            this.setVisible(false);
        } else {
            this.state = State.INTERRUPTED;
        }
    }

    public void hidePathPrefix(String string) {
        this.hiddenPathPrefix = string;
    }

    private String cutPath(String string) {
        int n = 0;
        if (this.hiddenPathPrefix != null && this.hiddenPathPrefix.length() > 0 && string.startsWith(this.hiddenPathPrefix) && string.charAt(n = this.hiddenPathPrefix.length()) == File.separatorChar) {
            ++n;
        }
        if (string.length() - n > 60) {
            n = string.indexOf(File.separator, string.length() - 60);
            if (n > 0) {
                return "..." + string.substring(n);
            }
            return "..." + string.substring(string.length() - 60);
        }
        return string.substring(n);
    }

    public synchronized void updateProgress(DirectoryHelper.ProgressData progressData) {
        if (this.state == State.INTERRUPTED) {
            this.dirHelper.interrupt();
            return;
        }
        if (this.count == 0L) {
            return;
        }
        this.label.setText(this.cutPath(progressData.getCurrentFile()));
        int n = 0;
        switch (this.state) {
            case COPYING: {
                n = (int)(progressData.getBytes() * 100L / this.count);
                break;
            }
            case DELETING: {
                n = (int)((long)(progressData.getFilesCount() * 100) / this.count);
            }
        }
        if (this.progress.getValue() != n) {
            this.progress.setValue(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result copyDir(final String string, final String string2) {
        this.result = Result.CANCEL;
        this.setTitle(ToolkitResources.getString((String)"FILE_CONN.COPYING_DIRECTORY"));
        this.label.setText(ToolkitResources.getString((String)"FILE_CONN.GETTING_SIZE"));
        this.progress.setValue(0);
        this.count = 0L;
        DirectoryOperation directoryOperation = this;
        synchronized (directoryOperation) {
            this.state = State.COPYING;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                DirectoryOperation.this.count = DirectoryOperation.this.dirHelper.getDirSize(string);
                if (DirectoryOperation.this.count == -1L) {
                    DirectoryOperation.this.result = Result.CANCEL;
                    DirectoryOperation.this.finish();
                    return;
                }
                try {
                    if (DirectoryOperation.this.dirHelper.copyDir(string, string2)) {
                        DirectoryOperation.this.result = Result.SUCCESS;
                        DirectoryOperation.this.label.setText(ToolkitResources.getString((String)"FILE_CONN.DONE"));
                        DirectoryOperation.this.progress.setValue(100);
                    } else {
                        DirectoryOperation.this.result = Result.ABORT;
                    }
                }
                catch (Exception exception) {
                    DirectoryOperation.this.result = Result.FAILURE;
                    DirectoryOperation.this.failure = exception.getMessage();
                    DirectoryOperation.this.finish();
                    return;
                }
                DirectoryOperation.this.finish();
            }
        }).start();
        this.setVisible(true);
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result deleteDir(final String string) {
        this.result = Result.CANCEL;
        this.setTitle(ToolkitResources.getString((String)"FILE_CONN.DELETING_DIRECTORY"));
        this.label.setText(ToolkitResources.getString((String)"FILE_CONN.GETTING_SIZE"));
        this.progress.setValue(0);
        this.count = 0L;
        DirectoryOperation directoryOperation = this;
        synchronized (directoryOperation) {
            this.state = State.DELETING;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                DirectoryOperation.this.count = DirectoryOperation.this.dirHelper.getFilesCount(string);
                if (DirectoryOperation.this.count == -1L) {
                    DirectoryOperation.this.result = Result.CANCEL;
                    DirectoryOperation.this.finish();
                    return;
                }
                try {
                    if (DirectoryOperation.this.dirHelper.deleteDir(string)) {
                        DirectoryOperation.this.result = Result.SUCCESS;
                        DirectoryOperation.this.label.setText(ToolkitResources.getString((String)"FILE_CONN.DONE"));
                        DirectoryOperation.this.progress.setValue(100);
                    } else {
                        DirectoryOperation.this.result = Result.ABORT;
                    }
                }
                catch (Exception exception) {
                    DirectoryOperation.this.result = Result.FAILURE;
                    DirectoryOperation.this.failure = exception.getMessage();
                    DirectoryOperation.this.finish();
                    return;
                }
                DirectoryOperation.this.finish();
            }
        }).start();
        this.setVisible(true);
        return this.result;
    }

    private synchronized void finish() {
        this.state = State.IDLE;
        this.setVisible(false);
    }

    public static enum Result {
        SUCCESS,
        FAILURE,
        CANCEL,
        ABORT;

    }

    private static enum State {
        IDLE,
        COPYING,
        DELETING,
        INTERRUPTED;

    }
}

