/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.fileconnection;

import com.sun.kvem.ExternalEventManager;
import com.sun.kvem.environment.EventGenUI;
import com.sun.kvem.fileconnection.DirectoryOperation;
import com.sun.kvem.fileconnection.RootMountName;
import com.sun.kvem.util.ToolkitResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FileConnEventGenPanel
extends JPanel
implements EventGenUI {
    private DefaultListModel roots = new DefaultListModel();
    private JList rootsList;
    private DefaultListModel unmountedRoots = new DefaultListModel();
    private JList unmountedList;
    private JButton unmountBtn;
    private JButton remountBtn;
    private JButton deleteBtn;
    private JButton unmountDeleteBtn;
    private JFrame parent;
    private String newRootName;
    private String nameToRemove;
    private File lastChosenDir;
    private com.sun.kvem.midp.FileConnEventGenPanel bridge;

    public void setBridge(com.sun.kvem.midp.FileConnEventGenPanel fileConnEventGenPanel) {
        this.bridge = fileConnEventGenPanel;
    }

    public void setExternalEventManager(ExternalEventManager externalEventManager) {
        externalEventManager.register((EventGenUI)this);
    }

    public void start() {
        this.retrieveRoots();
        this.retrieveUnmountedRoots();
        this.createUI();
        this.enableButtons();
        this.enableUnmountedButtons();
    }

    private void retrieveRoots() {
        FileConnEventGenPanel fileConnEventGenPanel = this;
        List list = fileConnEventGenPanel.bridge.getMountedRootsList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.roots.addElement(iterator.next());
        }
    }

    private void retrieveUnmountedRoots() {
        FileConnEventGenPanel fileConnEventGenPanel = this;
        List list = fileConnEventGenPanel.bridge.getUnmountedRootsList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.unmountedRoots.addElement(iterator.next());
        }
    }

    private JPanel getRootsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createTitledBorder(ToolkitResources.getString((String)"FILE_CONN.ROOTS")));
        this.rootsList = new JList(this.roots);
        this.rootsList.addListSelectionListener(new RootSelectionListener());
        JScrollPane jScrollPane = new JScrollPane(this.rootsList);
        jPanel.add(jScrollPane);
        return jPanel;
    }

    private JPanel getUnmountedPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createTitledBorder(ToolkitResources.getString((String)"FILE_CONN.UNMOUNTED_ROOTS")));
        this.unmountedList = new JList(this.unmountedRoots);
        this.unmountedList.addListSelectionListener(new UnmountedSelectionListener());
        JScrollPane jScrollPane = new JScrollPane(this.unmountedList);
        jPanel.add(jScrollPane);
        return jPanel;
    }

    private JPanel getMountedButtonsPanel() {
        JPanel jPanel = new JPanel(new GridLayout(1, 4));
        jPanel.setBorder(BorderFactory.createEmptyBorder(6, 0, 0, 0));
        JButton jButton = FileConnEventGenPanel.createButton(ToolkitResources.getString((String)"FILE_CONN.MOUNT"), ToolkitResources.getString((String)"FILE_CONN.MOUNT_SHORTCUT"), ToolkitResources.getString((String)"FILE_CONN.MOUNT_TOOLTIP"));
        jButton.addActionListener(new MountListener());
        jButton.setActionCommand("6000");
        jPanel.add(jButton);
        JButton jButton2 = FileConnEventGenPanel.createButton(ToolkitResources.getString((String)"FILE_CONN.MOUNT_COPY"), ToolkitResources.getString((String)"FILE_CONN.MOUNT_COPY_SHORTCUT"), ToolkitResources.getString((String)"FILE_CONN.MOUNT_COPY_TOOLTIP"));
        jButton2.addActionListener(new MountCopyListener());
        jButton2.setActionCommand("6000");
        jPanel.add(jButton2);
        this.unmountBtn = FileConnEventGenPanel.createButton(ToolkitResources.getString((String)"FILE_CONN.UNMOUNT"), ToolkitResources.getString((String)"FILE_CONN.UNMOUNT_SHORTCUT"), ToolkitResources.getString((String)"FILE_CONN.UNMOUNT_TOOLTIP"));
        this.unmountBtn.addActionListener(new UnmountListener());
        this.unmountBtn.setActionCommand("6001");
        jPanel.add(this.unmountBtn);
        this.unmountDeleteBtn = FileConnEventGenPanel.createButton(ToolkitResources.getString((String)"FILE_CONN.UNMOUNT_DELETE"), ToolkitResources.getString((String)"FILE_CONN.UNMOUNT_DELETE_SHORTCUT"), ToolkitResources.getString((String)"FILE_CONN.UNMOUNT_DELETE_TOOLTIP"));
        this.unmountDeleteBtn.addActionListener(new UnmountDeleteListener());
        this.unmountDeleteBtn.setActionCommand("6001");
        jPanel.add(this.unmountDeleteBtn);
        return jPanel;
    }

    private JPanel getUnmountedButtonsPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2, 0, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(6, 0, 0, 0));
        this.remountBtn = FileConnEventGenPanel.createButton(ToolkitResources.getString((String)"FILE_CONN.REMOUNT"), ToolkitResources.getString((String)"FILE_CONN.REMOUNT_SHORTCUT"), ToolkitResources.getString((String)"FILE_CONN.REMOUNT_TOOLTIP"));
        this.remountBtn.addActionListener(new RemountListener());
        this.remountBtn.setActionCommand("6000");
        jPanel.add(this.remountBtn);
        jPanel.add(Box.createHorizontalStrut(4));
        this.deleteBtn = FileConnEventGenPanel.createButton(ToolkitResources.getString((String)"FILE_CONN.DELETE"), ToolkitResources.getString((String)"FILE_CONN.DELETE_SHORTCUT"), ToolkitResources.getString((String)"FILE_CONN.DELETE_TOOLTIP"));
        this.deleteBtn.addActionListener(new DeleteListener());
        jPanel.add(this.deleteBtn);
        return jPanel;
    }

    private void createUI() {
        this.setLayout(new BorderLayout(0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.add((Component)this.getRootsPanel(), "Center");
        JPanel jPanel = new JPanel(new BorderLayout(0, 4));
        jPanel.add((Component)this.getMountedButtonsPanel(), "North");
        jPanel.add((Component)this.getUnmountedPanel(), "Center");
        jPanel.add((Component)this.getUnmountedButtonsPanel(), "South");
        this.add((Component)jPanel, "South");
    }

    public void setParent(JFrame jFrame) {
        this.parent = jFrame;
    }

    public JPanel getGUI() {
        return this;
    }

    public String getTitle() {
        return ToolkitResources.getString((String)"FILE_CONN");
    }

    public String getEventData(String string) {
        if (string.equals("6000")) {
            return this.newRootName;
        }
        if (string.equals("6001")) {
            return this.nameToRemove;
        }
        return null;
    }

    private void mountFS() {
        this.newRootName = new RootMountName(this.parent, this, new File(this.bridge.getRootDir()), new File(this.bridge.getUnmountedRootDir())).getNewRootName();
        if (!this.newRootName.endsWith("/")) {
            this.newRootName = this.newRootName + "/";
        }
        if (this.newRootName != null && !"".equals(this.newRootName)) {
            this.roots.addElement(this.newRootName);
            this.bridge.mountFS(this.newRootName);
        }
        this.rootsList.setSelectedIndex(this.roots.indexOf(this.newRootName));
    }

    private void mountCopyFS() {
        String string;
        JFileChooser jFileChooser = new JFileChooser(this.lastChosenDir != null ? this.lastChosenDir.getParentFile() : null);
        jFileChooser.setDialogType(0);
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setDialogTitle(ToolkitResources.getString((String)"FILE_CONN.DIRECTORY_OPEN"));
        if (jFileChooser.showOpenDialog(this) != 0) {
            return;
        }
        this.lastChosenDir = jFileChooser.getSelectedFile();
        this.newRootName = string = this.lastChosenDir.getName();
        int n = 0;
        while (this.isMountedRoot(this.newRootName + "/") || this.isUnmountedRoot(this.newRootName + "/")) {
            this.newRootName = string + n++;
        }
        this.newRootName = new RootMountName(this.parent, this, new File(this.bridge.getRootDir()), new File(this.bridge.getUnmountedRootDir())).getNewRootName(this.newRootName);
        if (this.newRootName == null || this.newRootName.equals("")) {
            return;
        }
        if (!this.newRootName.endsWith("/")) {
            this.newRootName = this.newRootName + "/";
        }
        File file = new File(this.bridge.getRootDir(), this.newRootName);
        DirectoryOperation directoryOperation = new DirectoryOperation(this.parent);
        directoryOperation.hidePathPrefix(new File(this.lastChosenDir.getParentFile().getAbsolutePath()).getAbsolutePath());
        DirectoryOperation.Result result = directoryOperation.copyDir(this.lastChosenDir.getAbsolutePath(), file.getAbsolutePath());
        if (result == DirectoryOperation.Result.ABORT) {
            JOptionPane.showMessageDialog(this, ToolkitResources.getString((String)"FILE_CONN.COPYING_ABORTED"));
        }
        if (result == DirectoryOperation.Result.FAILURE) {
            JOptionPane.showMessageDialog(this, ToolkitResources.getString((String)"FILE_CONN.COPYING_FAILED"));
        }
        if (file.exists()) {
            this.bridge.mountFS(this.newRootName);
            this.roots.addElement(this.newRootName);
        }
        this.rootsList.setSelectedIndex(this.roots.indexOf(this.newRootName));
    }

    private void unmountFS() {
        int n = this.rootsList.getSelectedIndex();
        this.nameToRemove = (String)this.roots.elementAt(n);
        this.roots.removeElement(this.nameToRemove);
        this.unmountedRoots.addElement(this.nameToRemove);
        this.bridge.unmountFS(this.nameToRemove);
        this.unmountedList.setSelectedIndex(this.unmountedRoots.indexOf(this.nameToRemove));
    }

    private void remountFS() {
        int n = this.unmountedList.getSelectedIndex();
        String string = (String)this.unmountedRoots.elementAt(n);
        this.unmountedRoots.removeElement(string);
        this.roots.addElement(string);
        this.bridge.mountFS(string);
        this.rootsList.setSelectedIndex(this.roots.indexOf(string));
    }

    private void deleteFS() {
        String string;
        int n = this.unmountedList.getSelectedIndex();
        String string2 = (String)this.unmountedRoots.elementAt(n);
        String string3 = string = string2.endsWith("/") ? string2.substring(0, string2.length() - 1) : string2;
        if (JOptionPane.showConfirmDialog(this, ToolkitResources.getString((String)"FILE_CONN.CONFIRM_DELETE") + " " + string, ToolkitResources.getString((String)"FILE_CONN.DELETE_ROOT"), 2) != 0) {
            return;
        }
        DirectoryOperation directoryOperation = new DirectoryOperation(this.parent);
        directoryOperation.hidePathPrefix(new File(this.bridge.getUnmountedRootDir()).getAbsolutePath());
        DirectoryOperation.Result result = directoryOperation.deleteDir(new File(this.bridge.getUnmountedRootDir(), string2).getAbsolutePath());
        if (result == DirectoryOperation.Result.FAILURE) {
            JOptionPane.showMessageDialog(this, ToolkitResources.getString((String)"FILE_CONN.CANNOT_DELETE") + " " + string2);
            return;
        }
        if (result == DirectoryOperation.Result.SUCCESS) {
            this.bridge.deleteUnmountedFS(string2);
            this.unmountedRoots.removeElement(string2);
        }
    }

    private void unmountDeleteFS() {
        String string;
        int n = this.rootsList.getSelectedIndex();
        this.nameToRemove = (String)this.roots.elementAt(n);
        String string2 = string = this.nameToRemove.endsWith("/") ? this.nameToRemove.substring(0, this.nameToRemove.length() - 1) : this.nameToRemove;
        if (JOptionPane.showConfirmDialog(this, ToolkitResources.getString((String)"FILE_CONN.CONFIRM_DELETE") + " " + string, ToolkitResources.getString((String)"FILE_CONN.DELETE_ROOT"), 2) != 0) {
            return;
        }
        this.bridge.unmountFS(this.nameToRemove);
        this.roots.removeElement(this.nameToRemove);
        this.unmountedRoots.addElement(this.nameToRemove);
        DirectoryOperation directoryOperation = new DirectoryOperation(this.parent);
        directoryOperation.hidePathPrefix(new File(this.bridge.getUnmountedRootDir()).getAbsolutePath());
        DirectoryOperation.Result result = directoryOperation.deleteDir(new File(this.bridge.getUnmountedRootDir(), this.nameToRemove).getAbsolutePath());
        if (result == DirectoryOperation.Result.FAILURE) {
            JOptionPane.showMessageDialog(this, ToolkitResources.getString((String)"FILE_CONN.CANNOT_DELETE") + " " + this.nameToRemove);
            return;
        }
        if (result == DirectoryOperation.Result.SUCCESS) {
            this.bridge.deleteUnmountedFS(this.nameToRemove);
            this.unmountedRoots.removeElement(this.nameToRemove);
        }
    }

    private void enableButtons() {
        int n = this.rootsList.getSelectedIndex();
        String string = n > -1 ? (String)this.roots.elementAt(n) : null;
        FileConnEventGenPanel fileConnEventGenPanel = this;
        String string2 = fileConnEventGenPanel.bridge.getInherentRoot() + "/";
        this.unmountBtn.setEnabled(n > -1 && !string2.equals(string));
        this.unmountDeleteBtn.setEnabled(n > -1 && !string2.equals(string));
    }

    private void enableUnmountedButtons() {
        int n = this.unmountedList.getSelectedIndex();
        this.remountBtn.setEnabled(n > -1);
        this.deleteBtn.setEnabled(n > -1);
    }

    public boolean isMountedRoot(String string) {
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        return this.roots.contains(string);
    }

    public boolean isUnmountedRoot(String string) {
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        return this.unmountedRoots.contains(string);
    }

    private static JButton createButton(String string, String string2, String string3) {
        JButton jButton = new JButton(string);
        if (string2 != null && string2.length() > 0) {
            jButton.setMnemonic(string2.charAt(0));
        }
        jButton.setToolTipText(string3);
        return jButton;
    }

    class UnmountedSelectionListener
    implements ListSelectionListener {
        UnmountedSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            FileConnEventGenPanel.this.enableUnmountedButtons();
        }
    }

    class RootSelectionListener
    implements ListSelectionListener {
        RootSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            FileConnEventGenPanel.this.enableButtons();
        }
    }

    class DeleteListener
    implements ActionListener {
        DeleteListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FileConnEventGenPanel.this.deleteFS();
        }
    }

    class RemountListener
    implements ActionListener {
        RemountListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FileConnEventGenPanel.this.remountFS();
        }
    }

    class UnmountDeleteListener
    implements ActionListener {
        UnmountDeleteListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FileConnEventGenPanel.this.unmountDeleteFS();
        }
    }

    class UnmountListener
    implements ActionListener {
        UnmountListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FileConnEventGenPanel.this.unmountFS();
        }
    }

    class MountCopyListener
    implements ActionListener {
        MountCopyListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FileConnEventGenPanel.this.mountCopyFS();
        }
    }

    class MountListener
    implements ActionListener {
        MountListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FileConnEventGenPanel.this.mountFS();
        }
    }
}

