/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.fileconnection;

import com.sun.kvem.fileconnection.FileConnEventGenPanel;
import com.sun.kvem.util.ActionReflector;
import com.sun.kvem.util.StateCondition;
import com.sun.kvem.util.StateController;
import com.sun.kvem.util.ToolkitResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class RootMountName {
    private final JDialog dialog;
    private final JTextField fileSystemInput = new JTextField();
    private String newRootName;
    private FileConnEventGenPanel eventGenPanel;
    private JButton ok;
    private Pattern fsmountPattern = Pattern.compile("[a-zA-Z0-9_]*");

    public RootMountName(JFrame jFrame, FileConnEventGenPanel fileConnEventGenPanel, final File file, final File file2) {
        this.dialog = new JDialog((Frame)jFrame, true);
        this.eventGenPanel = fileConnEventGenPanel;
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        jPanel.setPreferredSize(new Dimension(250, 80));
        String string = ToolkitResources.getString((String)"FILE_CONN.REQUEST_DLG_TITLE");
        String string2 = ToolkitResources.getString((String)"FILE_CONN.REQUEST_DLG_MSG");
        this.dialog.setTitle(string);
        JLabel jLabel = new JLabel(string2);
        jLabel.setLabelFor(this.fileSystemInput);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jPanel2.add((Component)jLabel, new GridBagConstraints());
        jPanel2.add(Box.createHorizontalStrut(5), new GridBagConstraints());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.fileSystemInput, gridBagConstraints);
        jPanel.add((Component)jPanel2, "Center");
        String string3 = ToolkitResources.getString((String)"OK");
        String string4 = ToolkitResources.getString((String)"CANCEL");
        this.ok = new JButton(string3);
        this.ok.setToolTipText(ToolkitResources.getString((String)"OK_HELP"));
        this.ok.setMnemonic(ToolkitResources.getString((String)"OK_SHORTCUT").charAt(0));
        JButton jButton = new JButton(string4);
        jButton.setToolTipText(ToolkitResources.getString((String)"CANCEL_HELP"));
        jButton.setMnemonic(ToolkitResources.getString((String)"CANCEL_SHORTCUT").charAt(0));
        this.ok.setActionCommand("ok");
        jButton.setActionCommand("cancel");
        this.ok.setEnabled(false);
        StateCondition stateCondition = new StateCondition(){

            public boolean enable(Component component, DocumentEvent documentEvent) {
                return RootMountName.this.isValidRoot(file, file2, RootMountName.this.fileSystemInput.getText());
            }
        };
        this.fileSystemInput.getDocument().addDocumentListener((DocumentListener)new StateController((Component)this.ok, stateCondition));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(2, 0, 0));
        jPanel3.add(this.ok);
        jPanel3.add(Box.createHorizontalStrut(4));
        jPanel3.add(jButton);
        jPanel.add((Component)jPanel3, "South");
        ActionReflector actionReflector = new ActionReflector((Object)this);
        this.ok.addActionListener((ActionListener)actionReflector);
        jButton.addActionListener((ActionListener)actionReflector);
        this.fileSystemInput.setActionCommand("ok");
        this.fileSystemInput.addActionListener((ActionListener)actionReflector);
        this.dialog.getContentPane().add(jPanel);
        this.dialog.pack();
        this.dialog.setResizable(true);
        Rectangle rectangle = jFrame.getBounds();
        Point point = new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
        Dimension dimension = this.dialog.getSize();
        this.dialog.setLocation(point.x - dimension.width / 2, point.y - dimension.height / 2);
    }

    public void ok() {
        if (this.ok.isEnabled()) {
            this.newRootName = this.fileSystemInput.getText();
            this.dialog.setVisible(false);
        }
    }

    public void cancel() {
        this.newRootName = null;
        this.dialog.setVisible(false);
    }

    public String getNewRootName() {
        this.newRootName = null;
        this.dialog.setVisible(true);
        return this.newRootName;
    }

    public String getNewRootName(String string) {
        this.fileSystemInput.setText(string);
        this.dialog.setVisible(true);
        return this.newRootName;
    }

    private boolean isValidRoot(File file, File file2, String string) {
        if (string == null) {
            return false;
        }
        if (new File(file, string).exists()) {
            return false;
        }
        if (new File(file2, string).exists()) {
            return false;
        }
        if (this.eventGenPanel.isUnmountedRoot(string)) {
            return false;
        }
        int n = string.length();
        if (string.endsWith("/") || string.endsWith(File.separator)) {
            string = string.substring(0, --n);
        }
        if (n == 0) {
            return false;
        }
        if (string.indexOf(File.separatorChar) != -1 || string.indexOf("/") != -1) {
            return false;
        }
        try {
            if (!this.fsmountPattern.matcher(string).matches()) {
                return false;
            }
            File file3 = new File(file, string);
            if (file3.exists() && !file3.isDirectory()) {
                return false;
            }
            File file4 = new File(file2, string);
            if (file4.exists() && !file4.isDirectory()) {
                return false;
            }
            file = file.getCanonicalFile();
            file2 = file2.getCanonicalFile();
            try {
                return file3.getCanonicalFile().getParentFile().equals(file) || file4.getCanonicalFile().getParentFile().equals(file2);
            }
            catch (IOException iOException) {
                return false;
            }
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

