/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.devicedetection.rapiclient;

import com.sun.jme.toolkit.devicedetection.rapiclient.ConnectionInfo;
import com.sun.jme.toolkit.devicedetection.rapiclient.RapiConnectionListener;
import com.sun.jme.toolkit.devicedetection.rapiclient.RapiException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.log4j.Logger;

public final class RapiClientService {
    private static final Logger logger;
    private final Set<RapiConnectionListener> rapiConnectionListeners = new CopyOnWriteArraySet<RapiConnectionListener>();
    private final Object notificationLock = new Object();
    private long nativeData;

    public RapiClientService() {
        this.initialize();
    }

    public void addConnectionListener(RapiConnectionListener rapiConnectionListener) {
        this.rapiConnectionListeners.add(rapiConnectionListener);
    }

    public void removeConnectionListener(RapiConnectionListener rapiConnectionListener) {
        this.rapiConnectionListeners.remove(rapiConnectionListener);
    }

    public void start() {
        try {
            this.startNative();
        }
        catch (RapiException rapiException) {
            logger.debug((Object)rapiException.getMessage());
        }
    }

    public void stop() {
        this.stopNative();
    }

    public ConnectionInfo[] getConnectedDevices() {
        try {
            Object[] objectArray = this.getConnectedDevicesNative();
            int n = objectArray.length / 3;
            ConnectionInfo[] connectionInfoArray = new ConnectionInfo[n];
            int n2 = 0;
            int n3 = 0;
            while (n2 < n) {
                connectionInfoArray[n2] = this.createConnectionInfo((String)objectArray[n3], (byte[])objectArray[n3 + 1], (byte[])objectArray[n3 + 2]);
                ++n2;
                n3 += 3;
            }
            return connectionInfoArray;
        }
        catch (RapiException rapiException) {
            logger.debug((Object)rapiException.getMessage());
        }
        catch (UnknownHostException unknownHostException) {
            logger.debug((Object)unknownHostException.getMessage());
        }
        return new ConnectionInfo[0];
    }

    private native void initialize() throws IllegalStateException;

    private native void startNative() throws RapiException;

    private native void stopNative();

    private native Object[] getConnectedDevicesNative() throws RapiException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deviceConnected(String string, byte[] byArray, byte[] byArray2) {
        Object object = this.notificationLock;
        synchronized (object) {
            try {
                RapiClientService.fixContextClassLoader();
                ConnectionInfo connectionInfo = this.createConnectionInfo(string, byArray, byArray2);
                for (RapiConnectionListener rapiConnectionListener : this.rapiConnectionListeners) {
                    rapiConnectionListener.deviceConnected(connectionInfo);
                }
            }
            catch (UnknownHostException unknownHostException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deviceDisconnected(String string) {
        Object object = this.notificationLock;
        synchronized (object) {
            try {
                RapiClientService.fixContextClassLoader();
                for (RapiConnectionListener rapiConnectionListener : this.rapiConnectionListeners) {
                    rapiConnectionListener.deviceDisconnected(string);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void fixContextClassLoader() {
        Thread.currentThread().setContextClassLoader(RapiClientService.class.getClassLoader());
    }

    private ConnectionInfo createConnectionInfo(String string, byte[] byArray, byte[] byArray2) throws UnknownHostException {
        return new ConnectionInfo(string, InetAddress.getByAddress(byArray), InetAddress.getByAddress(byArray2));
    }

    static {
        System.loadLibrary("rapiclient");
        logger = Logger.getLogger(RapiClientService.class);
    }
}

