/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.publickeystore;

import com.sun.midp.publickeystore.InputStorage;
import java.io.IOException;

public class PublicKeyInfo {
    public static final byte OWNER_TAG = 1;
    public static final byte NOT_BEFORE_TAG = 2;
    public static final byte NOT_AFTER_TAG = 3;
    public static final byte MODULUS_TAG = 4;
    public static final byte EXPONENT_TAG = 5;
    public static final byte DOMAIN_TAG = 6;
    public static final byte ENABLED_TAG = 7;
    private String owner;
    private long notBefore;
    private long notAfter;
    private byte[] modulus;
    private byte[] exponent;
    private String domain;
    boolean enabled;

    static PublicKeyInfo getKeyFromStorage(InputStorage inputStorage) throws IOException {
        byte[] byArray = new byte[1];
        Object object = inputStorage.readValue(byArray);
        if (object == null) {
            return null;
        }
        if (byArray[0] != 1) {
            throw new IOException("public key storage corrupted");
        }
        String string = (String)object;
        object = inputStorage.readValue(byArray);
        if (byArray[0] != 2) {
            throw new IOException("public key storage corrupted");
        }
        long l = (Long)object;
        object = inputStorage.readValue(byArray);
        if (byArray[0] != 3) {
            throw new IOException("public key storage corrupted");
        }
        long l2 = (Long)object;
        object = inputStorage.readValue(byArray);
        if (byArray[0] != 4) {
            throw new IOException("public key storage corrupted");
        }
        byte[] byArray2 = (byte[])object;
        object = inputStorage.readValue(byArray);
        if (byArray[0] != 5) {
            throw new IOException("public key storage corrupted");
        }
        byte[] byArray3 = (byte[])object;
        object = inputStorage.readValue(byArray);
        if (byArray[0] != 6) {
            throw new IOException("public key storage corrupted");
        }
        String string2 = (String)object;
        object = inputStorage.readValue(byArray);
        if (byArray[0] != 7) {
            throw new IOException("public key storage corrupted");
        }
        boolean bl = object instanceof String ? ((String)object).equals("enabled") : ((Boolean)object).booleanValue();
        return new PublicKeyInfo(string, l, l2, byArray2, byArray3, string2, bl);
    }

    public PublicKeyInfo(String string, long l, long l2, byte[] byArray, byte[] byArray2, String string2, boolean bl) {
        this.owner = string;
        this.notBefore = l;
        this.notAfter = l2;
        this.modulus = byArray;
        this.exponent = byArray2;
        this.domain = string2;
        this.enabled = bl;
    }

    public PublicKeyInfo(String string, long l, long l2, byte[] byArray, byte[] byArray2, String string2) {
        this(string, l, l2, byArray, byArray2, string2, true);
    }

    public String getOwner() {
        return this.owner;
    }

    public long getNotBefore() {
        return this.notBefore;
    }

    public long getNotAfter() {
        return this.notAfter;
    }

    public byte[] getModulus() {
        byte[] byArray = new byte[this.modulus.length];
        System.arraycopy(this.modulus, 0, byArray, 0, this.modulus.length);
        return byArray;
    }

    public byte[] getExponent() {
        byte[] byArray = new byte[this.exponent.length];
        System.arraycopy(this.exponent, 0, byArray, 0, this.exponent.length);
        return byArray;
    }

    public String getDomain() {
        if (this.domain == null) {
            return "untrusted";
        }
        return this.domain;
    }

    public void setDomain(String string) {
        if (string != null) {
            return;
        }
        this.domain = string;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

