/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.publickeystore;

import com.sun.midp.publickeystore.InputStorage;
import com.sun.midp.publickeystore.PublicKeyInfo;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class PublicKeyStore {
    private Vector keyList = null;

    protected PublicKeyStore() {
    }

    public PublicKeyStore(InputStream inputStream) throws IOException {
        this.initPublicKeyStore(inputStream, new Vector());
    }

    public PublicKeyStore(InputStream inputStream, Vector vector) throws IOException {
        this.initPublicKeyStore(inputStream, vector);
    }

    protected void initPublicKeyStore(Vector vector) {
        if (this.keyList != null) {
            return;
        }
        this.keyList = vector;
    }

    protected void initPublicKeyStore(InputStream inputStream, Vector vector) throws IOException {
        InputStorage inputStorage = new InputStorage(inputStream);
        if (this.keyList != null) {
            return;
        }
        this.keyList = vector;
        PublicKeyInfo publicKeyInfo;
        while ((publicKeyInfo = PublicKeyInfo.getKeyFromStorage(inputStorage)) != null) {
            this.keyList.addElement(publicKeyInfo);
        }
        return;
    }

    public synchronized PublicKeyInfo getKey(int n) {
        return (PublicKeyInfo)this.keyList.elementAt(n);
    }

    public synchronized Vector findKeys(String string) {
        Vector<PublicKeyInfo> vector = null;
        for (int i = 0; i < this.keyList.size(); ++i) {
            PublicKeyInfo publicKeyInfo = (PublicKeyInfo)this.keyList.elementAt(i);
            if (publicKeyInfo.getOwner().compareTo(string) != 0) continue;
            if (vector == null) {
                vector = new Vector<PublicKeyInfo>();
            }
            vector.addElement(publicKeyInfo);
        }
        return vector;
    }

    public synchronized Vector getKeys() {
        Vector vector = new Vector(this.keyList.size());
        for (int i = 0; i < this.keyList.size(); ++i) {
            Object e = this.keyList.elementAt(i);
            vector.addElement(e);
        }
        return vector;
    }

    public synchronized int numberOfKeys() {
        return this.keyList.size();
    }
}

