/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.remoting;

import com.sun.jme.remoting.CommException;
import com.sun.jme.remoting.DataRecv;
import com.sun.jme.remoting.DataSend;
import com.sun.jme.remoting.SerializableObject;

public final class Version
implements SerializableObject {
    private short major;
    private short minor;
    private short micro;

    public Version() {
    }

    public Version(short s, short s2, short s3) {
        this.major = s;
        this.minor = s2;
        this.micro = s3;
    }

    public Version(String string) throws IllegalArgumentException {
        String[] stringArray = new String[3];
        int n = Version.splitVersionString(stringArray, string);
        if (n < 2) {
            throw new IllegalArgumentException("Version string needs to have at least 2 parts!");
        }
        try {
            this.major = Short.parseShort(stringArray[0]);
            this.minor = Short.parseShort(stringArray[1]);
            if (stringArray[2] != null) {
                this.micro = Short.parseShort(stringArray[2]);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Unsupported version string: " + numberFormatException.getMessage());
        }
    }

    public short getMajor() {
        return this.major;
    }

    public short getMinor() {
        return this.minor;
    }

    public short getMicro() {
        return this.micro;
    }

    @Override
    public void sendObject(DataSend dataSend) throws CommException {
        dataSend.sendShort(this.major);
        dataSend.sendShort(this.minor);
        dataSend.sendShort(this.micro);
    }

    @Override
    public void recvObject(DataRecv dataRecv) throws CommException {
        short s = dataRecv.recvShort();
        short s2 = dataRecv.recvShort();
        short s3 = dataRecv.recvShort();
        this.major = s;
        this.minor = s2;
        this.micro = s3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Version)) {
            return false;
        }
        Version version = (Version)object;
        return this.major == version.major && this.minor == version.minor && this.micro == version.micro;
    }

    public int hashCode() {
        int n = 7;
        n = 73 * n + this.major;
        n = 73 * n + this.minor;
        n = 73 * n + this.micro;
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.major);
        stringBuffer.append('.');
        stringBuffer.append(this.minor);
        if (this.micro != 0) {
            stringBuffer.append('.');
            stringBuffer.append(this.micro);
        }
        return stringBuffer.toString();
    }

    public int compareTo(Version version) {
        if (this.major != version.major) {
            return this.major - version.major;
        }
        if (this.minor != version.minor) {
            return this.minor - version.minor;
        }
        return this.micro - version.micro;
    }

    private static int splitVersionString(String[] stringArray, String string) throws IllegalArgumentException {
        int n = 0;
        int n2 = 0;
        int n3 = string.indexOf(46);
        while (n < stringArray.length && n3 != -1) {
            stringArray[n++] = string.substring(n2, n3);
            n2 = n3 + 1;
            n3 = string.indexOf(46, n2);
        }
        if (n == stringArray.length) {
            throw new IllegalArgumentException("Version string has too many parts!");
        }
        stringArray[n++] = string.substring(n2);
        return n;
    }
}

