/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.cdc;

import com.sun.kvem.cdc.GraphicsBridge;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.HashMap;
import java.util.Map;

public class FontDescriptor {
    private static final Map<Integer, Font> map = new HashMap<Integer, Font>();
    private static int nextID;

    public static synchronized int create(String string, int n, int n2) {
        Font font = new Font(string, n2, n);
        int n3 = FontDescriptor.nextID();
        map.put(n3, font);
        return n3;
    }

    public static synchronized Font getFont(Integer n) {
        return map.get(n);
    }

    public static void dispose(int n) {
        map.remove(n);
    }

    public static int[] getFontData(Integer n) {
        FontMetrics fontMetrics = FontDescriptor.getFontMetrics(n);
        return new int[]{fontMetrics.getAscent(), fontMetrics.getDescent(), fontMetrics.getLeading(), fontMetrics.getHeight(), fontMetrics.getMaxAscent(), fontMetrics.getMaxDescent(), fontMetrics.getMaxAdvance()};
    }

    private static FontMetrics getFontMetrics(Integer n) {
        return GraphicsBridge.map.get(0).getGraphics().getFontMetrics(FontDescriptor.getFont(n));
    }

    public static int getCharsWidth(Integer n, char[] cArray) {
        return FontDescriptor.getFontMetrics(n).charsWidth(cArray, 0, cArray.length);
    }

    public static int[] getCharWidths(Integer n, char[] cArray) {
        FontMetrics fontMetrics = FontDescriptor.getFontMetrics(n);
        int[] nArray = new int[cArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            nArray[i] = fontMetrics.charWidth(c);
        }
        return nArray;
    }

    private static int nextID() {
        return ++nextID;
    }
}

