/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.cdc;

import com.sun.kvem.DeviceActivation;
import com.sun.kvem.IconManager;
import com.sun.kvem.Orientation;
import com.sun.kvem.OrientationSupport;
import com.sun.kvem.cdc.GraphicsDescriptor;
import com.sun.kvem.cdc.ImageDescriptor;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class GraphicsBridge {
    public static final Logger LOGGER = Logger.getLogger(GraphicsBridge.class);
    private static DeviceActivation deviceActivation;
    static final Map<Integer, GraphicsDescriptor> map;
    private static int delay;
    private static OrientationSupport orientationSupport;
    static JComponent screenComponent;
    private static IconManager iconManager;
    private static AffineTransform[] xformation;

    public void setOrientationSupport(OrientationSupport orientationSupport) {
        GraphicsBridge.orientationSupport = orientationSupport;
    }

    public static void setDelay(int n) {
        delay = n;
    }

    public static void setDeviceActivation(DeviceActivation deviceActivation) {
        GraphicsBridge.deviceActivation = deviceActivation;
    }

    public static void setScreenComponent(JComponent jComponent) {
        screenComponent = jComponent;
    }

    public static void setIconManager(IconManager iconManager) {
        GraphicsBridge.iconManager = iconManager;
    }

    public void addGraphicsDescriptor(GraphicsDescriptor graphicsDescriptor) {
        map.put(GraphicsDescriptor.nextID(), graphicsDescriptor);
    }

    public static GraphicsDescriptor findGraphicsDescriptor(int n) {
        return map.get(n);
    }

    public static void initialize() {
        if (deviceActivation != null) {
            deviceActivation.setActiveWithLock(true);
        }
    }

    public static void drawLine(Integer n, int n2, int n3, int n4, int n5) {
        GraphicsBridge.findGraphicsDescriptor(n).getGraphics().drawLine(n2, n3, n4, n5);
    }

    public static void clearRect(Integer n, int n2, int n3, int n4, int n5, int n6) {
        GraphicsDescriptor.setBackground(n, n6);
        Graphics2D graphics2D = GraphicsBridge.findGraphicsDescriptor(n).getGraphics();
        graphics2D.clearRect(n2, n3, n4, n5);
    }

    public static void drawRect(Integer n, int n2, int n3, int n4, int n5, boolean bl, int n6, int n7) {
        GraphicsBridge.findGraphicsDescriptor(n).drawRect(n2, n3, n4, n5, bl, n6, n7);
    }

    public static void drawRegion(Integer n, Integer n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        Graphics2D graphics2D = GraphicsBridge.findGraphicsDescriptor(n).getGraphics();
        ImageDescriptor imageDescriptor = ImageDescriptor.map.get(n2);
        double d = n8;
        double d2 = n9;
        double d3 = (double)n5 / 2.0;
        double d4 = (double)n6 / 2.0;
        BufferedImage bufferedImage = imageDescriptor.image.getSubimage(n3, n4, n5, n6);
        AffineTransform affineTransform = n7 < 4 ? AffineTransform.getTranslateInstance(d + d3, d2 + d4) : AffineTransform.getTranslateInstance(d + d4, d2 + d3);
        affineTransform.concatenate(xformation[n7]);
        affineTransform.translate(-d3, -d4);
        graphics2D.drawImage(bufferedImage, affineTransform, screenComponent);
    }

    public static void copyArea(Integer n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        GraphicsBridge.findGraphicsDescriptor(n).getGraphics().copyArea(n2, n3, n4, n5, n6 - n2, n7 - n3);
    }

    public static void drawRGB(Integer n, int[] nArray, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        GraphicsBridge.findGraphicsDescriptor(n).drawRGB(nArray, n2, n3, n4, n5, n6, n7, bl);
    }

    public static synchronized void drawFrameBuffer32(ByteBuffer byteBuffer) {
        GraphicsBridge.drawRGB32Data(byteBuffer, 0);
    }

    public static synchronized void drawRGB32Data(ByteBuffer byteBuffer, int n) {
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        GraphicsBridge.findGraphicsDescriptor(n).drawRgb32(byteBuffer);
    }

    public static synchronized void drawFrameBuffer16(ByteBuffer byteBuffer) {
        GraphicsBridge.drawRGB16Data(byteBuffer, 0);
    }

    public static synchronized void drawRGB16Data(ByteBuffer byteBuffer, int n) {
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (orientationSupport.isOrientationChangeCompleted()) {
            GraphicsBridge.findGraphicsDescriptor(n).drawRgb16(byteBuffer);
        } else {
            LOGGER.warn((Object)"drawRGB16Data ignored");
        }
    }

    public static synchronized void screenRotated(int n, boolean bl, boolean bl2) {
        LOGGER.info((Object)("screen rotated: upsideDown=" + bl2 + ", reverseOrientation=" + bl));
        Orientation orientation = GraphicsBridge.toOrientation(bl, bl2);
        GraphicsBridge.findGraphicsDescriptor(n).screenRotated(orientation);
        orientationSupport.setActiveOrientation(orientation);
    }

    private static Orientation toOrientation(boolean bl, boolean bl2) {
        if (bl2) {
            return bl ? Orientation.RIGHT : Orientation.UPSIDE_DOWN;
        }
        return bl ? Orientation.LEFT : Orientation.NORMAL;
    }

    public static void drawArc(Integer n, int n2, int n3, int n4, int n5, boolean bl, int n6, int n7) {
        Graphics2D graphics2D = GraphicsBridge.findGraphicsDescriptor(n).getGraphics();
        if (!bl && n4 == 0 && n5 == 0 && n6 == 0 && n7 == 360) {
            graphics2D.drawLine(n2, n3, n2, n3);
            return;
        }
        if (bl) {
            graphics2D.fillArc(n2, n3, n4, n5, n6, n7);
        } else {
            graphics2D.drawArc(n2, n3, n4, n5, n6, n7);
        }
    }

    public static void drawChars(Integer n, char[] cArray, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer(cArray.length);
        for (int i = 0; i < cArray.length; ++i) {
            if (Character.isISOControl(cArray[i])) continue;
            stringBuffer.append(cArray[i]);
        }
        GraphicsBridge.findGraphicsDescriptor(n).getGraphics().drawString(stringBuffer.toString(), n2, n3);
    }

    public static int setWarningString(String string) {
        Graphics2D graphics2D = GraphicsBridge.findGraphicsDescriptor(0).getGraphics();
        graphics2D.setFont(new Font("Dialog", 0, 12));
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        ImageDescriptor imageDescriptor = ImageDescriptor.map.get(0);
        if (string != null) {
            int n = fontMetrics.getHeight() - fontMetrics.getLeading();
            Insets insets = new Insets(1, 0, 1, 0);
            graphics2D.setColor(Color.LIGHT_GRAY);
            graphics2D.fillRect(0, imageDescriptor.height - n - insets.top - insets.bottom, imageDescriptor.width, n + insets.top + insets.bottom);
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawString(string, (imageDescriptor.width - fontMetrics.stringWidth(string)) / 2, imageDescriptor.height - fontMetrics.getDescent() - insets.bottom);
            return n + insets.top + insets.bottom;
        }
        return 0;
    }

    public static void drawImage(Integer n, Integer n2, int n3, int n4, int n5) {
        GraphicsDescriptor graphicsDescriptor = GraphicsBridge.findGraphicsDescriptor(n);
        graphicsDescriptor.drawImage(n2, n3, n4, n5);
    }

    public static void drawImageScaled(Integer n, int n2, int n3, int n4, int n5, Integer n6, int n7, int n8, int n9, int n10, int n11) {
        GraphicsDescriptor graphicsDescriptor = GraphicsBridge.findGraphicsDescriptor(n);
        graphicsDescriptor.drawImageScaled(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11);
    }

    public static int[] getRGB(Integer n, int n2, int n3, int n4, int n5, int n6) {
        return ImageDescriptor.map.get((Object)n).image.getRGB(n3, n4, n5, n6, null, 0, n2);
    }

    public static int[] getDisplayParams() {
        return GraphicsBridge.getScreenParams(0);
    }

    public static int[] getScreenParams(int n) {
        GraphicsDescriptor graphicsDescriptor = GraphicsBridge.findGraphicsDescriptor(n);
        if (graphicsDescriptor == null) {
            return new int[]{0, 0, 0, 0, 0, 0, 0};
        }
        return graphicsDescriptor.getScreenParams();
    }

    public static Integer createImage(int n, int n2, Integer n3) {
        return GraphicsBridge.createImageForDisplay(0, n, n2, n3);
    }

    public static Integer createImageForDisplay(int n, int n2, int n3, Integer n4) {
        return GraphicsBridge.findGraphicsDescriptor(n).createImage(n2, n3, n4);
    }

    public static int[] createImageFromData(byte[] byArray) {
        return GraphicsBridge.createImageFromDataForDisplay(byArray, 0);
    }

    public static int[] createImageFromDataForDisplay(byte[] byArray, int n) {
        return GraphicsBridge.findGraphicsDescriptor(n).createImageFromDataForDisplay(byArray);
    }

    public static int createImageFromRGB(int[] nArray, int n, int n2, boolean bl) {
        try {
            BufferedImage bufferedImage = bl ? new BufferedImage(n, n2, 2) : new BufferedImage(n, n2, 1);
            bufferedImage.setRGB(0, 0, n, n2, nArray, 0, n);
            ImageDescriptor imageDescriptor = new ImageDescriptor(bufferedImage);
            Integer n3 = ImageDescriptor.nextID();
            ImageDescriptor.map.put(n3, imageDescriptor);
            return n3;
        }
        catch (VirtualMachineError virtualMachineError) {
            return 0;
        }
        catch (RuntimeException runtimeException) {
            return 0;
        }
    }

    public static void refresh(int n, int n2, int n3, int n4) {
        GraphicsBridge.refreshDisplay(0, n, n2, n3, n4);
    }

    public static void refreshDisplay(int n, int n2, int n3, int n4, int n5) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("refresh() called for id=" + n + " x=" + n2 + " y=" + n3 + " w=" + n4 + "h=" + n5));
        }
        GraphicsBridge.findGraphicsDescriptor(n).refresh(n2, n3, n4, n5);
    }

    public static int createImageGraphics(Integer n) {
        ImageDescriptor imageDescriptor = ImageDescriptor.map.get(n);
        GraphicsDescriptor graphicsDescriptor = new GraphicsDescriptor(imageDescriptor);
        int n2 = GraphicsDescriptor.nextID();
        map.put(n2, graphicsDescriptor);
        return n2;
    }

    public static void setMouseCursor(int n) {
        try {
            screenComponent.setCursor(Cursor.getPredefinedCursor(n));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            screenComponent.setCursor(Cursor.getPredefinedCursor(1));
        }
    }

    @Deprecated
    public static int getScreenResolution() {
        return GraphicsBridge.getDisplayResolution(0);
    }

    public static int getDisplayResolution(int n) {
        GraphicsBridge.findGraphicsDescriptor(n);
        return GraphicsDescriptor.getDisplayResolution();
    }

    public static void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    public static void drawTrustedIcon(boolean bl) {
        if (iconManager != null) {
            iconManager.setIconState("domain", bl ? "trusted" : "off");
        }
    }

    public static void drawShutterFeedbackIcon(boolean bl) {
        if (iconManager != null) {
            iconManager.setIconState("shutter", bl ? "on" : "enable");
        }
    }

    public static void drawShutterEnabledIcon(boolean bl) {
        if (iconManager != null) {
            iconManager.setIconState("shutter", bl ? "enable" : "off");
        }
    }

    public static void drawFlashIcon(int n) {
        if (iconManager != null) {
            switch (n) {
                case 0: {
                    iconManager.setIconState("flash", "off");
                    break;
                }
                case 1: {
                    iconManager.setIconState("flash", "no");
                    break;
                }
                case 2: {
                    iconManager.setIconState("flash", "auto");
                    break;
                }
                case 3: {
                    iconManager.setIconState("flash", "autoRed");
                    break;
                }
                case 4: {
                    iconManager.setIconState("flash", "force");
                    break;
                }
                case 5: {
                    iconManager.setIconState("flash", "forceRed");
                    break;
                }
                case 6: {
                    iconManager.setIconState("flash", "reduced");
                }
            }
        }
    }

    static {
        map = new HashMap<Integer, GraphicsDescriptor>();
        screenComponent = null;
        iconManager = null;
        xformation = new AffineTransform[8];
        GraphicsBridge.xformation[0] = new AffineTransform();
        GraphicsBridge.xformation[1] = AffineTransform.getRotateInstance(Math.PI);
        xformation[1].scale(-1.0, 1.0);
        GraphicsBridge.xformation[2] = AffineTransform.getScaleInstance(-1.0, 1.0);
        GraphicsBridge.xformation[3] = AffineTransform.getRotateInstance(Math.PI);
        GraphicsBridge.xformation[4] = AffineTransform.getRotateInstance(-1.5707963267948966);
        xformation[4].scale(-1.0, 1.0);
        GraphicsBridge.xformation[5] = AffineTransform.getRotateInstance(1.5707963267948966);
        GraphicsBridge.xformation[6] = AffineTransform.getRotateInstance(-1.5707963267948966);
        GraphicsBridge.xformation[7] = AffineTransform.getRotateInstance(1.5707963267948966);
        xformation[7].scale(-1.0, 1.0);
    }
}

