/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.cdc;

import com.sun.kvem.Device;
import com.sun.kvem.Orientation;
import com.sun.kvem.ScreenImage;
import com.sun.kvem.cdc.FontDescriptor;
import com.sun.kvem.cdc.GraphicsBridge;
import com.sun.kvem.cdc.ImageDescriptor;
import com.sun.kvem.cdc.JPEGProcessor;
import com.sun.kvem.cdc.PNGProcessor;
import com.sun.kvem.png.PNGImageReaderSpi;
import com.sun.kvem.wbmp.WBMPImageReaderSpi;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.ByteArrayInputStream;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.apache.log4j.Logger;

public class GraphicsDescriptor {
    public static final Logger LOGGER = Logger.getLogger(GraphicsDescriptor.class);
    private ImageDescriptor imageDescriptor;
    private Graphics2D graphics;
    static int nextID;
    private BufferedImage frameBuffer;
    static MediaTracker tracker;
    private static PNGProcessor PNGp;
    private static JPEGProcessor JPEGp;
    public boolean fullScreen;
    public static final String DPI_X = "screen.dpi.x";
    public static final String DPI_Y = "screen.dpi.y";
    private static byte[][] gifPrefix;
    private static byte[] wbmpPrefix;

    public void setFullScreenMode(boolean bl) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("Grabbed fullscreen mode: %s", bl ? "on" : "off"));
        }
        this.fullScreen = bl;
        this.imageDescriptor.screen.setFullScreenMode(bl);
        if (!this.fullScreen) {
            this.imageDescriptor.screen.updateFace();
        }
    }

    public GraphicsDescriptor() {
    }

    public void setImageDescriptor(ImageDescriptor imageDescriptor) {
        this.imageDescriptor = imageDescriptor;
    }

    public void create() {
        this.init(this.imageDescriptor);
        this.frameBuffer = new BufferedImage(this.imageDescriptor.width, this.imageDescriptor.height, 2);
    }

    GraphicsDescriptor(ImageDescriptor imageDescriptor) {
        this.init(imageDescriptor);
    }

    private void init(ImageDescriptor imageDescriptor) {
        this.imageDescriptor = imageDescriptor;
        this.graphics = imageDescriptor.screen.getGraphics();
        this.graphics.translate(imageDescriptor.x, imageDescriptor.y);
        this.setClip(0, 0, imageDescriptor.width, imageDescriptor.height);
    }

    GraphicsDescriptor(GraphicsDescriptor graphicsDescriptor) {
        this.imageDescriptor = graphicsDescriptor.imageDescriptor;
        this.graphics = (Graphics2D)graphicsDescriptor.graphics.create();
    }

    private void setClip(int n, int n2, int n3, int n4) {
        int n5 = Math.max(n, 0);
        int n6 = Math.max(n2, 0);
        int n7 = Math.min(n + n3, this.imageDescriptor.width);
        int n8 = Math.min(n2 + n4, this.imageDescriptor.height);
        this.graphics.setClip(n5, n6, n7 - n5, n8 - n6);
    }

    public Graphics2D getGraphics() {
        return this.graphics;
    }

    private void dispose() {
        this.graphics.dispose();
    }

    public static synchronized void dispose(Integer n) {
        GraphicsBridge.map.get(n).dispose();
        GraphicsBridge.map.remove(n);
    }

    public static synchronized Integer create(Integer n) {
        ImageDescriptor imageDescriptor = ImageDescriptor.map.get(n);
        GraphicsDescriptor graphicsDescriptor = new GraphicsDescriptor(imageDescriptor);
        Integer n2 = GraphicsDescriptor.nextID();
        GraphicsBridge.map.put(n2, graphicsDescriptor);
        return n2;
    }

    public static synchronized void setForeground(Integer n, int n2) {
        GraphicsDescriptor graphicsDescriptor = GraphicsBridge.map.get(n);
        graphicsDescriptor.getGraphics().setColor(new Color(graphicsDescriptor.imageDescriptor.screen.getFilter().filterRGB(n2)));
    }

    public static synchronized void setBackground(Integer n, int n2) {
        GraphicsDescriptor graphicsDescriptor = GraphicsBridge.map.get(n);
        graphicsDescriptor.getGraphics().setBackground(new Color(graphicsDescriptor.imageDescriptor.screen.getFilter().filterRGB(n2)));
    }

    public static synchronized void setFont(Integer n, Integer n2) {
        GraphicsBridge.map.get(n).getGraphics().setFont(FontDescriptor.getFont(n2));
    }

    public static synchronized void setClip(Integer n, int n2, int n3, int n4, int n5) {
        GraphicsBridge.map.get(n).setClip(n2, n3, n4, n5);
    }

    static synchronized int nextID() {
        return nextID++;
    }

    public static Integer cloneID(Integer n) {
        Integer n2 = new Integer(GraphicsDescriptor.nextID());
        GraphicsBridge.map.put(n2, new GraphicsDescriptor(GraphicsBridge.map.get(n)));
        return n2;
    }

    void setGraphics(Graphics2D graphics2D) {
        this.graphics = graphics2D;
    }

    void drawRgb16(ByteBuffer byteBuffer) {
        Graphics2D graphics2D = this.getGraphics();
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.Src);
        int[] nArray = ((DataBufferInt)this.frameBuffer.getRaster().getDataBuffer()).getData();
        byte[] byArray = byteBuffer.array();
        this.imageDescriptor.screen.getFilter().filterPixelsToDestination16(byArray, byteBuffer.remaining(), nArray, this.imageDescriptor.width);
        graphics2D.drawImage((Image)this.frameBuffer, 0, 0, GraphicsBridge.screenComponent);
        graphics2D.setComposite(composite);
    }

    void drawRgb32(ByteBuffer byteBuffer) {
        Graphics2D graphics2D = this.getGraphics();
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.Src);
        int[] nArray = ((DataBufferInt)this.frameBuffer.getRaster().getDataBuffer()).getData();
        byte[] byArray = byteBuffer.array();
        this.imageDescriptor.screen.getFilter().filterPixelsToDestination32(byArray, byteBuffer.remaining(), nArray, this.imageDescriptor.width);
        graphics2D.drawImage((Image)this.frameBuffer, 0, 0, GraphicsBridge.screenComponent);
        graphics2D.setComposite(composite);
    }

    void screenRotated(Orientation orientation) {
        LOGGER.info((Object)("screen rotated: orientation=" + orientation));
        this.imageDescriptor.screen.notifyScreenRotated(orientation);
    }

    void refresh(int n, int n2, int n3, int n4) {
        this.imageDescriptor.screen.update(n, n2, n3, n4);
    }

    void drawRGB(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        Graphics2D graphics2D = this.getGraphics();
        BufferedImage bufferedImage = new BufferedImage(n5, n6, 2);
        Composite composite = graphics2D.getComposite();
        if (!bl) {
            graphics2D.setComposite(AlphaComposite.Src);
            int n7 = 0;
            while (n7 < nArray.length) {
                int n8 = n7++;
                nArray[n8] = nArray[n8] | 0xFF000000;
            }
        }
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = this.imageDescriptor.screen.getFilter().filterRGB(nArray[i]);
        }
        bufferedImage.setRGB(0, 0, n5, n6, nArray2, n, n2);
        graphics2D.drawImage((Image)bufferedImage, n3, n4, GraphicsBridge.screenComponent);
        graphics2D.setComposite(composite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void drawRect(int n, int n2, int n3, int n4, boolean bl, int n5, int n6) {
        Graphics2D graphics2D = this.getGraphics();
        if (!bl && n3 == 0 && n4 == 0) {
            graphics2D.drawLine(n, n2, n, n2);
            return;
        }
        n5 = Math.max(n5, 0);
        n6 = Math.max(n6, 0);
        ScreenImage screenImage = this.imageDescriptor.screen;
        synchronized (screenImage) {
            if (bl) {
                graphics2D.fillRoundRect(n, n2, n3, n4, n5, n6);
            } else {
                graphics2D.drawRoundRect(n, n2, n3, n4, n5, n6);
            }
        }
    }

    void drawImage(Integer n, int n2, int n3, int n4) {
        Graphics2D graphics2D = this.getGraphics();
        ImageDescriptor imageDescriptor = ImageDescriptor.map.get(n);
        Rectangle rectangle = graphics2D.getClipBounds();
        int n5 = Math.max(rectangle.x, n2);
        int n6 = imageDescriptor.x + n5 - n2;
        int n7 = Math.min(rectangle.x + rectangle.width, n2 + imageDescriptor.width);
        int n8 = imageDescriptor.x + n7 - n5;
        int n9 = Math.max(rectangle.y, n3);
        int n10 = imageDescriptor.y + n9 - n3;
        int n11 = Math.min(rectangle.y + rectangle.height, n3 + imageDescriptor.height);
        int n12 = imageDescriptor.y + n11 - n9;
        Color color = new Color(this.imageDescriptor.screen.getFilter().filterRGB(n4));
        graphics2D.drawImage(imageDescriptor.image, n5, n9, n7, n11, n6, n8, n10, n12, color, GraphicsBridge.screenComponent);
    }

    void drawImageScaled(int n, int n2, int n3, int n4, Integer n5, int n6, int n7, int n8, int n9, int n10) {
        Graphics2D graphics2D = this.getGraphics();
        ImageDescriptor imageDescriptor = ImageDescriptor.map.get(n5);
        Color color = new Color(this.imageDescriptor.screen.getFilter().filterRGB(n10));
        graphics2D.drawImage(imageDescriptor.image, n, n2, n3, n4, n6 + imageDescriptor.x, n8 + imageDescriptor.x, n7 + imageDescriptor.y, n9 + imageDescriptor.y, color, GraphicsBridge.screenComponent);
    }

    int[] getScreenParams() {
        LOGGER.debug((Object)("getScreenParams will return width=" + this.imageDescriptor.width + ", height=" + this.imageDescriptor.height));
        boolean bl = this.imageDescriptor.screen.isColor();
        boolean bl2 = this.imageDescriptor.screen.isTouch();
        boolean bl3 = bl2;
        boolean bl4 = bl2;
        boolean bl5 = false;
        int n = Device.getBooleanProperty((String)"screenDoubleBuffer", (boolean)true) ? 1 : 0;
        return new int[]{this.imageDescriptor.width, this.imageDescriptor.height, this.imageDescriptor.height, 0xFFFFFF, 24, bl | bl3 | bl4 | bl5 | n, 256};
    }

    Integer createImage(int n, int n2, Integer n3) {
        Object object;
        BufferedImage bufferedImage;
        Object object2;
        if (n3 != 0) {
            object2 = ImageDescriptor.map.get(n3);
            GraphicsBridge.LOGGER.debug((Object)("Create image " + n3 + " from descriptor"));
            bufferedImage = new BufferedImage(((ImageDescriptor)object2).width, ((ImageDescriptor)object2).height, 2);
            object = bufferedImage.getGraphics();
            ((Graphics)object).drawImage(((ImageDescriptor)object2).image, 0, 0, ((ImageDescriptor)object2).width, ((ImageDescriptor)object2).height, ((ImageDescriptor)object2).x, ((ImageDescriptor)object2).y, ((ImageDescriptor)object2).x + ((ImageDescriptor)object2).width, ((ImageDescriptor)object2).y + ((ImageDescriptor)object2).height, GraphicsBridge.screenComponent);
            ((Graphics)object).dispose();
        } else {
            GraphicsBridge.LOGGER.debug((Object)("Create image width = " + n + ", height = " + n2));
            bufferedImage = new BufferedImage(n, n2, 2);
            object2 = bufferedImage.getGraphics();
            object = new Color(this.imageDescriptor.screen.getFilter().filterRGB(0xFFFFFF));
            ((Graphics)object2).setColor((Color)object);
            ((Graphics)object2).fillRect(0, 0, n, n2);
        }
        object2 = new ImageDescriptor(bufferedImage);
        object = ImageDescriptor.nextID();
        ImageDescriptor.map.put((Integer)object, (ImageDescriptor)object2);
        return object;
    }

    static int getDisplayResolution() {
        int n = Device.getIntegerProperty((String)DPI_X, (int)0);
        int n2 = Device.getIntegerProperty((String)DPI_Y, (int)n);
        if (n == 0) {
            n = n2;
        }
        if (n == 0) {
            return Toolkit.getDefaultToolkit().getScreenResolution();
        }
        return (n + n2) / 2;
    }

    static void prepareImage(int n) {
        while (!tracker.checkID(n)) {
            try {
                tracker.waitForID(n);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public int[] createImageFromDataForDisplay(byte[] byArray) {
        int[] nArray = new int[]{0, 0, 0};
        if (PNGp.isPNGImage(byArray) && PNGp.includesIEND(byArray, 0)) {
            nArray = this.loadImageForScreen(byArray, 0, ImageFormat.PNG);
        } else if (JPEGp.isJPEGImage(byArray)) {
            nArray = this.loadImageForScreen(byArray, 0, ImageFormat.JPEG);
        } else if (PNGProcessor.compare(gifPrefix[0], 0, byArray, 0, gifPrefix[0].length) || PNGProcessor.compare(gifPrefix[1], 0, byArray, 0, gifPrefix[1].length)) {
            nArray = this.loadImageForScreen(byArray, 0, ImageFormat.GIF);
        } else if (PNGProcessor.compare(wbmpPrefix, 0, byArray, 0, wbmpPrefix.length)) {
            nArray = this.loadImageForScreen(byArray, 0, ImageFormat.WBMP);
        }
        return nArray;
    }

    int[] loadImageForScreen(byte[] byArray, int n, ImageFormat imageFormat) {
        BufferedImage bufferedImage;
        ImageReadParam imageReadParam;
        ImageInputStream imageInputStream;
        Object object;
        Object object2;
        int[] nArray = new int[]{0, 0, 0};
        if (imageFormat == ImageFormat.PNG) {
            try {
                object2 = new PNGImageReaderSpi();
                object = ((ImageReaderSpi)object2).createReaderInstance();
                imageInputStream = ImageIO.createImageInputStream(new ByteArrayInputStream(byArray, n, byArray.length - n));
                imageReadParam = ((ImageReader)object).getDefaultReadParam();
                ((ImageReader)object).setInput(imageInputStream, true, true);
                bufferedImage = ((ImageReader)object).read(0, imageReadParam);
                nArray[1] = bufferedImage.getWidth(null);
                nArray[2] = bufferedImage.getHeight(null);
            }
            catch (Exception exception) {
                bufferedImage = null;
            }
        } else if (imageFormat == ImageFormat.GIF) {
            try {
                object2 = ImageIO.getImageReadersByMIMEType("image/gif").next();
                object = ImageIO.createImageInputStream(new ByteArrayInputStream(byArray, 0, byArray.length));
                ((ImageReader)object2).setInput(object, false, true);
                bufferedImage = ((ImageReader)object2).read(0);
                nArray[1] = bufferedImage.getWidth(null);
                nArray[2] = bufferedImage.getHeight(null);
            }
            catch (Exception exception) {
                bufferedImage = null;
            }
        } else if (imageFormat == ImageFormat.WBMP) {
            try {
                object2 = new WBMPImageReaderSpi();
                object = ((ImageReaderSpi)object2).createReaderInstance();
                imageInputStream = ImageIO.createImageInputStream(new ByteArrayInputStream(byArray, n, byArray.length - n));
                imageReadParam = ((ImageReader)object).getDefaultReadParam();
                ((ImageReader)object).setInput(imageInputStream, true, true);
                bufferedImage = ((ImageReader)object).read(0, imageReadParam);
                nArray[1] = bufferedImage.getWidth(null);
                nArray[2] = bufferedImage.getHeight(null);
            }
            catch (Exception exception) {
                LOGGER.error((Object)exception, (Throwable)exception);
                bufferedImage = null;
            }
        } else {
            object2 = Toolkit.getDefaultToolkit().createImage(byArray, n, byArray.length - n);
            tracker.addImage((Image)object2, 0);
            GraphicsDescriptor.prepareImage(0);
            if (!tracker.isErrorID(0)) {
                nArray[1] = ((Image)object2).getWidth(null);
                nArray[2] = ((Image)object2).getHeight(null);
                bufferedImage = new BufferedImage(nArray[1], nArray[2], 2);
                bufferedImage.getGraphics().drawImage((Image)object2, 0, 0, GraphicsBridge.screenComponent);
            } else {
                bufferedImage = null;
            }
            tracker.removeImage((Image)object2, 0);
        }
        if (bufferedImage != null) {
            object2 = bufferedImage.getRGB(0, 0, nArray[1], nArray[2], null, 0, nArray[1]);
            for (int i = 0; i < ((Object)object2).length; ++i) {
                object2[i] = this.imageDescriptor.screen.getFilter().filterRGB(0, 0, (int)object2[i]);
            }
            bufferedImage.setRGB(0, 0, nArray[1], nArray[2], (int[])object2, 0, nArray[1]);
            nArray[0] = ImageDescriptor.nextID();
            ImageDescriptor.map.put(nArray[0], new ImageDescriptor(bufferedImage));
        }
        return nArray;
    }

    static {
        PNGp = new PNGProcessor();
        JPEGp = new JPEGProcessor();
        gifPrefix = new byte[][]{{71, 73, 70, 56, 57, 97}, {71, 73, 70, 56, 55, 97}};
        wbmpPrefix = new byte[]{0};
    }

    private static enum ImageFormat {
        PNG,
        JPEG,
        GIF,
        WBMP;

    }
}

