/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.cdc;

import com.sun.kvem.ScreenImage;
import com.sun.kvem.ScreenSpi;
import com.sun.kvem.cdc.ImageDescriptorMBean;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;

public class ImageDescriptor
implements ImageDescriptorMBean {
    int x;
    int y;
    int width;
    int height;
    BufferedImage image;
    static final Map<Integer, ImageDescriptor> map = new HashMap<Integer, ImageDescriptor>();
    static int nextID;
    protected ScreenImage screen;

    public ImageDescriptor() {
    }

    public void setScreen(ScreenImage screenImage) {
        this.screen = screenImage;
    }

    public void create() {
        this.image = this.screen.getFaceImage();
        Rectangle rectangle = new Rectangle(0, 0, this.screen.getDimension().width, this.screen.getDimension().height);
        this.x = rectangle.x;
        this.y = rectangle.y;
        this.width = rectangle.width;
        this.height = rectangle.height;
        map.put(ImageDescriptor.nextID(), this);
    }

    ImageDescriptor(BufferedImage bufferedImage) {
        this(bufferedImage, 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    ImageDescriptor(BufferedImage bufferedImage, int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.image = bufferedImage;
        this.width = n3;
        this.height = n4;
    }

    @Override
    public int[] getData() {
        int[] nArray = new int[this.width * this.height * 4];
        return this.image.getRGB(0, 0, this.width, this.height, nArray, 0, this.width);
    }

    public static void dispose(int n) {
        map.remove(n);
    }

    static int nextID() {
        return nextID++;
    }

    static ImageDescriptor create(ScreenSpi screenSpi) {
        Rectangle rectangle = screenSpi.getDisplayBoundsInFace();
        ImageDescriptor imageDescriptor = new ImageDescriptor(screenSpi.getFaceImage(), rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        map.put(ImageDescriptor.nextID(), imageDescriptor);
        return imageDescriptor;
    }
}

